! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
! gtbinary - ϐւ̓񍀉ZqKp

! 
!   gtbinary  Zq E [IvV=l ...] 
!
! o͂ output IvV܂ gtool.nc@default
! Zq͔Cӌw. ftHgŁuZv.

subroutine help
    use sysdep
    write(*, *) "usage: gtbinary lhs operator rhs [option=value ...]"
    call AbortProgram("gtbinary")
end subroutine

program gtbinary
    use gtool
    use dc_trace, only: setdebug
    implicit none
    type(VSTRING):: lhs, rhs, output
    character(string):: operator
    type(VSTRING):: arg, optname, optvalue
    type(GT_VARIABLE):: lvar, rvar, ovar
    double precision, allocatable:: lhsbuf(:), rhsbuf(:), obuf(:)
    integer:: i, nargs, siz, stat
!--
    output = "gtool.nc@default"
    nargs = GtArgCount()
    if (nargs < 3) then
        call help
    endif
    call GtArgGet(1, lhs)
    call GtArgGet(2, optvalue)
    operator = optvalue
    call GtArgGet(3, rhs)
    do, i = 4, nargs
        call GtArgGet(i, arg)
        if (.not. gtoptionform(arg, optname, optvalue)) cycle
        if (optname == "output") then
            output = optvalue
        else if (optname == '-debug') then
            call setdebug
        endif
    enddo
    call Open(lvar, lhs)
    call Open(rvar, rhs)
    call Limit(rvar, lvar)
    call Create(ovar, url=output, copyfrom=lvar, copyvalue=.false.)
    call Slice(lvar)
    call Slice(rvar, compatible=lvar)
    call Slice(ovar, compatible=lvar)
    call Inquire(lvar, size=siz)
    allocate(lhsbuf(siz), rhsbuf(siz), obuf(siz))
    do
        call Get(lvar, lhsbuf, siz)
        call Get(rvar, rhsbuf, siz)
        call BinOp(obuf, lhsbuf(1:siz), operator, rhsbuf(1:siz), siz)
        call Put(ovar, obuf, siz)
        call Slice_Next(lvar, stat=stat);  if (stat /= 0) exit
        call Slice_Next(rvar, stat=stat);  if (stat /= 0) exit
        call Slice_Next(ovar, stat=stat);  if (stat /= 0) exit
    enddo
    call Close(lvar)
    call Close(rvar)
    call Close(ovar)

contains

subroutine binop(out, lhs, operator, rhs, n)
    integer, intent(in):: n
    double precision, intent(out):: out(n)
    character(*), intent(in):: operator
    double precision, intent(in):: lhs(n), rhs(n)
    out(1:n) = lhs(1:n) + rhs(1:n)
end subroutine

end program
