! Copyright (C) GFD Dennou Club, 2000-2001.  All rights reserved.

subroutine GTVarPutDouble(var, value, nvalue, err)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, &
        & map_to_internal_specs
    use an_generic, only: put, an_variable
    use dc_error
    implicit none
    type(GT_VARIABLE), intent(in):: var
    double precision, intent(in):: value(*)
    integer, intent(in):: nvalue
    logical, intent(out), optional:: err
    integer:: class, cid, stat, ndims
    integer, pointer:: specs(:, :)
continue
    call var_class(var, class, cid)
    call map_to_internal_specs(var, specs, ndims)
    if (class == vtb_class_netcdf) then
        call put(an_variable(cid), start=specs(:, 1), count=specs(:, 2), &
            & stride=specs(:, 3), imap=specs(:, 4), value=value, iostat=stat)
    else
	stat = gt_efake
    endif
    call StoreError(stat, "GTVarPutDouble")
    deallocate(specs)
end subroutine
