! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

! ₢킹͌^ƂɎ葱킯B

subroutine ANVarInquireI(var, ndims, dimlen)
    use an_types, only: an_variable
    use an_vartable, only: an_variable_entry, vtable_lookup
    use netcdf_f77, only: nf_noerr, nf_inq_varndims, nf_inq_vardimid, &
        & nf_inq_varndims, nf_inq_dimlen
    type(an_variable), intent(in):: var
    ! ϐ̎
    integer, intent(out), optional:: ndims
    integer, intent(out), optional:: dimlen
    type(an_variable_entry), pointer:: ent
    integer:: stat, length, i

    if (present(ndims)) ndims = -1
    if (present(dimlen)) dimlen = -1

    stat = vtable_lookup(var, ent)
    if (stat /= nf_noerr) return

    if (present(ndims)) then
        if (associated(ent%dimids)) then
            ndims = size(ent%dimids)
        else
            ndims = 0
        endif
    endif

    if (present(dimlen)) then
        dimlen = 1
        if (ent%varid > 0) then
            if (associated(ent%dimids)) then
                do, i = 1, size(ent%dimids)
                    stat = nf_inq_dimlen(ent%fileid, ent%dimids(i), length)
                    if (stat /= nf_noerr) then
                        dimlen = -1
                        exit
                    endif
                    dimlen = dimlen * length
                enddo
            endif
        else
            stat = nf_inq_dimlen(ent%fileid, ent%dimid, dimlen)
            if (stat /= nf_noerr) then
                dimlen = -1
                return
            endif
        endif
    endif
end subroutine
