! netcdf_f77.f90 - netCDF original interface module
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved
! ex: set sw=4:

! 2000-01-10 Lcpi        

!
! {W[Q netCDF IWi netcdf.inc ̑
! pׂ̂łBnetcdf.inc ւ̎QƂ͂ĂȂB
!

module netcdf_f77

    use netcdf_kind_parameter

    implicit none

!
! --- symbols ---
!

    !
    ! external netCDF data type ID
    !

    integer, parameter:: NF_BYTE = 1
    integer, parameter:: NF_INT1 = NF_BYTE
    integer, parameter:: NF_CHAR = 2
    integer, parameter:: NF_SHORT = 3
    integer, parameter:: NF_INT2 = NF_SHORT
    integer, parameter:: NF_INT = 4
    integer, parameter:: NF_FLOAT = 5
    integer, parameter:: NF_REAL = NF_FLOAT
    integer, parameter:: NF_DOUBLE = 6

    !
    ! default fill values
    !

    integer, parameter:: NF_FILL_BYTE = -127
    integer, parameter:: NF_FILL_INT1 = NF_FILL_BYTE
    integer, parameter:: NF_FILL_CHAR = 0
    integer, parameter:: NF_FILL_SHORT = -32767
    integer, parameter:: NF_FILL_INT2 = NF_FILL_SHORT
    integer, parameter:: NF_FILL_INT = -2147483647
    real, parameter:: NF_FILL_FLOAT = 9.9692099683868690e+36
    real, parameter:: NF_FILL_REAL = NF_FILL_FLOAT
    double precision, parameter:: &
            & NF_FILL_DOUBLE = 9.9692099683868690e+36

    !
    ! mode flags for opening and creating a netcdf dataset:
    !

    integer, parameter:: NF_NOWRITE = 0
    integer, parameter:: NF_WRITE = 1
    integer, parameter:: NF_CLOBBER = 0
    integer, parameter:: NF_NOCLOBBER = 4
    integer, parameter:: NF_FILL = 0
    integer, parameter:: NF_NOFILL = 256
    integer, parameter:: NF_LOCK = 1024
    integer, parameter:: NF_SHARE = 2048
    integer, parameter:: NF_SIZEHINT_DEFAULT = 0
    integer, parameter:: NF_ALIGN_CHUNK = -1

    !
    ! size argument for defining an unlimited dimension:
    !

    integer, parameter:: NF_UNLIMITED = 0

    !
    ! global attribute id:
    !

    integer, parameter:: NF_GLOBAL = 0

    !
    ! implementation limits:
    !

    integer, parameter:: NF_MAX_DIMS = 100
    integer, parameter:: NF_MAX_ATTRS = 2000
    integer, parameter:: NF_MAX_VARS = 2000
    integer, parameter:: NF_MAX_NAME = 128
    integer, parameter:: NF_MAX_VAR_DIMS = NF_MAX_DIMS

    !
    ! error codes:
    !

    integer, parameter:: NF_NOERR = 0
    integer, parameter:: NF_EBADID = -33
    integer, parameter:: NF_EEXIST = -35
    integer, parameter:: NF_EINVAL = -36
    integer, parameter:: NF_EPERM = -37
    integer, parameter:: NF_ENOTINDEFINE = -38
    integer, parameter:: NF_EINDEFINE = -39
    integer, parameter:: NF_EINVALCOORDS = -40
    integer, parameter:: NF_EMAXDIMS = -41
    integer, parameter:: NF_ENAMEINUSE = -42
    integer, parameter:: NF_ENOTATT = -43
    integer, parameter:: NF_EMAXATTS = -44
    integer, parameter:: NF_EBADTYPE = -45
    integer, parameter:: NF_EBADDIM = -46
    integer, parameter:: NF_EUNLIMPOS = -47
    integer, parameter:: NF_EMAXVARS = -48
    integer, parameter:: NF_ENOTVAR = -49
    integer, parameter:: NF_EGLOBAL = -50
    integer, parameter:: NF_ENOTNC = -51
    integer, parameter:: NF_ESTS = -52
    integer, parameter:: NF_EMAXNAME = -53
    integer, parameter:: NF_EUNLIMIT = -54
    integer, parameter:: NF_ENORECVARS = -55
    integer, parameter:: NF_ECHAR = -56
    integer, parameter:: NF_EEDGE = -57
    integer, parameter:: NF_ESTRIDE = -58
    integer, parameter:: NF_EBADNAME = -59
    integer, parameter:: NF_ERANGE = -60
    integer, parameter:: NF_ENOMEM = -61

    !
    ! error handling modes:
    !

    integer, parameter:: NF_FATAL = 1
    integer, parameter:: NF_VERBOSE = 2

!
! --- interfaces ---
!

    interface

    !
    ! --- GȊ֐ ---
    !

        ! netCDF Cũo[WԂ
        !
        function nf_inq_libvers(ncerr)
            character(len=80)::                nf_inq_libvers
            integer, intent(in)::        ncerr
        end function

        ! (hLgĂȂ֐)
        ! G[R[h netCDF ł͂Ȃ C CuɂƂ^
        !
        logical function nf_issyserr(ncerr)
            integer, intent(in)::        ncerr
        end function

        ! G[R[h netCDF ̃bZ[WԂ
        !
        character(len=80) function nf_strerror(ncerr)
            integer, intent(in)::        ncerr
        end function

        ! (hLgĂȂ֐)
        ! PE ̑炵
        !
        integer function nf_inq_base_pe(ncid, pe)
            integer, intent(in)::        ncid, pe
        end function

        ! (hLgĂȂ֐)
        ! PE ̑炵
        !
        integer function nf_set_base_pe(ncid, pe)
            integer, intent(in)::        ncid, pe
        end function

    !
    ! --- t@CEJEEbI ---
    !

        ! t@C쐬 (JꂽԂƂȂ)
        !
        integer function nf_create(path, cmode, ncid)
            character(len=*), intent(in)::        path
            integer, intent(in)::                cmode
            integer, intent(out)::                ncid
        end function

        ! (hLgĂȂ֐)
        integer function nf__create(path, cmode, initialsz, &
            & chunksizehint, ncid)
            character(len=*), intent(in)::        path
            integer, intent(in):: cmode, initialsz, chunksizehint
            integer, intent(out)::                ncid
        end function

        ! (hLgĂȂ֐)
        integer function nf__create_mp(path, cmode, initialsz, &
            & basepe, chunksizehint, ncid)
            character(len=*), intent(in)::        path
            integer, intent(in):: cmode, initialsz, basepe, chunksizehint
            integer, intent(out)::                ncid
        end function

        ! t@CJ
        !
        integer function nf_open(path, cmode, ncid)
            character(len=*), intent(in)::        path
            integer, intent(in)::                cmode
            integer, intent(out)::                ncid
        end function

        ! (hLgĂȂ֐)
        integer function nf__open(path, cmode, initialsz, &
            & chunksizehint, ncid)
            character(len=*), intent(in)::        path
            integer, intent(in):: cmode, initialsz, chunksizehint
            integer, intent(out)::                ncid
        end function

        ! (hLgĂȂ֐)
        integer function nf__open_mp(path, cmode, initialsz, &
            & basepe, chunksizehint, ncid)
            character(len=*), intent(in)::        path
            integer, intent(in):: cmode, initialsz, basepe, chunksizehint
            integer, intent(out)::                ncid
        end function

        ! fill [h̐ݒ/
        integer function nf_set_fill(ncid, fillmode, old_mode)
            integer, intent(in)::        ncid, fillmode
            integer, intent(out)::        old_mode
        end function

        ! `[hւ̈ڍs
        integer function nf_redef(ncid)
            integer, intent(in)::        ncid
        end function

        ! `[h̒Eo
        integer function nf_enddef(ncid)
            integer, intent(in)::        ncid
        end function

        ! `[h̒Eo
        ! (hLgĂȂ֐)
        integer function nf__enddef(ncid, h_minfree, v_align, &
            & v_minfree, r_align)
            integer, intent(in)::        ncid
            integer, intent(in):: h_minfree, v_align, &
                & v_minfree, r_align
        end function

        ! 
        integer function nf_sync(ncid)
            integer, intent(in)::        ncid
        end function

        ! 
        integer function nf_close(ncid)
            integer, intent(in)::        ncid
        end function

        ! ۂɒ`[hɂꍇɌĂ΂
        ! ([UĂԕKv̂Ȃ֐)
        integer function nf_abort(ncid)
            integer, intent(in)::        ncid
        end function

        ! MPp t@C̍폜
        ! (hLgĂȂ֐)
        integer function nf_delete(path)
            character(len=*), intent(in)::        path
        end function

    !
    ! --- t@C̖₢킹 ---
    !

        ! Jꂽt@C ncid ɑ΂ׂĂ̖₢킹s
        !
        integer function nf_inq(ncid, ndims, nvars, ngatts, unlimdimid)
            integer, intent(in)::        ncid
            integer, intent(out)::        ndims, nvars, ngatts
            integer, intent(out)::        unlimdimid
        end function

        !  ndims ₢킹
        integer function nf_inq_ndims(ncid, ndims)
            integer, intent(in)::        ncid
            integer, intent(out)::        ndims
        end function

        ! ϐ̐ nvars ₢킹
        integer function nf_inq_nvars(ncid, nvars)
            integer, intent(in)::        ncid
            integer, intent(out)::        nvars
        end function

        ! 摮̐ ngatts ₢킹
        integer function nf_inq_natts(ncid, ngatts)
            integer, intent(in)::        ncid
            integer, intent(out)::        ngatts
        end function

        ! ID unlimdimid ₢킹
        ! Ȃ 1 Ԃ
        integer function nf_inq_unlimdim(ncid, unlimdimid)
            integer, intent(in)::        ncid
            integer, intent(out)::        unlimdimid
        end function

    !
    ! --- Ɋւ郋[` ---
    !

        !  name,  len `
        ! 蓖Ăꂽ ID (̐)  dimid ɕԂ
        integer function nf_def_dim(ncid, name, len, dimid)
            integer, intent(in)::                ncid
            character(len=*), intent(in)::        name
            integer, intent(in)::                len
            integer, intent(out)::                dimid
        end function

        ! Oɑ΂鎟 ID ₢킹
        integer function nf_inq_dimid(ncid, name, dimid)
            integer, intent(in)::                ncid
            character(len=*), intent(in)::        name
            integer, intent(out)::                dimid
        end function

        !  ID 疼O name ƒ len ₢킹
        ! name ɂ͕KvȒȂ΂ȂȂ
        integer function nf_inq_dim(ncid, dimid, name, len)
            integer, intent(in)::                ncid
            integer, intent(in)::                dimid
            character(len=*), intent(out)::        name
            integer, intent(out)::                len
        end function

        !  ID 疼O name ₢킹
        ! name ɂ͕KvȒȂ΂ȂȂ
        integer function nf_inq_dimname(ncid, dimid, name)
            integer, intent(in)::                ncid
            integer, intent(in)::                dimid
            character(len=*), intent(out)::        name
        end function

        !  ID 璷 len ₢킹
        integer function nf_inq_dimlen(ncid, dimid, len)
            integer, intent(in)::                ncid
            integer, intent(in)::                dimid
            integer, intent(out)::                len
        end function

    !
    ! ---  ---
    !
    ! ͕^XJϐAl^złB
    ! Ƃ͕^ł͒p^Al^ł͔z̑傫łB
    ! ͕ϐ varid ɏ邩A摮ƂȂB
    ! 摮 varid ƂĂ NF_GLOBAL pB

        !
        ! --- Ɋւ₢킹 ---
        !

        ! ϐ varid ̑ name ̌^ xtype ƒ len ̖₢킹
        integer function nf_inq_att(ncid, varid, name, xtype, len)
            integer, intent(in)::        ncid, varid
            character(len=*), intent(in):: name
            integer, intent(out)::        xtype
            integer, intent(out)::        len
        end function

        ! ϐ varid ̑ name ̌^ xtype ̖₢킹
        integer function nf_inq_atttype(ncid, varid, name, xtype)
            integer, intent(in)::        ncid, varid
            character(len=*), intent(in):: name
            integer, intent(out)::        xtype
        end function

        ! ϐ varid ̑ name ̒ len ̖₢킹
        integer function nf_inq_attlen(ncid, varid, name, len)
            integer, intent(in)::        ncid, varid
            character(len=*), intent(in):: name
            integer, intent(out)::        len
        end function

        ! ϐ varid ̑ name ̔ԍ attnum ̖₢킹
        integer function nf_inq_attid(ncid, varid, name, attnum)
            integer, intent(in)::        ncid, varid
            character(len=*), intent(in):: name
            integer, intent(out)::        attnum
        end function

        ! ϐ varid ̑ attnum ̖O name ̖₢킹
        ! name ɂ͕KvȒȂ΂ȂȂ
        integer function nf_inq_attname(ncid, varid, attnum, name)
            integer, intent(in)::        ncid, varid
            integer, intent(in)::        attnum
            character(len=*), intent(out):: name
        end function

        !
        ! --- ̓ǂݏȊȎ ---
        !

        integer function nf_copy_att(ncid_in, varid_in, name, &
        & ncid_out, varid_out)
            integer, intent(in)::                ncid_in, varid_in
            character(len=*), intent(in)::        name
            integer, intent(in)::                ncid_out, varid_out
        end function

        integer function nf_rename_att(ncid, varid, curname, newname)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        curname
            character(len=*), intent(in)::        newname
        end function

        integer function nf_del_att(ncid, varid, name)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
        end function

        !
        ! --- ̐ݒ ---
        !

        integer function nf_put_att_text(ncid, varid, name, len, text)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            integer, intent(in)::                len
            character(len=*), intent(in)::        text
        end function

        integer function nf_put_att_int1(ncid, varid, name, &
        & xtype, len, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            integer, intent(in)::                xtype, len
            integer(NF_KIND_INT1), intent(in):: i1vals(*)
        end function

        integer function nf_put_att_int2(ncid, varid, name, &
        & xtype, len, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            integer, intent(in)::                xtype, len
            integer(NF_KIND_INT2), intent(in):: i2vals(*)
        end function

        integer function nf_put_att_int(ncid, varid, name, &
        & xtype, len, ivals)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            integer, intent(in)::                xtype, len
            integer, intent(in)::                ivals(*)
        end function

        integer function nf_put_att_real(ncid, varid, name, &
        & xtype, len, rvals)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            integer, intent(in)::                xtype, len
            real, intent(in)::                        rvals(*)
        end function

        integer function nf_put_att_double(ncid, varid, name, &
        & xtype, len, dvals)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            integer, intent(in)::                xtype, len
            double precision, intent(in)::        dvals(*)
        end function

        !
        ! --- ̓ǂݎ ---
        !

        integer function nf_get_att_text(ncid, varid, name, text)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            character(len=*), intent(out)::        text
        end function

        integer function nf_get_att_int1(ncid, varid, name, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            integer(NF_KIND_INT1), intent(in):: i1vals(*)
        end function

        integer function nf_get_att_int2(ncid, varid, name, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            integer(NF_KIND_INT2), intent(in):: i2vals(*)
        end function

        integer function nf_get_att_int(ncid, varid, name, ivals)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            integer, intent(in)::                ivals(*)
        end function

        integer function nf_get_att_real(ncid, varid, name, rvals)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            real, intent(in)::                        rvals(*)
        end function

        integer function nf_get_att_double(ncid, varid, name, dvals)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
            double precision, intent(in)::        dvals(*)
        end function

    !
    ! --- ϐ ---
    !
    ! ϐ͎ɂĂ܂złB
    ! `ׂĂgȂĂ͂Ȃ킯ł͂ȂB
    !

        ! O name ̕ϐ`B
        ! f[^^ xtype,  ndims Ƃ,
        ! e ID  dimids ŗ^B
        ! ϐ ID  varid ɕԂB
        integer function nf_def_var(ncid, name, &
        & xtype, ndims, dimids, varid)
            integer, intent(in)::                ncid
            character(len=*), intent(in)::        name
            integer, intent(in)::                xtype, ndims
            integer, intent(in)::                dimids(*)
            integer, intent(out)::                varid
        end function

        !
        ! --- ϐɊւ₢킹 ---
        !

        ! ϐ name  ID varid m
        integer function nf_inq_varid(ncid, name, varid)
            integer, intent(in)::                ncid
            character(len=*), intent(in)::        name
            integer, intent(out)::                varid
        end function

        ! ϐ varid 牽ł₢킹 (ȉ̊֐Q)
        ! dimids ͕Kvȑ傫Ȃ΂ȂȂ
        integer function nf_inq_var(ncid, varid, &
        & name, xtype, ndims, dimids, natts)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(out)::        name
            integer, intent(out)::                xtype, ndims, natts 
            integer, intent(out)::                dimids(*)
        end function

        ! ϐ varid ϐ name m
        ! name ɂ͕KvȒȂ΂ȂȂ
        integer function nf_inq_varname(ncid, varid, name)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(out)::        name
        end function

        ! ϐ varid ^ xtype m
        integer function nf_inq_vartype(ncid, varid, xtype)
            integer, intent(in)::                ncid, varid
            integer, intent(out)::                xtype
        end function

        ! ϐ varid 玟 ndims m
        integer function nf_inq_varndims(ncid, varid, ndims)
            integer, intent(in)::                ncid, varid
            integer, intent(out)::                ndims
        end function

        ! ϐ varid 玟ID z dimids 𓾂
        integer function nf_inq_vardimid(ncid, varid, dimids)
            integer, intent(in)::                ncid, varid
            integer, intent(out)::                dimids(*)
        end function

        ! ϐ varid 瑮 natts m
        integer function nf_inq_varnatts(ncid, varid, natts)
            integer, intent(in)::                ncid, varid
            integer, intent(out)::                natts
        end function

        !
        ! --- ϐɊւǂݏȊȎ ---
        !

        ! ϐ varid  name ɉ
        integer function nf_rename_var(ncid, varid, name)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        name
        end function

        ! ϐ varid ʂ netCDF f[^Zbg ncid_out ɃRs[
        integer function nf_copy_var(ncid, varid, ncid_out)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                ncid_out
        end function

    !
    ! --- ϐ̏ ---
    !

        !
        ! ϐ̒Pvf
        !

        integer function nf_put_var1_text(ncid, varid, index, chval)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            character, intent(in)::                chval
        end function

        integer function nf_put_var1_int1(ncid, varid, index, i1val)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            integer(NF_KIND_INT1), intent(in):: i1val
        end function

        integer function nf_put_var1_int2(ncid, varid, index, i2val)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            integer(NF_KIND_INT2), intent(in):: i2val
        end function

        integer function nf_put_var1_int(ncid, varid, index, ival)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            integer, intent(in)::                 ival
        end function

        integer function nf_put_var1_real(ncid, varid, index, rval)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            real, intent(in)::                         rval
        end function

        integer function nf_put_var1_double(ncid, varid, index, dval)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            double precision, intent(in)::         dval
        end function

        !
        ! ϐ̑S̏
        !

        integer function nf_put_var_text(ncid, varid, text)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(in)::        text
        end function

        integer function nf_put_var_int1(ncid, varid, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer(NF_KIND_INT1), intent(in):: i1vals(*)
        end function

        integer function nf_put_var_int2(ncid, varid, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer(NF_KIND_INT2), intent(in):: i2vals(*)
        end function

        integer function nf_put_var_int(ncid, varid, ivals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                 ivals(*)
        end function

        integer function nf_put_var_real(ncid, varid, rvals)
            integer, intent(in)::                ncid, varid
            real, intent(in)::                         rvals(*)
        end function

        integer function nf_put_var_double(ncid, varid, dvals)
            integer, intent(in)::                ncid, varid
            double precision, intent(in)::         dvals(*)
        end function

        !
        ! ϐ̕z񏑂
        !

        integer function nf_put_vara_text(ncid, varid, &
        & start, count, text)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            character(len=*), intent(in)::        text
        end function

        integer function nf_put_vara_int1(ncid, varid, &
        & start, count, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer(NF_KIND_INT1), intent(in):: i1vals(*)
        end function

        integer function nf_put_vara_int2(ncid, varid, &
        & start, count, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer(NF_KIND_INT2), intent(in):: i2vals(*)
        end function

        integer function nf_put_vara_int(ncid, varid, &
        & start, count, ivals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                 ivals(*)
        end function

        integer function nf_put_vara_real(ncid, varid, &
        & start, count, rvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            real, intent(in)::                         rvals(*)
        end function

        integer function nf_put_vara_double(ncid, varid, &
        start, count, dvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            double precision, intent(in)::         dvals(*)
        end function

        !
        ! ϐ̕W{z񏑂
        !
        ! eƂɕW{Ԋu stride(i) Ƃɏݓ_I
        !

        integer function nf_put_vars_text(ncid, varid, &
        & start, count, stride, text)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            character(len=*), intent(in)::        text
        end function

        integer function nf_put_vars_int1(ncid, varid, &
        & start, count, stride, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            integer(NF_KIND_INT1), intent(in):: i1vals(*)
        end function

        integer function nf_put_vars_int2(ncid, varid, &
        & start, count, stride, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            integer(NF_KIND_INT2), intent(in):: i2vals(*)
        end function

        integer function nf_put_vars_int(ncid, varid, &
        & start, count, stride, ivals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            integer, intent(in)::                 ivals(*)
        end function

        integer function nf_put_vars_real(ncid, varid, &
        & start, count, stride, rvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            real, intent(in)::                         rvals(*)
        end function

        integer function nf_put_vars_double(ncid, varid, &
        & start, count, stride, dvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            double precision, intent(in)::         dvals(*)
        end function

        !
        ! ϐ̎ʑz񏑂
        !
        ! W{z񏑂݋@\ɉבւ@\t
        !

        integer function nf_put_varm_text(ncid, varid, &
        & start, count, stride, imap, text)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            character(len=*), intent(in)::        text
        end function

        integer function nf_put_varm_int1(ncid, varid, &
        & start, count, stride, imap, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            integer(NF_KIND_INT1), intent(in):: i1vals(*)
        end function

        integer function nf_put_varm_int2(ncid, varid, &
        & start, count, stride, imap, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            integer(NF_KIND_INT2), intent(in):: i2vals(*)
        end function

        integer function nf_put_varm_int(ncid, varid, &
        & start, count, stride, imap, ivals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            integer, intent(in)::                 ivals(*)
        end function

        integer function nf_put_varm_real(ncid, varid, &
        & start, count, stride, imap, rvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            real, intent(in)::                         rvals(*)
        end function

        integer function nf_put_varm_double(ncid, varid, &
        & start, count, stride, imap, dvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            double precision, intent(in)::         dvals(*)
        end function


    !
    ! --- ϐ̓ǂݎ ---
    !

        !
        ! ϐ̒Pvfǂݎ
        !

        integer function nf_get_var1_text(ncid, varid, index, chval)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            character, intent(out)::                chval
        end function

        integer function nf_get_var1_int1(ncid, varid, index, i1val)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            integer(NF_KIND_INT1), intent(out):: i1val
        end function

        integer function nf_get_var1_int2(ncid, varid, index, i2val)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            integer(NF_KIND_INT2), intent(out):: i2val
        end function

        integer function nf_get_var1_int(ncid, varid, index, ival)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            integer, intent(out)::                 ival
        end function

        integer function nf_get_var1_real(ncid, varid, index, rval)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            real, intent(out)::                 rval
        end function

        integer function nf_get_var1_double(ncid, varid, index, dval)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                index(*)
            double precision, intent(out)::         dval
        end function

        !
        ! ϐ̑S̓ǂݎ
        !

        integer function nf_get_var_text(ncid, varid, text)
            integer, intent(in)::                ncid, varid
            character(len=*), intent(out)::        text
        end function

        integer function nf_get_var_int1(ncid, varid, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer(NF_KIND_INT1), intent(out):: i1vals(*)
        end function

        integer function nf_get_var_int2(ncid, varid, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer(NF_KIND_INT2), intent(out):: i2vals(*)
        end function

        integer function nf_get_var_int(ncid, varid, ivals)
            integer, intent(in)::                ncid, varid
            integer, intent(out)::                 ivals(*)
        end function

        integer function nf_get_var_real(ncid, varid, rvals)
            integer, intent(in)::                ncid, varid
            real, intent(out)::                 rvals(*)
        end function

        integer function nf_get_var_double(ncid, varid, dvals)
            integer, intent(in)::                ncid, varid
            double precision, intent(out)::         dvals(*)
        end function

        !
        ! ϐ̕zǂݎ
        !

        integer function nf_get_vara_text(ncid, varid, &
        & start, count, text)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            character(len=*), intent(out)::        text
        end function

        integer function nf_get_vara_int1(ncid, varid, &
        & start, count, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer(NF_KIND_INT1), intent(out):: i1vals(*)
        end function

        integer function nf_get_vara_int2(ncid, varid, &
        & start, count, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer(NF_KIND_INT2), intent(out):: i2vals(*)
        end function

        integer function nf_get_vara_int(ncid, varid, &
        & start, count, ivals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(out)::                 ivals(*)
        end function

        integer function nf_get_vara_real(ncid, varid, &
        & start, count, rvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            real, intent(out)::                 rvals(*)
        end function

        integer function nf_get_vara_double(ncid, varid, &
        start, count, dvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            double precision, intent(out)::         dvals(*)
        end function

        !
        ! ϐ̕W{zǂݎ
        !

        integer function nf_get_vars_text(ncid, varid, &
        & start, count, stride, text)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            character(len=*), intent(out)::        text
        end function

        integer function nf_get_vars_int1(ncid, varid, &
        & start, count, stride, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            integer(NF_KIND_INT1), intent(out):: i1vals(*)
        end function

        integer function nf_get_vars_int2(ncid, varid, &
        & start, count, stride, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            integer(NF_KIND_INT2), intent(out):: i2vals(*)
        end function

        integer function nf_get_vars_int(ncid, varid, &
        & start, count, stride, ivals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            integer, intent(out)::                 ivals(*)
        end function

        integer function nf_get_vars_real(ncid, varid, &
        & start, count, stride, rvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            real, intent(out)::                 rvals(*)
        end function

        integer function nf_get_vars_double(ncid, varid, &
        & start, count, stride, dvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*)
            double precision, intent(out)::         dvals(*)
        end function

        !
        ! ϐ̎ʑzǂݎ
        !

        integer function nf_get_varm_text(ncid, varid, &
        & start, count, stride, imap, text)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            character(len=*), intent(out)::        text
        end function

        integer function nf_get_varm_int1(ncid, varid, &
        & start, count, stride, imap, i1vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            integer(NF_KIND_INT1), intent(out):: i1vals(*)
        end function

        integer function nf_get_varm_int2(ncid, varid, &
        & start, count, stride, imap, i2vals)
            use netcdf_kind_parameter
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            integer(NF_KIND_INT2), intent(out):: i2vals(*)
        end function

        integer function nf_get_varm_int(ncid, varid, &
        & start, count, stride, imap, ivals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            integer, intent(out)::                 ivals(*)
        end function

        integer function nf_get_varm_real(ncid, varid, &
        & start, count, stride, imap, rvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            real, intent(out)::                 rvals(*)
        end function

        integer function nf_get_varm_double(ncid, varid, &
        & start, count, stride, imap, dvals)
            integer, intent(in)::                ncid, varid
            integer, intent(in)::                start(*), count(*)
            integer, intent(in)::                stride(*), imap(*)
            double precision, intent(out)::         dvals(*)
        end function

    end interface
end module netcdf_f77
