! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine ANVarAttrCopy(to, attrname, from, err)
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileDefineMode, inquire
    use netcdf_f77
    use dc_url, only: GT_PLUS
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: to
    character(len = *), intent(in):: attrname
    type(AN_VARIABLE), intent(in):: from
    logical, intent(out), optional:: err
    character(NF_MAX_NAME):: nc_aname
    integer:: id_var_from, id_var_to
    integer:: stat
    stat = ANFileDefineMode(to%fileid)
    if (stat /= NF_NOERR) goto 999
    call inquire(from, attrname, id_var_from, nc_aname)
    call inquire(to, attrname, id_var_to, nc_aname)
    stat = nf_copy_att(from%fileid, id_var_from, nc_aname, &
        to%fileid, id_var_to)
999 continue
    call StoreError(stat, "ANVarAttrCopy", err)
end subroutine