module dc_units

    use dc_types, only: DOUBLE, TOKEN, STRING
    implicit none

    type UNITS
        real(DOUBLE):: factor
        character(TOKEN), pointer:: base(:)
        character(TOKEN), pointer:: name(:)
        integer, pointer:: power(:)
    end type

    interface
        
        subroutine DCUnitsSetLine(line)
            character(*), intent(in):: line
        end subroutine

        subroutine DCUnitsGetToken(tokentype, ivalue, dvalue, cvalue)
            integer, intent(out):: tokentype
            integer, intent(out):: ivalue(6)
            double precision, intent(out):: dvalue
            character(*), intent(out):: cvalue
        end subroutine

    end interface

    interface get_base
        subroutine DCUnitsGetBase(name, base, factor)
            use dc_types, only: DOUBLE
            character(*), intent(in):: name
            character(*), intent(out):: base
            real(DOUBLE), intent(out):: factor
        end subroutine
    end interface

end module