!= Module HeatFlux
!
! Authors::   ODAKA Masatsugu
! Version::   $Id: gridset_surfaceflux.f90,v 1.1 2012-10-01 06:25:03 odakker Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2012. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
module gridset_surfaceflux
  !
  != ɽ̥եåѳʻ⥸塼
  !

  ! GTOOL ѿ
  ! GTOOL variables
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: nx, & ! x ʻ 
                           ! Number of grid point in x
    &                ny, & ! y ʻ 
                           ! Number of grid point in y
    &                nz    ! z ʻ 
                           ! Number of grid point in z

  ! ѿ
  ! Parallel processing variable 
  !       
  Use mpi_wrapper,only: myrank

  ! ۤηػ
  ! Implicit none
  !
  implicit none

  ! °λ
  !
  private 

  character(*), parameter:: module_name = 'gridset_surfaceflux'
                                   ! ⥸塼̾.
                                   ! Module name

  ! ³
  ! Public procedure
  !
  public :: GridsetSurfacefluxInit

  ! ѿ
  ! Public variables
  !
  integer, save, public :: &
    &       imax, & ! ٳʻ. 
                    ! Number of grid points in longitude
    &       jmax, & ! ٳʻ. 
                    ! Number of grid points in latitude
    &       kmax    ! ľؿ. 
                    ! Number of vertical level

  
  contains

    subroutine GridsetSurfacefluxInit

      imax = nx
      jmax = ny
      kmax = nz

      ! å
      ! Message Output 
      !
      if (myrank == 0) then 
        call MessageNotify( "M", module_name, "imax = %d", i=(/imax/) )
        call MessageNotify( "M", module_name, "jmax = %d", i=(/jmax/) )
        call MessageNotify( "M", module_name, "kmax = %d", i=(/kmax/) )
     end if

    end subroutine GridsetSurfacefluxInit


end module gridset_surfaceflux
