!= Module cloudphys_k1969
!
! Authors::   ̰ϯ(SUGIYAMA Ko-ichiro),  (ODAKA Masatsugu), ⶶ˧ (YOSHIYUKI Takahashi)
! Version::   $Id: cloudphys_k1969.f90,v 1.28 2014-03-04 05:55:05 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]


module cloudphys_k1969
  !
  !ȤΥХ륯ˡѤ, ȱ, ȱκѴ.
  !   *  (1994) Ѥ꼰򤽤Τޤ. 
  ! 
  
  !⥸塼ɤ߹
  use dc_types,   only : DP, STRING
  use dc_iounit,  only : FileOpen
  use dc_message, only : MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

  use mpi_wrapper,only: myrank
  use timeset, only:  DelTimeLong, TimeN
  use gridset, only : imin,              &!x β
    &                 imax,              &!x ξ
    &                 jmin,              &!y ξ
    &                 jmax,              &!y ξ
    &                 kmin,              &!z β
    &                 kmax,              &!z ξ
    &                 nx, ny, nz, ncmax      !ʪΰ礭
  use constants,only: PressBasis,        &!̤δవ 
    &                 CpDry,             &!ʬǮ
    &                 MolWtDry,          &!
    &                 GasRDry             !ʬε 
  use basicset, only: xyz_DensBZ,        &!ܾ̩
    &                 xyz_PTempBZ,       &!ܾβ
    &                 xyz_ExnerBZ,       &!̵ܾ
    &                 xyzf_QMixBZ,       &!ܾκ
    &                 xyz_VPTempBZ        !̤δܾ
  use composition, only:                    &
    &                 MolWtWet,          &!
    &                 SpcWetID,          &!
    &                 SpcWetSymbol,      &!
    &                 GasNum,            &!
    &                 CondNum,           &!ŷο
    &                 IdxG,              &!ź
    &                 IdxCG,             &!ŷ()ź
    &                 IdxCC,             &!ŷ()ź
    &                 IdxCR,             &!ŷ()ź
    &                 CloudNum,          &!ο
    &                 RainNum,           &!ο
    &                 IdxC,              &!ź
    &                 IdxR,              &!ź
    &                 IdxNH3,            &!NH3()ź
    &                 IdxH2S,            &!H2S()ź
    &                 IdxNH4SHr           !NH4SH()ź
  use axesset, only : xyr_avr_xyz
  use xyz_deriv_module,only : xyz_dz_xyr
  use ChemCalc,  only : xyz_SvapPress, xyz_LatentHeat, ReactHeatNH4SH, xyz_DelQMixNH4SH
  use MoistAdjust, only: MoistAdjustSvapPress, MoistAdjustNH4SH
  use namelist_util, only: namelist_filename
  use DExnerDt, only: xyz_DExnerDt_xyzf, xyz_DExnerDt_xyz
  use SetMargin,only: SetMargin_xyz, SetMargin_xyzf

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public ˤ
  public Cloudphys_K1969_Init
  public Cloudphys_K1969_forcing

  real(DP), save :: FactorFallRain = 1.0d0   !̵ͭ
                                             !ʤͤ򥼥ˤ. 
  real(DP), save :: FactorCloud2Rain = 1.0d0 !鱫ؤѴ̵ͭ 
                                             !Ѵʤͤ򥼥ˤ. 
  real(DP), save :: FactorRain2Gas = 1.0d0   !ؤѴ̵ͭ 
                                             !Ѵʤͤ򥼥ˤ. 
  real(DP), save, public :: FactorCloud2Gas = 1.0d0 
                                             !ؤѴ̵ͭ 
                                             !Ѵʤͤ򥼥ˤ. 

  real(DP), save :: FactorJ      = 1.0d0 !ʪΥѥ᡼
                                         !Ǥ 3.0d0
                                         !ϵǤ 1.0d0 Ȥ
  real(DP), save :: AutoConvTime = 1.0d3 !ʻĹλ [sec]
  real(DP), save :: QMixCr       = 1.0d-3 
                                         !ʻĹ׳ [kg/kg]
  logical, save :: FlagDExnerDtCloud = .true.
  logical, save :: FlagDExnerDtFall  = .true.

contains  

!!!=================================================================================!!!
  subroutine Cloudphys_K1969_Init

    !ۤηػ
    implicit none

    !ѿ
    integer  :: unit    !ֹ
    integer  :: l
    character(STRING) :: Planet = ""
    character(*), parameter:: module_name = 'Cloudphys_K1969_Init'

    !-----------------------------------------------------------
    ! NAMELIST 
    !
    NAMELIST /cloudphys_k1969_nml/                &
      & Planet, FactorJ, AutoConvTime, QMixCr,    &
      & FlagDExnerDtCloud, FlagDExnerDtFall,      &
      & FactorFallRain, FactorCloud2Rain,         &
      & FactorRain2Gas, FactorCloud2Gas

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=cloudphys_k1969_nml)
    close(unit)

    if (trim(Planet) == "Earth") then 
      FactorJ = 1.0d0
    elseif (trim(Planet) == "Jupiter") then 
      FactorJ = 3.0d0
    end if

    !-----------------------------------------------------------
    ! 
    !
    if (myrank == 0) then 
      call MessageNotify( "M", &
        &  module_name, "Planet = %c",  c1=trim(Planet))
      call MessageNotify( "M", &
        &  module_name, "FactorJ = %f",  d=(/FactorJ/) )
      call MessageNotify( "M", &
        &  module_name, "AutoConvTime = %f",  d=(/AutoConvTime/) )
      call MessageNotify( "M", &
        &  module_name, "QMixCr = %f",  d=(/QMixCr/) )
      call MessageNotify( "M", &
        &  module_name, "FactorFallRain = %f",  d=(/FactorFallRain/) )
      call MessageNotify( "M", &
        &  module_name, "FactorCloud2Rain = %f",  d=(/FactorCloud2Rain/) )
      call MessageNotify( "M", &
        &  module_name, "FactorRain2Gas = %f",  d=(/FactorRain2Gas/) )
      call MessageNotify( "M", &
        &  module_name, "FactorCloud2Gas = %f",  d=(/FactorCloud2Gas/) )
      call MessageNotify( "M", &
        & module_name, "FlagDExnerDtCloud= %b", l=(/ FlagDExnerDtCloud /))
      call MessageNotify( "M", &
        & module_name, "FlagDExnerDtFall= %b", l=(/ FlagDExnerDtFall /))
     end if

    !-----------------------------------------------------------
    ! ҥȥǡ
    !
    call HistoryAutoAddVariable(  &
      & varname='ExnerFall',      &
      & dims=(/'x','y','z','t'/), &
      & longname='Fall term of Exner function', &
      & units='kg.kg-1.s-1',            &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='PTempCond',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Latent heat term of potential temperature', &
      & units='K.s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerCondTemp',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Latent heat term of exner function (Temp)', &
      & units='K.s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerCondQMix',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Latent heat term of exner function (QMix)', &
      & units='K.s-1',    &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Cond', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Condensation term of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='float')

      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Fall', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Fall Rain term of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='float')

      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_FallFluxAtLB', & 
        & dims=(/'x','y','t'/),     &
        & longname='Falling Rain Flux '          &
        &           //trim(SpcWetSymbol(l)),  &
        & units='kg.m-2.s-1',    &
        & xtype='float')

   end do


   do l = 1, CondNum
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Hum', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Humidity of ' //trim(SpcWetSymbol(l)),  &
        & units='1',    &
        & xtype='float')
    end do
    
  end subroutine Cloudphys_K1969_Init
!!!=================================================================================!!!  

  subroutine Cloudphys_K1969_forcing(xyz_ExnerNl, xyzf_QMixNl, xyz_DExnerDt, xyz_PTempAl, xyzf_QMixAl)

    implicit none

    real(DP), intent(in)    :: xyz_ExnerNl(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(in)    :: xyzf_QMixNl(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP), intent(inout) :: xyz_DExnerDt(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(inout) :: xyz_PTempAl(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(inout) :: xyzf_QMixAl(imin:imax, jmin:jmax, kmin:kmax, ncmax)

    real(DP) :: xyz_PTempOrig(imin:imax, jmin:jmax, kmin:kmax)
    real(DP) :: xyz_PTempWork(imin:imax, jmin:jmax, kmin:kmax)
    real(DP) :: xyz_DelPTemp(imin:imax, jmin:jmax, kmin:kmax)
    real(DP) :: xyz_PTempCond(imin:imax, jmin:jmax, kmin:kmax)
    real(DP) :: xyzf_QMixOrig(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP) :: xyzf_QMixWork(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP) :: xyzf_DelQMix(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP) :: xyzf_QMixCond(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP) :: DelTime
    integer  :: l, s
    integer  :: iG, iC, iR

    real(DP) :: xyzf_Cloud2Rain(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                          !鱫ؤѴ
    real(DP) :: xyz_AutoConv(imin:imax,jmin:jmax,kmin:kmax)
                                          !˰º
    real(DP) :: xyz_Collect(imin:imax,jmin:jmax,kmin:kmax)
                                          !ʲ줿Ǯ
    real(DP) :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                          !ξʬ + ʿʬ
    real(DP) :: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax)
                                          !٤ξʬ + ʿʬ
    real(DP) :: xyz_PressAll(imin:imax,jmin:jmax,kmin:kmax)
                                          !
    real(DP) :: xyz_ExnerAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_NonSaturate(imin:imax,jmin:jmax,kmin:kmax)
                                          !̤˰(˰ºȾκκ)
    real(DP) :: xyzf_Rain2Gas(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP) :: xyzf_Rain2GasNH4SH(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP) :: xyzf_DelPTemp(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP) :: xyz_DelPTempNH4SH(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_PressDry(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_ExnerCondTemp(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_ExnerCondQMix(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)  :: xyzf_FallRain(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                                 !γ
    real(DP)  :: xyz_VelZRain(imin:imax,jmin:jmax,kmin:kmax)
                                                 !γ®
    real(DP)  :: xyrf_FallRainFlux(imin:imax,jmin:jmax,kmin:kmax, ncmax) 
                                                 !γեå
    real(DP)  :: xyz_ExnerFall(imin:imax,jmin:jmax,kmin:kmax) 

    real(DP)  :: xyz_QMixSat(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)  :: xyz_QMixHum(imin:imax,jmin:jmax,kmin:kmax) 


    !-------------------------------------------------------------
    ! ֹ. Leap-frog ʤΤ, 2 \del t
    !
    DelTime = 2.0d0 * DelTimeLong


    !-------------------------------------------------------------
    ! γˤ뺮λѲ׻ 
    !   QMixNl Ѥ QMixAl 򹹿. 
    !

    ! 
    ! ʬȤƤ, Nl ͤѤ.
    !
    xyzf_QMixAll = max( 0.0d0, xyzf_QMixNl + xyzf_QMixBZ )
    xyrf_FallRainFlux = 0.0d0
    xyzf_FallRain = 0.0d0
    xyzf_QMixWork = xyzf_QMixAl + xyzf_QMixBZ

    do s = 1, RainNum
      iR = IdxR(s)

      ! γü®
      xyz_VelZRain = - 12.2d0 * FactorJ * ( xyzf_QMixAll(:,:,:,iR) ** 0.125d0 )

      ! եåη׻
      !
      xyrf_FallRainFlux(:,:,:,iR) =                   &
        &  xyr_avr_xyz(                               &
        &               xyz_DensBZ                    &
        &               * xyz_VelZRain                &
        &               * xyzf_QMixAll(:,:,:,iR)      &
        &              )

      ! üΥեåϥ
      !
      xyrf_FallRainFlux(:,:,nz,iR) = 0.0d0

      ! γˤѲ (DelTime 򤫤Ƥ)
      !
      xyzf_FallRain(:,:,:,iR) =                       &
        & - xyz_dz_xyr( xyrf_FallRainFlux(:,:,:,iR) ) &
        & / xyz_DensBZ * DelTime

      ! ¸̤긺뤳Ȥ̵褦ˤ. 
      !
      xyzf_FallRain(:,:,:,iR) = &
           & max( - xyzf_QMixWork(:,:,:,iR), xyzf_FallRain(:,:,:,iR) )
    end do

    ! θ뤳Ȥ, Al ͤ򹹿
    ! ڤˤ FactorFallRain = 0.0 Ȥ. 
    !
    xyzf_QMixAl = xyzf_QMixAl + xyzf_FallRain * FactorFallRain

    ! ȼѲ Output 
    !
    if ( FlagDExnerDtFall ) then
      xyz_ExnerFall = xyz_DExnerDt_xyzf( xyzf_FallRain / DelTime ) !ưʤΤ
    else
      xyz_ExnerFall = 0.0d0
    end if 

    ! ݴ
    !
    xyz_DExnerDt  = xyz_DExnerDt + xyz_ExnerFall

    call HistoryAutoPut(TimeN, 'ExnerFall', xyz_ExnerFall(1:nx,1:ny,1:nz))    
    do l = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(l))//'_Fall', xyzf_FallRain(1:nx, 1:ny, 1:nz, l))
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(l))//'_FallFluxAtLB', xyrf_FallRainFlux(1:nx, 1:ny, 0, l))
    end do


    !------------------------------------------
    ! ͤݴ Store Initial Value
    !
    xyz_PTempOrig = xyz_PTempAl
    xyzf_QMixOrig = xyzf_QMixAl

    ! ʡؿ׻. ֥롼ǤѲʤ.
    !
    xyz_ExnerAll = xyz_ExnerNl + xyz_ExnerBZ
    xyz_PressAll = PressBasis * (xyz_ExnerAll ** (CpDry / GasRDry))

    !------------------------------------------    
    ! ȤΥѥ᥿ꥼ.
    ! * <--> ѴԤ.
    !
    ! Warm rain parameterization.
    ! * Conversion from cloud to rain.
    
    !ޤǤͤݴ
    ! Previous values are stored to work area.
    !
    xyzf_QMixWork = xyzf_QMixAl
    
    !ؤѲ̤׻
    ! Conversion values are calculated.
    !    
    xyzf_QMixAll = max( 0.0d0, xyzf_QMixAl + xyzf_QMixBZ )
    xyzf_Cloud2Rain = 0.0d0

    do s = 1, CloudNum

      ! ͤݴ
      !
      iC = IdxC(s)
      iR = IdxR(s)

      !ʻĹ
      !
      xyz_AutoConv =                                           &
        & DelTime / AutoConvTime                               &
        & * max( 0.0d0, ( xyzf_QMixAll(:,:,:,iC) - QMixCr) )

      !͹Ĺ
      !
      xyz_Collect =                                            &
        &  DelTime                                             &
        &  * 2.2d0 * FactorJ * xyzf_QMixAll(:,:,:,iC)          &
        &  * (xyzf_QMixAll(:,:,:,iR) * xyz_DensBZ) ** 0.875d0  

      !Ѵ: ʻĹȹξͤ
      !  Ѳ̤ͤȤꤹ. ͤȤʤ.
      !
      xyzf_Cloud2Rain(:,:,:,iC) =                       &
        & - min( xyzf_QMixAll(:,:,:,iC), ( xyz_AutoConv + xyz_Collect ) )
      
      !Ѵ. ϱѴ̤Ȥȿ. 
      xyzf_Cloud2Rain(:,:,:,iR) = - xyzf_Cloud2Rain(:,:,:,iC) 
    end do

    ! Ѳ̤­
    ! 鱫Ѵʤ FactorCloud2Rain = 0.0 Ȥ. 
    !
    xyzf_QMixAl = xyzf_QMixWork + xyzf_Cloud2Rain * FactorCloud2Rain


    !-------------------------------------------    
    ! ȤΥѥ᥿ꥼ.
    ! * <--> ѴԤ
    !
    ! Warm rain parameterization.
    ! * Conversion from rain to vapor.
    
    !ޤǤͤݴ
    ! Previous values are stored to work area.
    !
    xyz_PTempWork = xyz_PTempAl
    xyzf_QMixWork = xyzf_QMixAl
    
    ! ؤκѲ
    ! * ̤η׻ˤ, ѲɬפȤʤ뤿, 
    !   Ѳ 1 ĤȤѰդ.
    !
    ! Conversion values are calculated.
    !

    !, , ̤
    !ʬʿʬ­
    !
    xyz_TempAll   = ( xyz_PTempAl + xyz_PTempBZ ) * ( xyz_ExnerNl + xyz_ExnerBZ )
    xyzf_QMixAll  = max( 0.0d0, xyzf_QMixAl + xyzf_QMixBZ )
    xyz_PressDry  = xyz_PressDry_xyzf_xyz( xyzf_QMixAll, xyz_PressAll )

    xyzf_Rain2Gas = 0.0d0
    xyzf_DelPTemp = 0.0d0
    xyzf_Rain2GasNH4SH = 0.0d0
    xyz_DelPTempNH4SH  = 0.0d0

    do s = 1, CondNum

       ! ͤݴ
       !
       iG = IdxCG(s)
       iC = IdxCC(s)
       iR = IdxCR(s)

      !˰¾Ⱥκ(˰)׻. 
      !  ؤѴ̤˰٤㤹.
      !
      xyz_NonSaturate =                                   &
        & max(                                            &
        &   0.0d0,                                      &
        &   xyz_SvapPress(SpcWetID(iC), xyz_TempAll)      &
        &     * MolWtWet(iG) / ( MolWtDry * xyz_PressDry) &
        &     - xyzf_QMixAll(:,:,:,iG)                    &
        &    )

      !Ѵ
      !  αγκʾ˾ȯʤ褦˾ͤ
      !
      xyzf_Rain2Gas(:,:,:,iR) =                                    &
        & - min(                                                   &
        &    DelTime * 4.85d-2 * FactorJ * xyz_NonSaturate         &
        &     * ( xyzf_QMixAll(:,:,:,iR) * xyz_DensBZ )** 0.65d0,  &
        &    xyzf_QMixAll(:,:,:,iR)                                &
        &   ) 

      !Ѵ
      !  γѴ̤Ȥ椬դȤʤ
      !
      xyzf_Rain2Gas(:,:,:,iG) = - xyzf_Rain2Gas(:,:,:,iR) 
    
      ! xyzf_DelQMix 򸵤Ǯ׻
      !
      xyzf_DelPTemp(:,:,:,s) =                          &
        & xyz_LatentHeat( SpcWetID(iR), xyz_TempAll )   &
        &  * xyzf_Rain2Gas(:,:,:,iR)                    &
        &  / (xyz_ExnerAll * CpDry) 

    end do

    !˰¾Ⱥκ(˰)׻. 
    !  ؤѴ̤˰٤㤹.
    !  ̤˰٤᤿Τ, ޥʥ򤫤Ƥ
    !  (DelQMixNH4SH , NH4SH ä, ʤ˰٤ȤƤ)
    !

    if (IdxNH4SHr /= 0) then 
      xyz_NonSaturate =                                                 &
        & max(                                                          &
        &  0.0d0,                                                     &
        &   - xyz_DelQMixNH4SH(                                         &  
        &       xyz_TempAll, xyz_PressAll, xyz_PressDry,                & 
        &       xyzf_QMixAll(:,:,:,IdxNH3), xyzf_QMixAll(:,:,:,IdxH2S), &
        &       MolWtWet(IdxNH3), MolWtWet(IdxH2S)                      &
        &     )                                                         &
        &  )

      !Ѵ
      !  αγκʾ˾ȯʤ褦˾ͤ
      !
      xyzf_Rain2GasNH4SH(:,:,:,IdxNH4SHr) =                              &
        & - min(                                                         &
        &     DelTime * 4.85d-2 * FactorJ * xyz_NonSaturate              &
        &      * (xyzf_QMixAll(:,:,:,IdxNH4SHr) * xyz_DensBZ) ** 0.65d0, &
        &     xyzf_QMixAll(:,:,:,IdxNH4SHr)                              &
        &    ) 
     
      !Ѵ
      !  γѴ̤Ȥ椬դȤʤ
      !
      xyzf_Rain2GasNH4SH(:,:,:,IdxNH3) =                           &
        & - xyzf_Rain2GasNH4SH(:,:,:,IdxNH4SHr) * MolWtWet(IdxNH3) &
        &   / MolWtWet(IdxNH4SHr)
      xyzf_Rain2GasNH4SH(:,:,:,IdxH2S) =                           &
        & - xyzf_Rain2GasNH4SH(:,:,:,IdxNH4SHr) * MolWtWet(IdxH2S) &
        &   / MolWtWet(IdxNH4SHr)

      xyz_DelPTempNH4SH                                          &
        & = ReactHeatNH4SH * xyzf_Rain2GasNH4SH(:,:,:,IdxNH4SHr) &
        &    / (xyz_ExnerAll * CpDry)

    end if

    !Ѳ̤­
    !ؤѴڤ FactorRain2Gas = 0.0 Ȥ. 
    !
    xyzf_DelQMix = xyzf_Rain2Gas + xyzf_Rain2GasNH4SH 
    xyz_DelPTemp = sum(xyzf_DelPTemp, 4) + xyz_DelPTempNH4SH 

    ! ̤Ⱥη׻. ؤѴʬɲ
    !
    xyz_PTempAl = xyz_PTempWork + xyz_DelPTemp * FactorRain2Gas
    xyzf_QMixAl = xyzf_QMixWork + xyzf_DelQMix * FactorRain2Gas


    !-------------------------------------------
    ! ˰Ĵ
    ! * <-->ѴԤ.
    !
    ! Moist adjustment.
    ! * Conversion from vapor to cloud.
    !
    xyzf_QMixAll = max( 0.0d0, xyzf_QMixAl + xyzf_QMixBZ )
    xyz_PressDry = xyz_PressDry_xyzf_xyz( xyzf_QMixAll, xyz_PressAll )

    call MoistAdjustSvapPress(   &
      & xyz_PressDry,            & ! (in) 
      & xyz_ExnerNl,             & ! (in)
      & xyz_PTempAl,             & ! (inout)
      & xyzf_QMixAl,             & ! (inout)
      & FactorCloud2Gas          & ! (in)
      & )
    if (IdxNH4SHr /= 0) then 
      call MoistAdjustNH4SH(     &
        & xyz_PressDry,          & !(in)
        & xyz_ExnerNl,           & !(in)
        & xyz_PTempAl,           & !(inout)
        & xyzf_QMixAl,           & !(inout)
        & FactorCloud2Gas        & !(in)
        & )
    end if

    !------------------------------------------
    ! Output
    !
    xyz_PTempCond = (xyz_PTempAl - xyz_PTempOrig) / DelTime
    xyzf_QMixCond = (xyzf_QMixAl - xyzf_QMixOrig) / DelTime

    if ( FlagDExnerDtCloud ) then
      xyz_ExnerCondTemp = xyz_DExnerDt_xyz( xyz_PTempCond )
      xyz_ExnerCondQMix = xyz_DExnerDt_xyzf( xyzf_QMixCond )
    else
      xyz_ExnerCondTemp = 0.0d0
      xyz_ExnerCondQMix = 0.0d0
    end if

    xyz_DExnerDt  = xyz_DExnerDt + xyz_ExnerCondTemp + xyz_ExnerCondQMix

    call HistoryAutoPut(TimeN, 'PTempCond', xyz_PTempCond(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'ExnerCondTemp', xyz_ExnerCondTemp(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'ExnerCondQMix', xyz_ExnerCondQMix(1:nx,1:ny,1:nz))
    do l = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(l))//'_Cond', xyzf_QMixCond(1:nx, 1:ny, 1:nz, l))
    end do

    !----------------------------------------------------------------
    ! ˰¾ʿ
    !----------------------------------------------------------------
    xyz_TempAll   = ( xyz_PTempAl + xyz_PTempBZ ) * ( xyz_ExnerNl + xyz_ExnerBZ )
    xyzf_QMixAll  = max( 0.0d0, xyzf_QMixAl + xyzf_QMixBZ )
    xyz_PressDry  = xyz_PressDry_xyzf_xyz( xyzf_QMixAll, xyz_PressAll )

    do s = 1, CondNum
      iG = IdxCG(s)
      iC = IdxCC(s)

      !˰¾
      xyz_QMixSat =                                  &
        & xyz_SvapPress(SpcWetID(iC), xyz_TempAll)    &
        &  * MolWtWet(iC) / MolWtDry / xyz_PressDry

      !м
      xyz_QMixHum = &
        & xyzf_QMixAll(:,:,:,iG) / xyz_QMixSat * 100.0d0

      !
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(s))//'_Hum', xyz_QMixHum(1:nx, 1:ny, 1:nz))
    end do

    ! Set Margin
    !
    call SetMargin_xyz(xyz_PTempAl)
    call SetMargin_xyzf(xyzf_QMixAl)

  end subroutine Cloudphys_K1969_forcing


!!!----------------------------------------------------------------
  function xyz_PressDry_xyzf_xyz( xyzf_QMixAll, xyz_PressAll )
    ! ʬʬη׻
    ! 
    implicit none

    real(DP), intent(in) :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax,ncmax)
    real(DP), intent(in) :: xyz_PressAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_PressDry_xyzf_xyz(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyzf_QMixAllPerMolWt(imin:imax,jmin:jmax,kmin:kmax,ncmax)
    integer              :: f, iG

    ! /ʬ̤׻
    ! 
    do f = 1, GasNum
      iG = IdxG(f)
      xyzf_QMixAllPerMolWt(:,:,:,f) = xyzf_QMixAll(:,:,:,iG) / MolWtWet(iG)
    end do

    ! ʬʬ. 
    ! 
    xyz_PressDry_xyzf_xyz = xyz_PressAll / (1.0d0 + MolWtDry * sum( xyzf_QMixAllPerMolWt(:,:,:,1:GasNum), 4))

  end function xyz_PressDry_xyzf_xyz
  
end module Cloudphys_k1969
