# Title: Ruby script drawing contour map for deepconv/arare5 output data 
#
# History: 2011/09/27 (Masatsugu Odaka)
#
require "numru/ggraph"
include NumRu

file = 'denscurrent-dry_Km.nc'
varname = 'Km'

var = GPhys::IO.open(file, varname)
time  = GPhys::IO.open(file, 't').val

#GGraph.set_linear_contour_options( 'min'=>-15.0, 'max'=>0.0, \
#                                   'interval'=>1.0 )  
#GGraph.set_linear_tone_options( 'min'=>-15.0, 'max'=>1.0, \
#                                  'interval'=>2.5e-1 )  

#GGraph.set_tone_levels( \
#  'levels'=>[-15,-14.5,-14,-13.5,-13,-12.5,-12,-11.5,-11,-10.5,-10,-9.5,-9,-8.5,-8,-7.5,-7,-6.5,-6,-5.5,-5,-4.5,-4,-3.5,-3,-2.5,-2,-1.5,-1,-0.5,0.0], \
#  'pat'=>[84999,86999,88999,90999,10999,11999,12999,13999,14999,15999,16999,17999,18999,19999,20999,22999,24999,26999,28999,30999,32499,34999,38999,40999,42999,46999,50999,54999,58999,60999,62999] ) 

# <Open DCL>
DCL.swlset( 'ldump', true )
DCL.sgpset( 'lfull', true )
DCL.uzfact(0.7)
DCL.gropn(4)
GGraph.set_fig('viewport'=>[0.1,0.85,0.3,0.5])

for i in 0...time.length do
# <Drawing data by GGraph>
  GGraph.tone( var.cut(25600..44800,0,0..6400, time[i]), true, \
               'title'=>'Km', 'annot'=>true)
  GGraph.contour( var.cut(25600..44800,0,0..6400, time[i]), false )
#  GGraph.color_bar( 'labelintv'=>20, 'tickintv'=>2, 'landscape'=>true)
  GGraph.color_bar('landscape'=>true)
end

# <Close DCL>
DCL.grcls
