!= Module DynamicsHEVI
!
! Authors::   ̰ϯ(SUGIYAMA Ko-ichiro), ODAKA Masatsugu 
! Version::   $Id: dynamicshevi.f90,v 1.14 2012-01-12 11:56:54 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20120511 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǥϳز׻뤿ɬפȤʤؿ«ͤ⥸塼
!Ūˤϰʲι׻뤿δؿǼ.  
!  * ή
!  * Ϲ
!  * Ϲ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * ʡؿζΥˤ, 2 ٤Υۤ
!    ѤƤ뤿, Ϲη׻ץˤ
!    differentiate_center4 ⥸塼ꤹ뤳ȤϤǤʤΤ.
!
!== Future Plans
!

module DynamicsHEVI
  !
  !۲ˡѤϳزγƹη׻⥸塼. 
  !Ūˤϰʲι׻뤿δؿǼ.  
  !  * ή
  !  * Ϲ
  !  * Ϲ
  !

  !⥸塼ɤ߹
  use dc_types,   only : DP, STRING
  use dc_iounit,  only : FileOpen
  use dc_message, only : MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut 

  use mpi_wrapper,only: myrank
  use gridset, only: &
    &                 imin,            &! x β
    &                 imax,            &! x ξ
    &                 jmin,            &! y β
    &                 jmax,            &! y ξ
    &                 kmin,            &! z β
    &                 kmax,            &! z ξ
    &                 nx,              &! x ʪΰξ
    &                 ny,              &! x ʪΰξ
    &                 nz,              &! y ʪΰξ
    &                 ncmax             ! ʪ
  use constants,only: CpDry,           &! ʬǮ
    &                 CvDry,           &! ʬǮ
    &                 GasRDry,         &! ʬε
    &                 MolWtDry,        &! ʬʬ
    &                 Grav              ! ϲ®
  use composition, only: SpcWetSymbol, &!
    &                 GasNum,          &! 
    &                 IdxG,            &!
    &                 MolWtWet          ! ʬʬ
  use timeset, only:  DelTimeShort, DelTimeLong, TimeN
  use axesset, only:  x_dx, y_dy, z_dz, r_dz,                &! ʻҴֳ
    &                 xyz_avr_pyz, xyr_avr_pyr, xqz_avr_pqz, &
    &                 pyz_avr_xyz, pyr_avr_xyr, pqz_avr_xqz, &
    &                 xyz_avr_xqz, pyz_avr_pqz, xyr_avr_xqr, &
    &                 xqz_avr_xyz, pqz_avr_pyz, xqr_avr_xyr, &
    &                 xyz_avr_xyr, pyz_avr_pyr, xqz_avr_xqr, &
    &                 xyr_avr_xyz, pyr_avr_pyz, xqr_avr_xqz 
  use basicset, only: xyz_VelSoundBZ, &!ܾβ® 
    &                 xyz_DensBZ,     &!ܾ̩
    &                 xyz_PTempBZ,    &!ܾβ
    &                 xyz_VPTempBZ,    &!ܾβ
    &                 xyz_ExnerBZ,    &
    &                 xyzf_QMixBZ,    &
    &                 xyr_QMixBZPerMolWt,  &
    &                 xyr_QMixBZ, xyz_EffMolWtBZ   
  use xyz_deriv_module
  use xyz_deriv_c4_module, only: pyz_c4dx_xyz, xqz_c4dy_xyz, xyr_c4dz_xyz, &
    &                            xyz_c4dx_pyz, pqz_c4dy_pyz, pyr_c4dz_pyz, &
    &                            pqz_c4dx_xqz, xyz_c4dy_xqz, xqr_c4dz_xqz, &
    &                            pyr_c4dx_xyr, xqr_c4dy_xyr, xyz_c4dz_xyr
  use setmargin,only: SetMargin_xyzf, SetMargin_xyz, &
    &                 SetMargin_pyz, SetMargin_xqz, SetMargin_xyr
  use fillnegative, only: FillNegativeQMix
  use namelist_util, only: namelist_filename

  !ۤηػ
  implicit none

  !°λ
  private
  
  real(DP), save         :: beta  = 1.0d0    !󥯥˥륽ˡʤ 0.5
                                             !ˡʤ 1
  real(DP), allocatable, save :: xyz_F1BZ(:,:,:)  !η׻Ѥ
  real(DP), allocatable, save :: xyr_F2BZ(:,:,:)  !η׻Ѥ

  integer, save         :: N = 10            !/μ, ˡ
  integer, save         :: M = 10            !ȿ
  integer, save         :: NUD = 1           !ξ廰ʬ
  integer, save         :: NLD = 1           !βʬ
  integer, save         :: NAL = 1           !LU ʬη L ˡ
  integer, save         :: NA = 3            !NUD + NLD + 1

  real(DP), allocatable, save :: A(:)              !гʬ
  real(DP), allocatable, save :: B(:)              !ξ廰ʬ
  real(DP), allocatable, save :: C(:)              !βʬ
!  real(DP), allocatable, save :: AU2(:,:)          !LU ʬη U (2 )
  real(DP), allocatable, save :: AL1(:)            !LU ʬη L (1 )
!  real(DP), allocatable, save :: AL2(:,:)          !LU ʬη L (2 )
  integer, allocatable, save  :: IP(:)             !ʬԥܥåȸ򴹤ξǼ

  real(DP), save :: AlphaH = 0.0d0           !ȸθ그
  real(DP), save :: AlphaV = 0.0d0           !ȸθ그
  real(DP), save :: NuHh   = 0.0d0        !Ǵη (ʿ)
  real(DP), save :: NuVh   = 0.0d0        !Ǵη (ľ)
  real(DP), save :: NuHm  = 0.0d0         !Ǵη (ʿ)
  real(DP), save :: NuVm  = 0.0d0         !Ǵη (ľ)
  character(*), parameter:: module_name = 'DynamicHEVI'
                              ! ⥸塼̾.
                              ! Module name

  !public 
  public Dynamics_Init
  public Dynamics_Km_forcing
  public Dynamics_Long_forcing
  public Dynamics_Short_forcing


contains

  subroutine Dynamics_Init

    !ۤηػ
    implicit none
    
    real(DP)  :: DelXMin, DelYMin, DelZMin
    real(DP)  :: AlphaSound = 5.0d-2  !ȸη (ģͽ̺49 )
    real(DP)  :: AlphaNDiff = 1.0d-3  !4οͳȻη. CReSS ޥ˥奢
    real(DP)  :: NDiffRatio = 1.0d0  !®٤ФǴ夲Ͽ 1 ʾˤ. 
    integer   :: unit            !ֹ
    integer   :: l

    NAMELIST /Dynamics_nml/ AlphaSound, AlphaNDiff, NDiffRatio, beta

    !ե륪ץ. . 
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=dynamics_nml)
    close(unit)
    
    !-------------------------------------------------------------------
    ! ȸθΨ   Min(DelX, DelZ) ** 2.0 
    !
    DelXMin = minval(x_dx)
    DelYMin = minval(y_dy)
    DelZMin = minval(z_dz)
    AlphaH = AlphaSound * ( SQRT(DelXMin*DelYMin) ** 2.0d0 ) / DelTimeShort
    AlphaV = AlphaSound * ( DelZMin ** 2.0d0 ) / DelTimeShort
    
    NuHh = AlphaNDiff * ( SQRT(DelXMin*DelYMin) ** 4.0d0 ) / (2.0d0 * DelTimeLong)
    NuVh = AlphaNDiff * ( DelZMin ** 4.0d0 ) / (2.0d0 * DelTimeLong)
    NuHm = NuHh * NDiffRatio
    NuVm = NuVh * NDiffRatio

    if (myrank == 0) then 
      call MessageNotify( "M", module_name, "AlphaH = %f", d=(/AlphaH/) )
      call MessageNotify( "M", module_name, "AlphaV = %f", d=(/AlphaV/) )
      call MessageNotify( "M", module_name, "NuHh = %f", d=(/NuHh/) )
      call MessageNotify( "M", module_name, "NuVh = %f", d=(/NuVh/) )
      call MessageNotify( "M", module_name, "NuHm = %f", d=(/NuHm/) )
      call MessageNotify( "M", module_name, "NuVm = %f", d=(/NuVm/) )
    end if

    ! ˡη׻ν
    !
    call DynamicsVI_init()

    call HistoryAutoAddVariable(  &
      & varname='PTempAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of potential temperature',  &
      & units='K.s-1',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='PTempNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of potential temperature',&
      & units='K.s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of exner function',  &
      & units='s-1',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='ExnerNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of exner function',&
      & units='s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='CDensAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of cloud density',  &
      & units='kg.m-3.s-1',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='CDensNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of cloud density',&
      & units='kg.m-3.s-1',    &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Adv', &
        & dims=(/'x','y','z','t'/),     &
        & longname='Advection term of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='float')
      
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_NDiff', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Diffusion term of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='float')
    end do

    call HistoryAutoAddVariable(  &
      & varname='VelXAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of velocity (x)',  &
      & units='m.s-2',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='VelXNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of velocity (x)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelXPGrad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Pressure gradient term of velocity (x)',  &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelXSWF', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Filter for acoustic mode (x)',  &
      & units='m.s-2',    &
      & xtype='float')

!    call HistoryAutoAddVariable(  &
!      & varname='VelXTndNs', &
!      & dims=(/'x','y','z','t'/),     &
!      & longname='Velocity Tendency (x)',  &
!      & units='m.s-2',    &
!      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of velocity (y)',  &
      & units='m.s-2',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='VelYNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of velocity (y)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYPGrad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Pressure gradient term of velocity (y)',  &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYSWF', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Filter for acoustic mode (y)',  &
      & units='m.s-2',    &
      & xtype='float')

!    call HistoryAutoAddVariable(  &
!      & varname='VelYTndNs', &
!      & dims=(/'x','y','z','t'/),     &
!      & longname='Velocity Tendency (y)',  &
!      & units='m.s-2',    &
!      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZAdv', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Advection term of velocity (z)',  &
      & units='m.s-2',    &
      & xtype='float')
    
    call HistoryAutoAddVariable(  &
      & varname='VelZNDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Numerical diffusion term of Velocity (z)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZBuoyT',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Buoyancy (Temperature)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZBuoyM',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Buoyancy (MolWt)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZBuoyD',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Buoyancy (Drag)',&
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZPGrad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Pressure gradient term of velocity (z)',  &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZSWF', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Filter for acoustic mode (z)',  &
      & units='m.s-2',    &
      & xtype='float')

!    call HistoryAutoAddVariable(  &
!      & varname='VelZTndNs', &
!      & dims=(/'x','y','z','t'/),     &
!      & longname='Velocity Tendency (z)',  &
!      & units='m.s-2',    &
!      & xtype='float')

!    call HistoryAutoAddVariable(  &
!      & varname='VelDiv', &
!      & dims=(/'x','y','z','t'/),     &
!      & longname='Velocity Divergence',  &
!      & units='s-1',    &
!      & xtype='float')

!    call HistoryAutoAddVariable(  &
!      & varname='VelLapla', &
!      & dims=(/'x','y','z','t'/),     &
!      & longname='Velocity Lapla',  &
!      & units='m-1.s-1',    &
!      & xtype='float')

  end subroutine Dynamics_Init


  subroutine Dynamics_Km_forcing(         &
    & pyz_VelXNl, xqz_VelYNl, xyr_VelZNl, & ! (in)
    & xyz_KmBl,    xyz_KmNl,              & ! (in)
    & xyz_DKmDtNl                         & ! (inout)
    & )

    implicit none

    real(DP), intent(in) :: pyz_VelXNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xqz_VelYNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyr_VelZNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(in) :: xyz_KmBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyz_KmNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: xyz_DKmDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_Orig(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_NDiff(imin:imax,jmin:jmax,kmin:kmax)

    !----------------------------------
    ! Ȼ
    !

    ! Initialize
    !
    xyz_Orig = xyz_DKmDtNl

    ! Advection term
    !
    xyz_Adv  =                                              &
      & - xyz_avr_pyz(pyz_VelXNl * pyz_c4dx_xyz(xyz_KmNl))  &
      & - xyz_avr_xqz(xqz_VelYNl * xqz_c4dy_xyz(xyz_KmNl))  &
      & - xyz_avr_xyr(xyr_VelZNl * xyr_c4dz_xyz(xyz_KmNl))    

    ! Numerical diffusion term 
    !
    xyz_NDiff =                                        &
      &  - NuHm * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz( xyz_KmBl ))))) &
      &  - NuHm * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz( xyz_KmBl ))))) &
      &  - NuVm * (xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz( xyz_KmBl ))))) 
    
    xyz_DKmDtNl = xyz_Orig + xyz_Adv + xyz_NDiff
    
    ! Set Margin
    !
!    call SetMargin_xyz( xyz_DKmDtNl )

  end subroutine Dynamics_Km_forcing


  subroutine Dynamics_Long_forcing(        &
    & pyz_VelXBl,  pyz_VelXNl,    & ! (in)
    & xqz_VelYBl,  xqz_VelYNl,    & ! (in)
    & xyr_VelZBl,  xyr_VelZNl,    & ! (in)
    & xyz_PTempBl, xyz_PTempNl,   & ! (in)
    & xyzf_QMixBl, xyzf_QMixNl,   & ! (in)
    & xyz_CDensBl, xyz_CDensNl,   & ! (in)
    & pyz_DVelXDtNl,              & ! (inout)
    & xqz_DVelYDtNl,              & ! (inout)
    & xyr_DVelZDtNl,              & ! (inout)
    & xyz_DPTempDtNl,             & ! (inout)
    & xyzf_DQMixDtNl,             & ! (inout)
    & xyz_DCDensDtNl,             & ! (inout)
    & xyz_PTempAl,                & ! (out)
    & xyzf_QMixAl                 & ! (out)
    & )

    implicit none

    real(DP), intent(in) :: pyz_VelXBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: pyz_VelXNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xqz_VelYBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xqz_VelYNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyr_VelZBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyr_VelZNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(in) :: xyz_PTempBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyz_PTempNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyzf_QMixBl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(in) :: xyzf_QMixNl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(inout) :: pyz_DVelXDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: xqz_DVelYDtNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(inout) :: xyr_DVelZDtNl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(inout) :: xyz_DPTempDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: xyzf_DQMixDtNl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(out) :: xyz_PTempAl(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP), intent(out) :: xyzf_QMixAl(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP), intent(in) :: xyz_CDensBl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in) :: xyz_CDensNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout) :: xyz_DCDensDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: pyz_Orig(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: pyz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: pyz_NDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xqz_Orig(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xqz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xqz_NDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_Orig(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_NDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_BuoyT(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_BuoyM(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyr_BuoyD(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_Orig(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_NDiff(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_PTempAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyzf_Orig(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP)             :: xyzf_Adv(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP)             :: xyzf_NDiff(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP)             :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax, 1:ncmax)
    real(DP)             :: xyzf_QMixPerMolWt(imin:imax,jmin:jmax,kmin:kmax, 1:GasNum)
    integer              :: f

    !------------------------------
    ! tendency of cloud density    
    ! 

    ! initialize 
    xyz_Orig = xyz_DCDensDtNl

    ! եåη׻. 4 濴ʬѤƷ׻
    !
    xyz_Adv = &
      & - xyz_c4dx_pyz(pyz_VelXNl * pyz_avr_xyz(xyz_CDensNl)) &
      & - xyz_c4dy_xqz(xqz_VelYNl * xqz_avr_xyz(xyz_CDensNl)) &
      & - xyz_c4dz_xyr(xyr_VelZNl * xyr_avr_xyz(xyz_CDensNl)) 

    ! Ǵη׻
    xyz_NDiff = &
      &  - NuHh * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz(xyz_CDensBl))))) &
      &  - NuHh * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz(xyz_CDensBl))))) &
      &  - NuVh * (xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz(xyz_CDensBl))))) 
    
    xyz_DCDensDtNl = xyz_Orig + xyz_Adv + xyz_NDiff

    call HistoryAutoPut(TimeN, 'CDensAdv',  xyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'CDensNDiff', xyz_NDiff(1:nx,1:ny,1:nz))


    ! tendency of potential temperature
    ! 

    ! initialize 
    xyz_Orig = xyz_DPTempDtNl
    xyz_PTempAll = xyz_PTempNl + xyz_PTempBZ

    ! Advection term
    ! xyz_AdvScalar( xyz_PTempNl + xyz_PTempBZ, pyz_VelXNl, pyz_VelXNl, xyr_VelZNl) 
    !
    xyz_Adv = &
      & - xyz_avr_pyz(pyz_VelXNl * pyz_c4dx_xyz(xyz_PTempAll))  &
      & - xyz_avr_xqz(xqz_VelYNl * xqz_c4dy_xyz(xyz_PTempAll))  &
      & - xyz_avr_xyr(xyr_VelZNl * xyr_c4dz_xyz(xyz_PTempAll))  

    ! numerical diffusion term
    ! xyz_Num = xyz_NumDiffScalar( xyz_PTempBl)
    !
    xyz_NDiff = &
      &  - NuHh * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz( xyz_PTempBl ))))) &
      &  - NuHh * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz( xyz_PTempBl ))))) &
      &  - NuVh * (xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz( xyz_PTempBl ))))) 

    ! sum
    !
    xyz_DPTempDtNl = xyz_Orig + xyz_Adv + xyz_NDiff
    
    ! output
    !
    call HistoryAutoPut(TimeN, 'PTempAdv',   xyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'PTempNDiff', xyz_NDiff(1:nx,1:ny,1:nz))

    xyz_PTempAl = xyz_PTempBl + (2.0d0 * DelTimeLong) * xyz_DPTempDtNl

    ! Set Margin
    !
    call SetMargin_xyz(xyz_PTempAl)

    
    !------------------------------
    ! tendency of mixing ratio
    ! 

    ! initialize
    xyzf_Orig = xyzf_DQMixDtNl
    xyzf_QMixAll = xyzf_QMixNl + xyzf_QMixBZ

    do f = 1, ncmax
      ! Advection term
      !xyzf_Adv  = xyzf_AdvScalar(xyzf_QMixNl + xyzf_QMixBZ, pyz_VelXNl, xqz_VelYNl, xyr_VelZNl)
      !
      xyzf_Adv(:,:,:,f) = &
        & - xyz_avr_pyz(pyz_VelXNl * pyz_c4dx_xyz(xyzf_QMixAll(:,:,:,f))) &
        & - xyz_avr_xqz(xqz_VelYNl * xqz_c4dy_xyz(xyzf_QMixAll(:,:,:,f))) &
        & - xyz_avr_xyr(xyr_VelZNl * xyr_c4dz_xyz(xyzf_QMixAll(:,:,:,f)))    

      ! numerical diffusion term
      ! xyzf_Diff = xyzf_NumDiffScalar(xyzf_QMixBl) 
      !
      xyzf_NDiff(:,:,:,f) = &
        &  - NuHh * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz( xyzf_QMixBl(:,:,:,f) ))))) &
        &  - NuHh * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz( xyzf_QMixBl(:,:,:,f) ))))) &
        &  - NuVh * (xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz( xyzf_QMixBl(:,:,:,f) )))))
    end do

    ! sum
    !
    xyzf_DQMixDtNl = xyzf_Orig + xyzf_Adv + xyzf_NDiff

    ! output
    !
    do f = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(f))//'_Adv',   xyzf_Adv(1:nx,1:ny,1:nz,f))
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(f))//'_NDiff', xyzf_NDiff(1:nx,1:ny,1:nz,f))
    end do

    ! time integration
    !
    xyzf_QMixAl = xyzf_QMixBl + (2.0d0 * DelTimeLong) * xyzf_DQMixDtNl

    ! Set Margin
    ! 
    call SetMargin_xyzf(xyzf_QMixAl)

    ! ͤ
    !
    call FillNegativeQMix(xyzf_QMixAl)

    ! Set Margin
    ! 
    call SetMargin_xyzf(xyzf_QMixAl)

    !------------------------------
    ! tendency of VelX
    ! 

    ! initializa
    !
    pyz_Orig = pyz_DVelXDtNl

    ! Advection term
    !pyz_Adv  = pyz_AdvVelX(pyz_VelXNl, xqz_VelYNl, xyr_VelZNl) 
    !
    pyz_Adv  = &
      & - pyz_VelXNl * pyz_avr_xyz( xyz_c4dx_pyz( pyz_VelXNl ) )                &
      & - pyz_avr_pqz( pqz_avr_xqz( xqz_VelYNl ) * pqz_c4dy_pyz( pyz_VelXNl ) ) &
      & - pyz_avr_pyr( pyr_avr_xyr( xyr_VelZNl ) * pyr_c4dz_pyz( pyz_VelXNl ) )

    ! Numerical diffusion term 
    !pyz_Diff = pyz_NumDiffVelX(pyz_VelXBl)
    pyz_NDiff = &
      & - NuHm * ( pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz( pyz_VelXBl ))))) &
      & - NuHm * ( pyz_dy_pqz(pqz_dy_pyz(pyz_dy_pqz(pqz_dy_pyz( pyz_VelXBl ))))) &
      & - NuVm * ( pyz_dz_pyr(pyr_dz_pyz(pyz_dz_pyr(pyr_dz_pyz( pyz_VelXBl )))))

    ! sum
    !
    pyz_DVelXDtNl = pyz_Orig + pyz_Adv + pyz_NDiff

    call HistoryAutoPut(TimeN, 'VelXAdv',   pyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelXNDiff', pyz_NDiff(1:nx,1:ny,1:nz))

    !------------------------------
    ! tendency of VelY
    !     

    ! ininitalize
    xqz_Orig = xqz_DVelYDtNl

    ! Advection term
    ! xqz_Adv  = xqz_AdvVelY(pyz_VelXNl, xqz_VelYNl, xyr_VelZNl)
    !
    xqz_Adv  = &
      & - xqz_avr_pqz( pqz_avr_pyz( pyz_VelXNl ) * pqz_c4dx_xqz( xqz_VelYNl ) ) &
      & - xqz_VelYNl * xqz_avr_xyz( xyz_c4dy_xqz( xqz_VelYNl ) ) &
      & - xqz_avr_xqr( xqr_avr_xyr( xyr_VelZNl ) * xqr_c4dz_xqz( xqz_VelYNl ) )

    ! Numerical diffusion term
    ! xqz_Diff = xqz_NumDiffVelY(xqz_VelYBl)
    !
    xqz_NDiff = &
      & - NuHm * ( xqz_dx_pqz(pqz_dx_xqz(xqz_dx_pqz(pqz_dx_xqz( xqz_VelYBl ))))) &
      & - NuHm * ( xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz( xqz_VelYBl ))))) &
      & - NuVm * ( xqz_dz_xqr(xqr_dz_xqz(xqz_dz_xqr(xqr_dz_xqz( xqz_VelYBl )))))

    ! sum
    !
    xqz_DVelYDtNl = xqz_Orig + xqz_Adv + xqz_NDiff
    
    call HistoryAutoPut(TimeN, 'VelYAdv',   xqz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelYNDiff', xqz_NDiff(1:nx,1:ny,1:nz))

    !------------------------------
    ! tendency of VelZ
    ! 

    ! Initialization
    !
    xyr_Orig = xyr_DVelZDtNl
    
    do f = 1, GasNum
      xyzf_QMixPerMolWt(:,:,:,f) = xyzf_QMixNl(:,:,:,IdxG(f)) / MolWtWet(IdxG(f))
    end do

    ! Advection term
    ! xyr_Adv  = xyr_AdvVelZ(pyz_VelXNl, xqz_VelYNl, xyr_VelZNl)
    !
    xyr_Adv  = &
      & - xyr_avr_pyr( pyr_avr_pyz( pyz_VelXNl ) * pyr_c4dx_xyr( xyr_VelZNl ) ) &
      & - xyr_avr_xqr( xqr_avr_xqz( xqz_VelYNl ) * xqr_c4dy_xyr( xyr_VelZNl ) ) &
      & - xyr_VelZNl * xyr_avr_xyz( xyz_c4dz_xyr( xyr_VelZNl ) )

    ! Numerical diffusion term
    !xyr_Diff = xyr_NumDiffVelZ(xyr_VelZBl)
    !
    xyr_NDiff = &
      & - NuHm * ( xyr_dx_pyr(pyr_dx_xyr(xyr_dx_pyr(pyr_dx_xyr( xyr_VelZBl ))))) &
      & - NuHm * ( xyr_dy_xqr(xqr_dy_xyr(xyr_dy_xqr(xqr_dy_xyr( xyr_VelZBl ))))) & 
      & - NuVm * ( xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr( xyr_VelZBl )))))

    ! Buoyancy due to temperature disturbunce
    !xyr_BuoyT = xyr_Buoy(xyz_PTempNl)
    !
    xyr_BuoyT = Grav * xyr_avr_xyz( xyz_PTempNl / xyz_PTempBZ)

    ! Buoyancy due to molecular weight
    !
    xyr_BuoyM =                                                   &
      & + Grav * xyr_avr_xyz( sum(xyzf_QMixPerMolWt, 4) )        &
      &    / ( 1.0d0 / MolWtDry + xyr_QMixBZPerMolWt )       &
      & - Grav * xyr_avr_xyz( sum(xyzf_QMixNl(:,:,:,1:GasNum), 4) )&
      &    / ( 1.0d0 + xyr_QmixBZ )

    ! Buoyancy due to loading
    !
    xyr_BuoyD =                                                           &
      & - Grav * xyr_avr_xyz( sum(xyzf_QMixNl(:,:,:,GasNum+1:ncmax), 4) ) &
      &    / ( 1.0d0 + xyr_QMixBZ )

    ! sum
    !
    xyr_DVelZDtNl = xyr_Orig + xyr_Adv + xyr_NDiff + xyr_BuoyT + xyr_BuoyM + xyr_BuoyD

    call HistoryAutoPut(TimeN, 'VelZAdv',   xyr_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelZNDiff', xyr_NDiff(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'VelZBuoyT', xyr_BuoyT(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'VelZBuoyM', xyr_BuoyM(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'VelZBuoyD', xyr_BuoyD(1:nx,1:ny,1:nz))    

    ! Set Margin
    !
!    call SetMargin_pyz( pyz_DVelXDtNl )
!    call SetMargin_xqz( xqz_DVelYDtNl )
!    call SetMargin_xyr( xyr_DVelZDtNl )
!    call SetMargin_xyz( xyz_DPTempDtNl )
!    call SetMargin_xyz( xyz_DCDensDtNl )
!    call SetMargin_xyzf(xyzf_DQMixDtNl )
 
  end subroutine Dynamics_Long_forcing
 

  subroutine Dynamics_Short_forcing(  &
        &  pyz_VelXNs,          & ! (in)
        &  xqz_VelYNs,          & ! (in)
        &  xyr_VelZNs,          & ! (in)
        &  xyz_ExnerNs,         & ! (in)
        &  pyz_DVelXDtNl,       & ! (in)
        &  xqz_DVelYDtNl,       & ! (in)
        &  xyr_DVelZDtNl,       & ! (in)
        &  xyz_DExnerDtNl,      & ! (in)
        &  xyz_DExnerDtNs,      & ! (in)
        &  pyz_VelXAs,          & ! (out)
        &  xqz_VelYAs,          & ! (out)
        &  xyr_VelZAs,          & ! (out)
        &  xyz_ExnerAs          & ! (out)
        & )

    real(DP), intent(in)  :: pyz_VelXNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xqz_VelYNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyr_VelZNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyz_ExnerNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: pyz_DVelXDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xqz_DVelYDtNl(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyr_DVelZDtNl(imin:imax,jmin:jmax,kmin:kmax)
!    real(DP), intent(in)  :: xyz_DExnerDtNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout)  :: xyz_DExnerDtNl(imin:imax,jmin:jmax,kmin:kmax) !test
    real(DP), intent(inout)  :: xyz_DExnerDtNs(imin:imax,jmin:jmax,kmin:kmax) !test
    real(DP), intent(out) :: pyz_VelXAs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xqz_VelYAs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyr_VelZAs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_ExnerAs(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: pyz_DVelXDtNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xqz_DVelYDtNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyr_DVelZDtNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_VelDivNs(imin:imax,jmin:jmax,kmin:kmax)
!    real(DP) :: xyz_VelLaplaNs(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: pyz_VelXPGrad(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xqz_VelYPGrad(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyr_VelZPGrad(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: pyz_VelXSWF(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xqz_VelYSWF(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyr_VelZSWF(imin:imax,jmin:jmax,kmin:kmax)

    real(DP) :: xyz_ExnerAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_Adv(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_NDiff(imin:imax,jmin:jmax,kmin:kmax)

    ! initialize: Divergence of velocity
    !
    xyz_VelDivNs = &
      &   xyz_dx_pyz( pyz_VelXNs ) &
      & + xyz_dy_xqz( xqz_VelYNs ) &
      & + xyz_dz_xyr( xyr_VelZNs )
!    call HistoryAutoPut(TimeN, 'VelDiv', xyz_VelDivNs(1:nx,1:ny,1:nz))

!    xyz_VelLaplaNs = pyz_dx_xyz( xyz_VelDivNs ) +  xqz_dy_xyz( xyz_VelDivNs ) +  xyr_dz_xyz( xyz_VelDivNs )
!    call HistoryAutoPut(TimeN, 'VelLapla', xyz_VelLaplaNs(1:nx,1:ny,1:nz))

    !--------------------------------------
    ! VelX
    !
    pyz_VelXSWF   =   AlphaH * pyz_dx_xyz( xyz_VelDivNs ) 
    pyz_VelXPGrad = - pyz_avr_xyz( CpDry * xyz_VPTempBZ ) * pyz_dx_xyz( xyz_ExnerNs ) &
      &             + pyz_VelXSWF
    pyz_DVelXDtNs =   pyz_VelXPGrad 

    ! Time integration
    !
    pyz_VelXAs    = pyz_VelXNs + DelTimeShort * (pyz_DVelXDtNl + pyz_DVelXDtNs)

    call HistoryAutoPut(TimeN, 'VelXPGrad', pyz_VelXPGrad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelXSWF',   pyz_VelXSWF(1:nx,1:ny,1:nz))
!    call HistoryAutoPut(TimeN, 'VelXTndNs', pyz_DVelXDtNs(1:nx,1:ny,1:nz))

    ! Set Margin
    !
    call SetMargin_pyz( pyz_VelXAs ) ! (inout)

    !--------------------------------------
    ! VelY
    !    
    xqz_VelYSWF   =   AlphaH * xqz_dy_xyz( xyz_VelDivNs ) 
    xqz_VelYPGrad = - xqz_avr_xyz( CpDry * xyz_VPTempBZ ) * xqz_dy_xyz( xyz_ExnerNs ) &
      &             + xqz_VelYSWF
    xqz_DVelYDtNs =   xqz_VelYPGrad
    
    ! Time integration
    !
    xqz_VelYAs = xqz_VelYNs + DelTimeShort * (xqz_DVelYDtNl + xqz_DVelYDtNs)

    call HistoryAutoPut(TimeN, 'VelYPGrad', xqz_VelYPGrad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelYSWF',   xqz_VelYSWF(1:nx,1:ny,1:nz))
!    call HistoryAutoPut(TimeN, 'VelYTndNs', xqz_DVelYDtNs(1:nx,1:ny,1:nz))

    ! Set Margin
    !
    call SetMargin_xqz( xqz_VelYAs ) ! (inout)
    
    !--------------------------------------
    ! Exner function
    !

    ! եåη׻. 4 濴ʬѤƷ׻
    !
    xyz_Adv = &
      & - xyz_avr_pyz(pyz_VelXNs * pyz_c4dx_xyz(xyz_ExnerNs))  &
      & - xyz_avr_xqz(xqz_VelYNs * xqz_c4dy_xyz(xyz_ExnerNs))  &
      & - xyz_avr_xyr(xyr_VelZNs * xyr_c4dz_xyz(xyz_ExnerNs))  !&  
!      & + CpDry / CvDry * GasRDry * xyz_ExnerNs * xyz_VelDivNs

    ! Ǵη׻
    xyz_NDiff = &
      &  - NuHh * (xyz_dx_pyz(pyz_dx_xyz(xyz_dx_pyz(pyz_dx_xyz(xyz_ExnerNs))))) &
      &  - NuHh * (xyz_dy_xqz(xqz_dy_xyz(xyz_dy_xqz(xqz_dy_xyz(xyz_ExnerNs))))) &
      &  - NuVh * (xyz_dz_xyr(xyr_dz_xyz(xyz_dz_xyr(xyr_dz_xyz(xyz_ExnerNs))))) 

    ! û֥ƥåפǤtendency 
    xyz_DExnerDtNs = xyz_DExnerDtNs + xyz_Adv + xyz_NDiff

    !!!!!!!!!!!!!!!!!!!!!!!
    !
    ! test 
    !
    !!!!!!!!!!!!!!!!!!!!!!!
    xyz_DExnerDtNs = 0.0d0

    call HistoryAutoPut(TimeN, 'ExnerAdv',   xyz_Adv(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'ExnerNDiff', xyz_NDiff(1:nx,1:ny,1:nz))

    xyz_ExnerAs = xyz_Exner( &
      & pyz_VelXAs,          &
      & xqz_VelYAs,          &
      & xyr_VelZNs,          &
      & xyz_VelDivNs,        &
      & xyz_ExnerNs,         &
      & xyr_DVelZDtNl,       &
      & xyz_DExnerDtNl,      &
      & xyz_DExnerDtNs       &
      & )

    ! Set Margin
    !
    call SetMargin_xyz( xyz_ExnerAs ) ! (inout)

!    write(*,*) "+++ Exner +++", xyz_ExnerAs(imin:imax,1,kmin:kmax)

    !--------------------------------------
    ! VelZ
    !
    xyr_VelZSWF =  AlphaV * xyr_dz_xyz( xyz_VelDivNs ) 
    xyr_VelZPGrad =                                          &
      & - xyr_avr_xyz(CpDry * xyz_VPTempBZ )                 &
      &   * (                                                &
      &       beta * xyr_dz_xyz( xyz_ExnerAs )               &
      &       + (1.0d0 - beta) * xyr_dz_xyz( xyz_ExnerNs )   &
      &     )                                                &
      & + xyr_VelZSWF
    xyr_DVelZDtNs = xyr_VelZPGrad 

    !OK
    ! write(*,*) "+++ DVelZDtNl +++", xyr_DVelZDtNl(1:nx,1,1:nz)

    !OK
    !write(*,*) "+++ PGrad +++", xyr_VelZPGrad(1:nx,1,1:nz)
    
    ! Time integration
    !
    xyr_VelZAs = xyr_VelZNs + DelTimeShort * (xyr_DVelZDtNl + xyr_DVelZDtNs)

    call HistoryAutoPut(TimeN, 'VelZPGrad', xyr_VelZPGrad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelZSWF',   xyr_VelZSWF(1:nx,1:ny,1:nz))
!    call HistoryAutoPut(TimeN, 'VelZTndNs', xyr_DVelZDtNs(1:nx,1:ny,1:nz))

    ! Set Margin
    !
    call SetMargin_xyr( xyr_VelZAs ) ! (inout)

    !OK
    !write(*,*) "+++ VelZ +++", xyr_VelZAs(1:nx,1,1:nz)
    !stop

  end subroutine Dynamics_Short_forcing

  
!!!--------------------------------------------------------------------!!!
  subroutine DynamicsVI_init()
    !
    !ʡؿ򱢲ˡǲ򤯺ݤɬפȤʤ, Ǥ, 
    !LU ʬԤ. 
    !

    !ۤηػ
    implicit none

    real(DP)  :: DTS ! ûֳʻ

    DTS = DelTimeShort

    !γդ
    allocate( A(1:nz) )
    allocate( B(1+1:nz) )
    allocate( C(1:nz-1) )
    allocate( xyz_F1BZ(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyr_F2BZ(imin:imax,jmin:jmax,kmin:kmax) )

    !----------------------------------------------------------------
    ! ȶ̤Ѥͤ
    !----------------------------------------------------------------

    !η׻
    !  A, B, C , F1BZ  F2BZ  X ˰ͤʤΤ. 
    !  nx, ny ͤɽ뤳ȤȤ. 
    xyz_F1BZ =                                                &
      &  ( xyz_VelSoundBZ ** 2.0d0 )                          &
      &   / (CpDry * xyz_DensBZ * (xyz_VPTempBZ ** 2.0d0))

    xyr_F2BZ =                                                &
      &  xyr_avr_xyz(                                         &
      &    CpDry * xyz_DensBZ * ( xyz_VPTempBZ ** 2.0d0 )     &
      &   )
    
    A(1+1: nz-1) =                                &
      & (beta ** 2.0d0)                                      &
      &    * xyz_F1BZ(nx,ny,1+1: nz-1)  &  
      &    * (DTS ** 2.0d0)                                  &
      &    * (                                               &
      &          xyr_F2BZ(nx,ny,1+1: nz-1)  &
      &            / r_dz(1+1: nz-1)              &
      &        + xyr_F2BZ(nx,ny,1  : nz-2)  &
      &            / r_dz(1: nz-2)                &
      &       )                                              &
      &    / z_dz(1+1: nz-1)                      &
      & + 1.0d0

    A(1) =                                        &
      & (beta ** 2.0d0)                               &
      &   * xyz_F1BZ(nx,ny,1)       &
      &   * xyr_F2BZ(nx,ny,1)       &
      &     / r_dz(1)                             &
      &   * (DTS ** 2.0d0)                              &
      &   / z_dz(1)                               &
      & + 1.0d0                                         

    A(nz) =                                        &
      & (beta ** 2.0d0)                               &
      &   * xyz_F1BZ(nx,ny,nz)       &
      &   * xyr_F2BZ(nx,ny,nz-1)     &
      &     / r_dz(nz-1)                           &
      &   * (DTS ** 2.0d0)                              &
      &   / z_dz(nz)                               &
      & + 1.0d0                                         
    
    B(1+1:nz) =                                 &
      & - (beta ** 2.0d0)                                  &
      &   * xyz_F1BZ(nx,ny,1:nz-1)    &
      &   * xyr_F2BZ(nx,ny,1:nz-1)    &
      &   * (DTS ** 2.0d0)                                 &
      &   / ( r_dz(1:nz-1) * z_dz(1:nz-1) )
    
    C(1: nz-1) =                           &
      & - ( beta ** 2.0d0 )                           &
      &   * xyz_F1BZ(nx,ny,1+1:nz)    &
      &   * xyr_F2BZ(nx,ny,1  :nz-1)  &
      &   * (DTS ** 2.0d0) &
      &   / ( r_dz(1:nz-1) * z_dz(1+1:nz) )


    !----------------------------------------------------------------
    !  LU ʬ
    !----------------------------------------------------------------
    !礭ݴ
    N   = nz  !/μ, ˡ
    M   = nx * ny 
                               !ȿ
    NUD = 1                    !ξ廰ʬ
    NLD = 1                    !βʬ
    NAL = NLD                  !LU ʬη L ˡ
    NA  = NUD + NLD + 1

    !γ
!    allocate( AL1(N), AL2(NAL, N), AU2(NA, N), IP(N) )
    allocate( AL1(N), IP(N) )

    !LU ʬμ¹
    !  LAPACK 
    call ResolvLU_Lapack( )

   
  end subroutine DynamicsVI_init
  

!!!--------------------------------------------------------------------!!!
  function xyz_Exner(      &
    & pyz_VelXAs,          &
    & xqz_VelYAs,          &
    & xyr_VelZNs,          &
    & xyz_VelDivNs,        &
    & xyz_ExnerNs,         &
    & xyr_DVelZDtNl,       &
    & xyz_DExnerDtNl,      &
    & xyz_DExnerDtNs       &
    & )
    !
    !ˡѤʡؿη׻. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)   :: pyz_VelXAs &
      &                     (imin:imax,jmin:jmax,kmin:kmax) 
                                                           !® u [+]
    real(DP), intent(in)   :: xqz_VelYAs &
      &                     (imin:imax,jmin:jmax,kmin:kmax) 
                                                           !® v [+]
    real(DP), intent(in)   :: xyr_VelZNs &
      &                     (imin:imax,jmin:jmax,kmin:kmax) 
                                                           !® w []
    real(DP), intent(in)   :: xyz_VelDivNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)   :: xyr_DVelZDtNl &
      &                     (imin:imax,jmin:jmax,kmin:kmax) 
                                                           !Z γϹ[t]
    real(DP), intent(in)   :: xyz_DExnerDtNl &
      &                     (imin:imax,jmin:jmax,kmin:kmax) 
                                                           !Z γϹ[t]
    real(DP), intent(in)   :: xyz_DExnerDtNs &
      &                     (imin:imax,jmin:jmax,kmin:kmax) 
                                                           !Z γϹ[t]
    real(DP), intent(in)   :: xyz_ExnerNs &
      &                     (imin:imax,jmin:jmax,kmin:kmax) 
                                                           !̵
    real(DP)               :: xyz_Exner &
      &                     (imin:imax,jmin:jmax,kmin:kmax) 
                                                           !̵[+]

    !ѿ
    real(DP)  :: D1(imin:imax,jmin:jmax,kmin:kmax)  
    real(DP)  :: D2(1:nx,1:ny,1:nz)  
    real(DP)  :: D(nx*ny,nz)
    real(DP)  :: E(imin:imax,jmin:jmax,kmin:kmax)  
    real(DP)  :: F(imin:imax,jmin:jmax,kmin:kmax)  
    real(DP)  :: xyz_DivVelNs(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)  :: DTS ! ûֳʻҴֳ
    integer   :: ix, jy, kz

    ! Initialize
    DTS = DelTimeShort
    xyz_Exner = 0.0d0
    !׻Τη
    E =   &
      & - ( 1.0d0 - beta ) * xyr_dz_xyz( xyz_ExnerNs )               &
      & + ( AlphaV * xyr_dz_xyz( xyz_VelDivNs ) + xyr_DVelZDtNl )    &
      &    / xyr_avr_xyz( CpDry * xyz_VPTempBZ ) 

    F = - beta * xyz_F1BZ * DTS                                     &
      & * xyz_dz_xyr(                                               &
      &    xyr_avr_xyz( xyz_DensBZ * xyz_VPTempBZ)                  &
      &    * (                                                      &
      &         xyr_VelZNs                                          &
      &       - xyr_avr_xyz(CpDry * xyz_VPTempBZ) * DTS             &
      &         * (1.0d0 - beta) * xyr_dz_xyz( xyz_ExnerNs )        &
      &       + AlphaV * xyr_dz_xyz( xyz_VelDivNs ) * DTS           &
      &       + xyr_DVelZDtNl * DTS                                 &
      &      )                                                      &
      &   )                                                         &
      & + (xyz_DExnerDtNs + xyz_DExnerDtNl ) * DTS

    D1 = xyz_ExnerNs                                                &
      & - (1.0d0 - beta)                                            &
      &   * xyz_F1BZ * DTS                                          &
      &   * xyz_dz_xyr(                                             &
      &       xyr_avr_xyz(xyz_DensBZ * xyz_VPTempBZ) * xyr_VelZNs   &
      &     )                                                       &
      & - (xyz_VelSoundBZ ** 2.0d0) * DTS                           &
      &   / (CpDry * xyz_VPTempBZ) * xyz_dx_pyz( pyz_VelXAs )       &
      & - (xyz_VelSoundBZ ** 2.0d0) * DTS                           & 
      &   / (CpDry * xyz_VPTempBZ) * xyz_dy_xqz( xqz_VelYAs )       &
      & + F

    D1(:,:,1) = D1(:,:,1)                           &
      & - beta * xyz_F1BZ(:,:,1) * (DTS ** 2.0d0)         &
      &   * xyr_F2BZ(:,:, 1-1) * E(:,:,1-1)         &
      &   / z_dz(1)
    
    D1(:,:,nz) = D1(:,:,nz)                           &
      & + beta * xyz_F1BZ(:,:,nz) * (DTS ** 2.0d0)         &
      &   * xyr_F2BZ(:,:,nz) * E(:,:,nz)              &
      &   / z_dz(nz)     

    D2 = D1(1:nx,1:ny,1:nz)

    do kz = 1, nz
      do jy = 1, ny 	
        do ix = 1, nx 	
	  D(ix + nx * (jy - 1), kz) =  D2(ix,jy,kz)
        end do 
      end do
    end do	

    !-----------------------------------------------------------
    !ϢΩ켡β
    !------------------------------------------------------------

    !η׻
    !  LAPACK 
    call LinSolv_Lapack( D )

    !ͤ
    do kz = 1, nz
      do jy = 1, ny 	
        do ix = 1, nx 	
          xyz_Exner(ix,jy,kz) = D(ix + nx * (jy - 1 ), kz)
        end do 
      end do
    end do	

  end function xyz_Exner

!!!--------------------------------------------------------------------!!!
  subroutine ResolvLU_Lapack(  )
    !
    ! 3  LU ʬ(). LAPACK 
    !

    !ۤηػ
    implicit none

    !ѿ
    integer    :: INFO  !Υǥå
    
    !ѿν
    INFO = 0
    
    !η׻. LAPACK . 
    call DGTTRF(N, C, A, B, AL1, IP, INFO)
    
    !Υǥå. 
!    if (INFO /= 0) then
!      call MessageNotify("Error", "lapack_linear", "INFO is not 0")
!      stop
!    end if
    
  end subroutine ResolvLU_Lapack
  

!!!--------------------------------------------------------------------!!!
  subroutine LinSolv_Lapack( X )
    !
    !LU ʬ򤵤줿 3 ϢΩ 1 (). LAPACK 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(inout) :: X(M, N)     !/
    real(DP)                :: TX(N, M)    !ž֤
    integer                :: NRHS         !
    integer                :: INFO
    integer                :: LDB
    character(1),parameter :: TRANS = 'N'

    !ѿν
    NRHS = M
    INFO = 0
    LDB  = N
    TX = transpose( X )
    
    !η׻. LAPACK . 
    call DGTTRS(TRANS, N, NRHS, C, A, B, AL1, IP, TX, LDB, INFO)

    !ν
    X = transpose( TX )
     
    !Υǥå. 
!    if (INFO /= 0) then
!      call MessageNotify("Error", "lapack_linear", "INFO is not 0")
!      stop
!    end if
     
  end subroutine LinSolv_Lapack

end module DynamicsHEVI

