!c Description: 
!c   CFL $B>r7o$N%A%'%C%/(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-04    $B9b66$3$&;R(B $B:n@.(B
!c   1.1        2003-12-22    $B?y;39L0lO/(B $B=$@5(B
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

subroutine cflchk

  !--- $B%b%8%e!<%k$NFI$_9~$_(B
  use gridset, only: im, km, bm, dx
  use integrt, only: dts, beta
  use physprm, only: gasr
  use prm, only: cp, cv, rho
  use basicenv, only: pi_bs, vtheta_bs

  !--- $B0EL[$N7?@k8@6X;_(B
  implicit none

  !--- $BFbItJQ?t(B
  real(8), allocatable   :: c2_bs(:,:)
  real(8)                :: c
  real(8)                :: cfl
  
  allocate(c2_bs(-bm:im+bm, -bm:km+bm))
  c2_bs = cp * gasr * pi_bs * vtheta_bs / (cv * rho)
  c = maxval(c2_bs)
  c = sqrt(c)
  cfl = dx / c

  if (dts >= cfl) then 
     write(*,*) "CFL $B>r7o$,GKC>$7$F$$$^$9(B"
     write(*,*) "$B2;B.(B", c
     write(*,*) "$B?eJ?3J;R4V3V(B", dx
     write(*,*) "$B;~4V9o$_I}(B", dts
     stop
  end if

end subroutine cflchk


