!c Description: 
!c   ʬ黻
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-19    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_diff
  interface diff

     subroutine diff_2d(type, var, var_diff)
       integer, intent(in)               :: type
       real(8), intent(in)               :: var(:,:)
       real(8), intent(out), allocatable :: var_diff(:,:)
     end subroutine diff_2d
     
  end interface diff
end module if_diff



subroutine diff_2d(type, var, var_diff)
  !--- ⥸塼ɤ߹
  use gridset

  !--- ۤηػ
  implicit none

  !--- ѿ
  integer, intent(in)               :: type
  real(8), intent(in)               :: var(:,:)
  real(8), intent(out), allocatable :: var_diff(:,:)

  !--- ѿ
  allocate(var_diff(-bm:im+bm, -bm:km+bm))
  var_diff = 0.0d0


  !----------------------------------------------------
  !--- ʿѲ
  !----- case1: ñ x ʬ
  !----- case2: ñ z ʬ
  !----- case3: 
  !----- case4: 
  !-----
  !----------------------------------------------------
  select case (type)
  case (1)
     var_diff(-bm+1:im+bm,-bm:km+bm) =         &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm:km+bm)     &
          &   - var(-bm:im+bm-1,-bm:km+bm)     &
          &  ) / dx
     
  case (2)
     var_diff(-bm:im+bm,-bm+1:km+bm) =         &
          &  (                                 &
          &     var(-bm:im+bm,-bm+1:km+bm)     &
          &   - var(-bm:im+bm,-bm:km+bm-1)     &
          &  ) / dz
     
  case (3)
     var_diff(-bm+1:im+bm,-bm+1:km+bm-1) =     &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm+2:km+bm)   &
          &   + var(-bm:im+bm-1,-bm+2:km+bm)   &
          &   - var(-bm+1:im+bm,-bm:km+bm-2)   &
          &   - var(-bm:im+bm-1,-bm:km+bm-2)   &
          &  ) / (2.0d0 * dz)
     
  end select
     
end subroutine diff_2d
