!= ɽ٥ǡ
!
!= Prepare surface height data
!
! Authors::   Satoshi NODA
! Version::   $Id: surface_data.f90,v 1.11 2012-10-08 12:51:10 yot Exp $ 
! Tag Name::  $Name: dcpam5-20121128 $
! Copyright:: Copyright (C) GFD Dennou Club, 2014. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module surface_height_data
  !
  != ɽ̥ǡ
  !
  != Prepare surface height data
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! GCM Ѥɽ̥ǡޤ.
  ! ߤϻŪ Hosaka et al. (1998)  SST ʬۤͿޤ.
  !
  ! Surface data for GCM is generated.
  ! Now, SST profile in Hosaka et al. (1998) is provided tentatively.
  !
  !== Procedures List
  !
  ! SetSurfHeightData    :: ɽ٥ǡμ
  ! OutputFileSurfHeight :: ɽѤνϥե̾
  ! ------------  :: ------------
  ! SetSurfHeightData    :: Set surface height data
  ! OutputFileSurfHeight :: Output file name for surface height
  !
  !== NAMELIST
  !
  ! NAMELIST#surface_data_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ʪ
  ! Physical and mathematical constants settings
  !
  use constants0, only: &
    & PI                    ! $ \pi $.
                              ! ߼Ψ. Circular constant
  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetSurfHeightData
  public:: SurfHeightDataInit
  public:: OutputFileSurfHeight

  ! ѿ
  ! Public variables
  !
  logical, save :: surface_height_data_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(STRING), save:: OutputFileSurfHeight
  character(STRING), save:: Pattern
                              ! ɽ̥ǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Surface data pattern. 
                              ! Available patterns are as follows.
                              ! 
                              ! * 'Yamane and Yoden (1998)'
                              ! * 'Gaussian'
                              ! 
  real(DP), save:: NumberOfMount  ! Yamane and Yoden ˤϷȿ
  real(DP), save:: MountHeight    ! ɸ [m]
  real(DP), save:: MountTopLon    ! Gaussian ˤ뻳ĺη [deg.]
  real(DP), save:: MountTopLat    ! Gaussian ˤ뻳ĺΰ [deg.]
  real(DP), save:: MountHWHM
                              ! Gaussian ˤȾȾ. [deg.]
                              ! half width at half maximum, HWHM)


  character(*), parameter:: module_name = 'surface_height_data'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20121128 $' // &
    & '$Id: surface_data.f90,v 1.11 2012-10-08 12:51:10 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  !--------------------------------------------------------------------------------------

  subroutine SetSurfHeightData( &
    & xy_SurfHeight &
    & )
    !
    ! GCM Ѥɽ̥ǡ֤ޤ.
    !
    ! Return surface data for GCM.
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &              ! $ \lambda $ [rad.] . . Longitude
      & y_Lat                 ! $ \varphi $ [rad.] . . Latitude

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out), optional:: xy_SurfHeight (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature

    ! ѿ
    ! Work variables
    !
    real(DP):: d
    real(DP):: sig_gauss

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement


    ! ǧ
    ! Initialization check
    !
    if ( .not. surface_height_data_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    select case ( LChar( trim(Pattern) ) )

!    case ( 'homogeneous' )
!      ! 
!      ! homogeneous
!      !
!      if ( present(xy_SurfHeight) ) xy_SurfHeight = SurfHeight

    case ( 'yamane and yoden (1998)' )

      xy_SurfHeight = 0.0_DP
      do j = jmax/2 +1, jmax
        xy_SurfHeight(:,j) = 4.0_DP * MountHeight &
          & * sin(y_Lat(j))**2 * (1.0_DP - sin(y_Lat(j))**2) &
          & * sin(NumberOfMount * x_Lon)
      enddo

    case ( 'gaussian' )

      ! ȾȾʬʿ sigma 
      sig_gauss = MountHWHM / sqrt(2.0 * log(2.0))

      do j = 1, jmax
        do i = 0, imax-1
          ! ̻ˡΥ [rad] 
          d = acos( &
            &    sin(MountTopLat) * sin(y_Lat(j)) &
            &    + cos(MountTopLat) * cos(y_Lat(j)) * cos(MountTopLon - x_Lon(i)) &
            & )
          xy_SurfHeight(i,j) = exp( - d*d / (2.0 * sig_gauss**2) ) 
        enddo
      enddo
      xy_SurfHeight = MountHeight * xy_SurfHeight

    case default
      call MessageNotify( 'E', module_name, 'Pattern=<%c> is invalid.', &
        & c1 = trim(Pattern) )
    end select

  end subroutine SetSurfHeightData

  !--------------------------------------------------------------------------------------

  subroutine SurfHeightDataInit

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none

    character(STRING), save:: OutputFile
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /surface_height_data_nml/ &
      & OutputFile,    &
      & Pattern,       &
      & NumberOfMount, &
      & MountHeight,   &
      & MountTopLon,   &
      & MountTopLat,   &
      & MountHWHM    ! ȾȾ (half width at half maximum, HWHM). [deg.]

          !
          ! ǥեͤˤĤƤϽ³ "surface_height_data#SurfHeightDataInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_height_data#SurfHeightDataInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement

    if ( surface_height_data_inited ) return


    ! ǥեͤ (ޤ Pattern Τ)
    ! Default values settings (At first, "Pattern" only)
    !
    OutputFile    = 'surface_height.nc'
    Pattern       = 'Yamane and Yoden (1998)'
    NumberOfMount = 1.0_DP
    MountHeight   = 1000.0_DP
    MountTopLon   = 90.0_DP
    MountTopLat   = 45.0_DP
    MountHWHM     = 20.0_DP   ! [deg.]


    ! NAMELIST ɤ߹ (ޤ Pattern Τ)
    ! NAMELIST is input (At first, "Pattern" only)
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = surface_height_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = surface_height_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    OutputFileSurfHeight = OutputFile

    ! deg -> radian
    MountTopLon = MountTopLon * PI / 180.0_DP
    MountTopLat = MountTopLat * PI / 180.0_DP
    MountHWHM   = MountHWHM   * PI / 180.0_DP

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  OutputFile       = %c', c1 = trim(OutputFile) )
    call MessageNotify( 'M', module_name, '  Pattern          = %c', c1 = trim(Pattern) )
    call MessageNotify( 'M', module_name, '  NumberOfMount    = %f', d = (/ NumberOfMount /) )
    call MessageNotify( 'M', module_name, '  MountHeight      = %f', d = (/ MountHeight   /) )
    call MessageNotify( 'M', module_name, '  MountTopLon      = %f', d = (/ MountTopLon  /) )
    call MessageNotify( 'M', module_name, '  MountTopLat      = %f', d = (/ MountTopLat  /) )
    call MessageNotify( 'M', module_name, '  MountHWHM        = %f', d = (/ MountHWHM      /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    surface_height_data_inited = .true.

  end subroutine SurfHeightDataInit

  !--------------------------------------------------------------------------------------

end module surface_height_data
