dnl= Definitions of Functions for configure
dnl
dnl Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
dnl Version::   $Id: aclocal.m4,v 1.1 2009/03/26 08:45:26 morikawa Exp $
dnl Tag Name::  $Name: dcpam5-20140630-2 $
dnl Copyright:: Copyright (C) GFD Dennou Club, 2004-2007. All rights reserved.
dnl License::   See COPYRIGHT[link:COPYRIGHT]
dnl
dnl== Overview
dnl
dnl  These functions are reflected to configure script by autoconf 2.59
dnl
dnl


############################################################
#== Wrapper of AC_ARG_WITH
#
# usage: DC_ARG_WITH(withname, description, varname, ifnot)
#
AC_DEFUN(DC_ARG_WITH, [
	AC_ARG_WITH($1, [  --with-$1=ARG: $2], [
		$3=$withval
	], [
		AC_CACHE_CHECK([$2], $3, [$4])
	])
])

############################################################
#== Wrapper of AC_ARG_ENABLE
#
# usage: DC_ARG_ENABLE(feature, description, varname, ifnot)
#
AC_DEFUN(DC_ARG_ENABLE, [
	AC_ARG_ENABLE($1, [  --enable-$1: $2], [
		$3=$enableval
	], [
		AC_CACHE_CHECK([$2], $3, [$4])
	])
])

############################################################
#== Check libfile and set LIBDIR and  LIBNAME
#
# Check existence of "libfile" file, and set LIBDIR, LIBNAME
# from "libfile". "libfile" file must have suffixes ".a" or ".so"
#
# usage: DC_SET_LIBDIR_LIBNAME(libfile, LIBDIR, LIBNAME)
#
AC_DEFUN(DC_SET_LIBDIR_LIBNAME, [
	if test ! -f $1 ; then
		AC_MSG_ERROR(specified library file \"$1\" is not exist)
	fi

	$2=`dirname $1`
	case "$1" in
	    *.a)
		$3=`basename $1 .a | sed 's/^lib//'`
		;;
	    *.so)
		$3=`basename $1 .so | sed 's/^lib//'`
		;;
	    *)
		AC_MSG_ERROR(specified library file \"$1\" have invalid suffix. Valid suffixes are \".a\" or \".so\")
		;;
	esac
])


############################################################
#== Set MODDIR from libfile
#
# Check existence of "libfile". And set MODDIR,
#
# usage: DC_SET_MODDIR(libfile, MODDIR)
#
AC_DEFUN(DC_SET_MODDIR, [
	if test ! -f $1 ; then
		AC_MSG_ERROR(specified library file \"$1\" is not exist)
	fi

	DC_SET_MODDIR_libdir=`dirname $1`
	DC_SET_MODDIR_libname=`basename $1 .a | sed 's/^lib//'`

	DC_SET_MODDIR_try1=""; DC_SET_MODDIR_try2=""
	if test -d ${DC_SET_MODDIR_try1:=$DC_SET_MODDIR_libdir/module} ; then
		$2=$DC_SET_MODDIR_try1
	elif test -d ${DC_SET_MODDIR_try2:=`dirname $DC_SET_MODDIR_libdir`/include} ; then
		$2=$DC_SET_MODDIR_try2
	else
		AC_MSG_ERROR($DC_SET_MODDIR_libname module directory not found)
	fi
])


############################################################
#== Check for jLaTeX program
#
# Set jLaTeX command to "JLATEX"
#
# usage: DC_PROG_JLATEX
#
AC_DEFUN(DC_PROG_JLATEX,
[
    jlatex="jlatex platex"
    for jl in $jlatex
    do
        AC_CHECK_PROG(JLATEX, $jl, $jl)
        case "${JLATEX-}" in
            '')
                ;;
            *)
                break
                ;;
        esac
    done
    case "${JLATEX-}" in
        '')
            AC_MSG_WARN(Could not find LaTeX program)
            JLATEX=
            ;;
    esac
    AC_SUBST(JLATEX)
])


############################################################
#== Check for DVI->PS filter
#
# Set DVI->PS filter command to "DVI2JPS"
#
# usage: DC_PROG_DVIPS
#
AC_DEFUN(DCL_PROG_DVIPS,
[
    dvips="dvi2ps dvi2jps dvips"
    for dvi in $dvips
    do
        AC_CHECK_PROG(DVI2JPS, $dvi, $dvi)
        case "${DVI2JPS-}" in
            '')
                ;;
            dvips)
                DVI2JPS="dvips -f"
                break
                ;;
            *)
                break
                ;;
        esac
    done
    case "${DVI2JPS-}" in
        '')
            AC_MSG_WARN(Could not find DVI->PS program)
            DVI2JPS=
            ;;
    esac
    AC_SUBST(DVI2JPS)
])
