#2013/1/7 荻原 ジオポテンシャルを作成する
require 'gphys_const_v1.1'
require "numru/ggraph"
include NumRu
include NMath

t0 = Time.now
t2 = Process.times
#def make_gp

temp = NetCDF.open("../Temp.nc",mode="r")

tempval = GPhys::NetCDF_IO.open(temp,"Temp")
#地表面ジオポテンシャル定義
top = NetCDF.open("./sp_for_Mars_T021_MGS.nc",mode="r")
gp = NArray.sfloat(temp.var(temp.dims[0].name).get.shape[0], temp.var(temp.dims[1].name).get.shape[0], temp.var(temp.dims[2].name).get.shape[0])
gp[false,0] = Grav * top.var("topog").get
top.close

outfile = NetCDF.create("../Geopot.nc")
temp.each_dim do |dim|
  outfile.def_dim(dim.name, dim.length_ul0)
end

temp.each_var do |var|
  if var.name == 'Temp' then
    outfile.redef
    outvar = outfile.def_var('Geopot', var.vartype, var.dims)
    outvar.put_att('long_name', 'Geopotential')
    outvar.put_att('units', 'kg m2 s2')
    outfile.enddef
    axnames = var.dim_names.size-1
    cuttime = var.dim_names[-1]
    timevar = outfile.var(var.dim_names[-1])
    array1 = Array.new(axnames,0)
    array2 = Array.new(axnames,0)
    index = 0
    #ジオポテンシャルを静水圧の式から求める
    temp.var("time").get.each do |times|
      array1.fill(0,0..axnames-1).push(index)
      array2.fill(-1,0..axnames-1).push(index)
      gp[false, 1] = gp[false, 0] + Cp * ((temp.var("sigm").get[0]/temp.var("sig")[0])**(GasR/Cp) - 1.0) * tempval[false, 0, index].val
      for k in 1..temp.var("sig").get.shape[0]-1
        gp[false, k] = gp[false, k-1] \
          + Cp*((temp.var("sigm").get[k]/temp.var("sig")[k])**(GasR/Cp) - 1.0)* tempval[false, k, index].val \
          + Cp*(1.0-(temp.var("sigm").get[k]/temp.var("sig")[k])**(GasR/Cp))* tempval[false, k-1, index].val
      end

      outvar.put(gp, "start"=>array1, "end"=>array2)
      timevar.put( times, "index"=>[index])
      array1.delete_at(-1)
      array2.delete_at(-1)
      index = index + 1
    end
  else
    outfile.redef
    outvar = outfile.def_var(var.name, var.vartype, var.dims)
    for i in 0..var.att_names.size - 1
     outvar.put_att(var.att(var.att_names[i]).name, var.att(var.att_names[i]).get)
    end
    outfile.enddef
    if var.name == "time" then
    else
      outvar.put(var.get)
    end
  end
end
#-----グローバル属性の定義---------------------------------------------
outfile.redef
temp.each_att do |global|
  outfile.put_att(global.name, global.get)
end
outfile.enddef
temp.close
#----ファイルの書き出し-------------------------------------------
outfile.close
p 'end'
##----結合時間測定-------------------------------------------------
t1 = Time.now
t3 = Process.times
tmin = (t1 - t0)/60

puts "real time is #{t1 - t0} sec"
puts "real time is #{tmin} min"
puts "user time is #{t2.utime - t3.utime} sec"
puts "subuser time is #{t2.cutime - t3.cutime} sec"
puts "subprocess time is #{t2.cstime - t3.cstime} sec"
