!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module nmlfile_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: nmlfile.f90,v 1.1.1.1 2005/11/08 14:10:23 morikawa Exp $
!   * Tag Name: $Name:  $
!   * Change History: 
!
!== Overview
!
!This module support to input NAMELIST.
!
!NAMELIST 뤿λٱ⥸塼Ǥ롣
!ե뤫 NAMELIST 
!֥롼ѰդƤ롣
!NAMELIST ⥸塼뤪ӥץϡ
!§ŪƤΥ⥸塼Ƥ֡
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!ߡץɤ߹ǽ NAMELIST եϡ
!ᥤץ nmlfile_init(nml) ȸƤݤ nml Ȥ
!ե̾˸ꤵƤޤ¹ԥץǰȤƥե̾
!ꡢɸϤե̾ʤɤơ
!ƥѥ̵ NAMELIST եѹǤɤ⤷ʤ
!
                                                                 !=end

module nmlfile_mod
                                                                 !=begin
  !== Dependency
  use type_mod,   only : TOKEN, INTKIND, STRING
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: nmlfile_init, nmlfile_end    ! subroutines
  public :: nmlfile_open, nmlfile_close  ! subroutines
  public :: nmlfile                      ! functions
                                                                 !=end

  character(TOKEN) ,parameter:: file_default = 'nmlfile.nml'! default file
  character(TOKEN) ,save:: file_nml = file_default! NAMELIST file name
  integer(INTKIND) ,save:: nmlunit_save = -1  ! NAMELIST եֹ

  logical          ,save     :: nmlfile_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: nmlfile.f90,v 1.1.1.1 2005/11/08 14:10:23 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name:  $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !nmlfile_mod ⥸塼ν롼
  ! nml Ϥ줿ʸ NAMELIST ե̾ȤƳǼ
  !Υե ((<nmlfile_open>))  open ((<nmlfile_close>)) 
  !close 롣
  !
  !ᥤץˤơ¾Υ⥸塼ν롼
  !ƤФꤵƤꡢκݤ˰ nml Ϥ줿 NAMELIST
  !ե̾ʹ (Τˤ ((<nmlfile_end>)) ƤФޤ)
  !¾Υ⥸塼ǤѤȤʤ롣
  !
  !⤷⡢ᥤץˤƸƤФʤä
  !̵ǸƤФ줿硢ޤϰ˶Ϳϡ
  !ǥեȤ NAMELIST ե ((* nmlfile.nml *)) ɤ߹ޤ롣
  !
  subroutine nmlfile_init(nml)
  !
  !==== Dependency
  !
    use type_mod,  only: STRING, TOKEN, INTKIND
    use dc_trace,  only: BeginSub, EndSub, DbgMessage
    use dc_message,only: MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Input
    !
    character(*), intent(in), optional :: nml  ! NAMELIST file name
                                                                 !=end

!!$                                                                 !=begin
!!$    !
!!$    !==== NAMELIST
!!$    !
!!$    character(TOKEN)    :: file  = file_default ! NAMELIST file name
!!$
!!$    namelist /nmlfile_nml/ file
!!$                                                                 !=end
!!$
!!$    integer(INTKIND)            :: nmlstat
    character(STRING), parameter:: subname = "nmlfile_init"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (nmlfile_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       nmlfile_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   Reflect optional argument "nml"
    !----------------------------------------------------------------
    if (present(nml)) then
       if (trim(nml) /= '') then
          file_nml = nml
       endif
    endif

    !----------------------------------------------------------------
    !   read nmlfile_nml
    !----------------------------------------------------------------
!!$    read(5,nml=nmlfile_nml, iostat=nmlstat)
!!$    call DbgMessage('Stat of NAMELIST nmlfile_nml Input is <%d>', &
!!$         &           i=(/nmlstat/))
!!$    write(0,nml=nmlfile_nml)
!!$
!!$    ! If invalid value file is selected, use default.
!!$    if ( nmlstat /= 0 .or. trim(file) /= '' ) then
!!$       file_nml = file
!!$    endif

    !----------------------------------------------------------------
    !   Output Message
    !----------------------------------------------------------------
    call MessageNotify('M', subname, 'Set to Input NAMELIST file <%c>', &
         & c1=trim(file_nml) )

    call EndSub( subname )
  end subroutine nmlfile_init


                                                                 !=begin
  !=== Open NAMELIST file, and Return Device Number
  !
  !nmlfile_mod ˳ǼƤ NAMELIST եŬʡֹ
  !Open ֹ nmlunit Ȥ֤readable  .true. 
  !֤⤷ Open Ԥޤϥե뤬ɤ߼Բǽ
  !ˤ nmlunit  -1 readable  .false. ֤
  !
  !ʤˤΥץˤ NAMELIST ե뤬 Open Ƥ硢
  ! Open ƤֹưŪĤ롣
  !
  subroutine nmlfile_open(nmlunit, readable)
    !
    !==== Dependency
    use type_mod,  only: STRING, TOKEN, INTKIND
    use dc_trace,  only: BeginSub, EndSub, DbgMessage
    use dc_string, only: CPrintf
    use dc_message,only: MessageNotify
                                                                 !=end
    implicit none
                                                                 !=begin
    !==== Output
    !
    integer(INTKIND), intent(out):: nmlunit  ! Device Number for nml file
    logical         , intent(out):: readable ! Readable Flag
                                                                 !=end
    integer(INTKIND)            :: unit, ios, n
    logical                     :: x, p, e
    character(STRING)           :: r
    character(STRING), parameter:: subname = "nmlfile_open"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )

    nmlunit = -1
    readable = .false.

    if (.not. nmlfile_initialized) then
       call EndSub( subname, 'Call nmlfile_init before call %c.', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !    nmlunit_save ³ѤߤξˤϤ
    !----------------------------------------------------------------
    if (nmlunit_save >= 0) then
       inquire(unit=nmlunit_save, opened=p)
       if (p) then
          close(nmlunit_save)
          call DbgMessage('Close(%d)', i=(/nmlunit_save/))
       endif
       nmlunit_save = -1
    end if

    !----------------------------------------------------------------
    !   ŬʡֹõǼ
    !----------------------------------------------------------------
    unit = 98  ! "98" Ŭ礭
    do
       ! ֹ unit ³ǽǡ̤³ɤ
       inquire(unit=unit, exist=x, opened=p)
       if (x .and. .not. p) then
          nmlunit_save = unit
          exit
       endif
       ! ֹ unit ԲġޤѺѤξ 0 ʲ
       ! ʤޤ unit - 1 Ʒ֤
       unit = unit - 1
       if (unit < 0) exit
    enddo

    if (nmlunit_save < 0) then
       nmlunit = -1
       readable = .false.
       call MessageNotify('W', subname, &
            & 'Device Number is not available, so <%c> can not be opend.', &
            & c1=trim(file_nml) )
       call EndSub(subname, &
            & 'Device Number is not available, so <%c> can not be opend.', &
            & c1=trim(file_nml) )
       return
    endif

    !----------------------------------------------------------------
    !   ե file_nml Υơå
    !----------------------------------------------------------------
    ! ե뤬¸ߤơɤ߼ǽǤ뤳ȡ
    ! Open Ƥʤå롣
    inquire(file=trim(file_nml), exist=e, number=n, read=r)
    call DbgMessage('Status of inquire(%c) [exist=<%b>, ' // &
         & 'number=<%d>, read=<%c>].', &
         & l=(/e/), i=(/n/), c1=trim(file_nml), c2=trim(r) )

    ! ե뤬¸ߤʤ readable = .false. ֤
    if (.not. e) then
       nmlunit = -1
       readable = .false.
       call MessageNotify('W', subname, &
            & '<%c> is not found.', c1=trim(file_nml) )
       call EndSub(subname, &
            & '<%c> is not found.', c1=trim(file_nml) )
       return
    endif

    ! ɤ߼ǽǤ readable = .false. ֤
    if (r == 'NO') then
       nmlunit = -1
       readable = .false.
       call MessageNotify('W', subname, &
            & '<%c> is not readable.', c1=trim(file_nml) )
       call EndSub(subname, &
            & '<%c> is not readable.', c1=trim(file_nml) )
       return
    endif

    ! ե뤬 Open Ƥˤ1ٲ롣
    if ( n >= 0 ) then
       close(n)
       call DbgMessage('close(%d) [file_nml=<%c>].', &
            & i=(/n/), c1=trim(file_nml) )
    endif

    !----------------------------------------------------------------
    !   ե file_nml ֹ nmlunit_save ³
    !----------------------------------------------------------------
    ! ֹ unit  file_nml ³롣
    open(unit=nmlunit_save, file=trim(file_nml), status='OLD', &
         & iostat=ios, action='READ')

    ! Ϥ꤬ä readable = .false. ֤
    if (ios /= 0) then
       nmlunit = -1
       readable = .false.
       call MessageNotify('W', subname, &
            & '<%c> can not be opened successfully.', c1=trim(file_nml) )
       call EndSub(subname, &
            & '<%c> can not be opened successfully.', c1=trim(file_nml) )
       return
    endif


    ! ʤнλ
    nmlunit = nmlunit_save
    readable = .true.
    call EndSub( subname, 'Open <%c>. unit=<%d>. readable=<%b>.', &
         & c1=trim(file_nml), i=(/nmlunit_save/), l=(/readable/) )
    return
  end subroutine nmlfile_open


                                                                 !=begin
  !=== Close NAMELIST file
  !
  !nmlfile_open ǳե Close 롣
  !nmlfile_open ƤФƤʤˤϲ⤻˽λ롣
  !
  subroutine nmlfile_close()
    !==== Dependency
    use type_mod,  only: STRING, TOKEN, INTKIND
    use dc_trace,  only: BeginSub, EndSub, DbgMessage
    use dc_string, only: CPrintf
    use dc_message,only: MessageNotify
                                                                 !=end
    implicit none

    logical                     :: p
    character(STRING), parameter:: subname = "nmlfile_close"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )

    if (.not. nmlfile_initialized) then
       call EndSub( subname, 'Call nmlfile_init before call %c.', &
            &       c1=trim(subname) )
       return
    endif

    !----------------------------------------------------------------
    !   nmlunit_save ξ̤³Ȥߤʤƽλ
    !----------------------------------------------------------------
    if (nmlunit_save < 0) then
       call EndSub( subname, '<%c> was not opend.', c1=trim(file_nml) )
       return
    end if

    !----------------------------------------------------------------
    !   nmlunit_save ξ close nmlunit_save = -1 ˤ롣
    !----------------------------------------------------------------
    inquire(unit=nmlunit_save, opened=p)
    if (.not. p) then
       call EndSub( subname, '<%c> was not opend.', c1=trim(file_nml) )
    else
       close(unit=nmlunit_save)
       call EndSub( subname, '<%c> was closed.', c1=trim(file_nml) )
    end if

    nmlunit_save = -1
    return

  end subroutine nmlfile_close



                                                                 !=begin
  !
  !=== Return NAMELIST file name
  !
  character(TOKEN) function nmlfile() result(result)
  !==== Dependency
    use type_mod,  only: STRING, TOKEN, INTKIND
    use dc_trace,  only: BeginSub, EndSub, DbgMessage
    use dc_string, only: CPrintf
    use dc_message,only: MessageNotify
                                                                 !=end
    implicit none

    character(STRING), parameter:: subname = "nmlfile"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub( subname )

    result = file_nml

    if (.not. nmlfile_initialized) then
       call EndSub( subname, 'Call nmlfile_init before call %c.', &
            &       c1=trim(subname) )
       call MessageNotify('W', subname, &
            & 'nmlfile_init was not called. Now nmlfile=<%c>.', &
            & c1=trim(file_nml) )
       return
    else
       call EndSub( subname, 'nmlfile=<%c>.', c1=trim(file_nml) )
       return
    endif

    return
  end function nmlfile




                                                                 !=begin
  !=== Terminate module
  !
  !((<nmlfile_init>)) ꤵ줿ͤ˴
  !ɤ߹ NAMELIST ե̾ ((* nmlfile.nml *)) ᤹
  !
  subroutine nmlfile_end()
  !==== Dependency
    use type_mod,  only: STRING
    use dc_trace,  only: BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    character(STRING),  parameter:: subname = "nmlfile_end"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. nmlfile_initialized) then
       call EndSub( subname, 'nmlfile_init was not called', &
            &       c1=trim(subname) )
       return
    else
       nmlfile_initialized = .false.
    endif

    !----------------------------------------------------------------
    !   Reset to default value
    !----------------------------------------------------------------
    file_nml = file_default ! NAMELIST file name
    nmlunit_save = -1     ! NAMELIST եֹ

    call EndSub(subname)
  end subroutine nmlfile_end


end module nmlfile_mod
