# coding: utf-8
require "numru/ggraph"
include NumRu


vname = 'topog'
ncfn = 'sp_for_Mars_T021_MGS.nc'
#ncfn = 'sp_for_Mars_ZM_T021_MGS.nc'
#ncfn = 'sp_for_Mars_ZW_T021_MGS.nc'

gphys = GPhys::NetCDF_IO.open(ncfn, vname)


#< DCLのオープンと設定 >
DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2に画面分割, 'y'=yoko: 左上→右上→左下...
DCL.sgpset('lcntl', false)   # 制御文字を解釈しない
DCL.sgpset('lfull',true)     # 全画面表示
DCL.uzfact(0.75)             # 座標軸の文字列サイズを 0.75 倍
DCL.sgpset('lfprop',true)    # プロポーショナルフォントを使う

#< GGraph による 描画 >
GGraph.set_fig 'itr'=>10, 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[0,360,-90,90]
GGraph.set_map 'coast_world'=>false, 'grid'=>false
GGraph.set_axes('xlabelint'=>90)
GGraph.set_axes('ylabelint'=>30)


levels = [-8000,-7000,-6000,-5000,-4000,-3000,-2000,-1000,0,1000,2000,3000,4000,5000,6000,7000,8000]
patterns = [15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999,99999]

if vname == 'SurfTemp'
  levels = [210,220,230,240,250,260,270,280,290,300]
  patterns = [20999,30999,40999,45999,50999,55999,60999,70999,80999,85999,90999]
elsif vname == 'Rain'
  levels = [0,1e-5,2e-5,4e-5,8e-5,12e-5,16e-5,20e-5,24e-5,28e-5,32e-5]
  patterns = [1,20999,30999,35999,40999,50999,60999,65999,70999,75999,80999,85999]
elsif vname == 'SoilMoist'
  levels = [0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150]
  patterns = [15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'SurfSnow'
  levels = [0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150]
  patterns = [15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
#elsif vname == 'OLR'
elsif vname == 'OLRA'
  levels = [100,120,140,160,180,200,220,240,260,280,300]
  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,70999,80999,90999]
end


GGraph.tone( gphys, true, 'lev'=>levels, 'pat'=>patterns, 'map_axes'=>true, 'annotate'=>false )
GGraph.contour( gphys, false, 'lev'=>levels, 'annotate'=>false )
GGraph.color_bar

DCL.grcls

