!-------------------------------------------------
!     UUpack module
!-------------------------------------------------
module uupack
  use dcl_common
  contains
!-----------------------------------------------

    subroutine DclSetErrorBarLineType(type)  !G[o[̃C^Cvw肷D  
      integer,   intent(in) :: type

      call prcopn('DclSetErrorBarLineType')
      call uusebt(type)
      call prccls('DclSetErrorBarLineType')
    end subroutine

    function DclGetErrorBarLineType()   
      integer  :: DclGetErrorBarLineType

      call prcopn('DclGetErrorBarLineType')
      call uuqebt(DclGetErrorBarLineType)
      call prccls('DclGetErrorBarLineType')
    end function

    subroutine DclSetErrorBarLineIndex(index)  !G[o[̃CCfNXw肷D
      integer,   intent(in) :: index

      call prcopn('DclSetErrorBarLineIndex')
      call uusebi(index) 
      call prccls('DclSetErrorBarLineIndex')
    end subroutine

    function DclGetErrorBarLineIndex()
      integer  :: DclGetErrorBarLineIndex

      call prcopn('DclGetErrorBarLineIndex')
      call uuqebi(DclGetErrorBarLineIndex) 
      call prccls('DclGetErrorBarLineIndex')
    end function

    subroutine DclSetErrorBarWidth(width)  !G[o[̉w肷D
      real,      intent(in) :: width

      call prcopn('DclSetErrorBarWidth')
      call uusebs(width)
      call prccls('DclSetErrorBarWidth')
    end subroutine
    
    function DclGetErrorBarWidth()
      real     :: DclGetErrorBarWidth

      call prcopn('DclGetErrorBarWidth')
      call uuqebs(DclGetErrorBarWidth)
      call prccls('DclGetErrorBarWidth')
    end function
    
    subroutine DclSetBarWidth(width)  !_Ot̉Ђw肷D
      real,      intent(in) :: width

      call prcopn('DclSetBarWidth')
      call uusbrs(width)
      call prccls('DclSetBarWidth')
    end subroutine

    function DclGetBarWidth()
      real     :: DclGetBarWidth

      call prcopn('DclGetBarWidth')
      call uuqbrs(DclGetBarWidth)
      call prccls('DclGetBarWidth')
    end function

    subroutine DclSetAreaPattern(pattern1,pattern2)  ! ̈hg[p^[w肷D
      integer,   intent(in) :: pattern1, pattern2

      call prcopn('DclSetAreaPattern')
      call uusarp(pattern1,pattern2)
      call prccls('DclSetAreaPattern')
    end subroutine

    subroutine DclGetAreaPattern(pattern1,pattern2)
      integer,   intent(out) :: pattern1, pattern2

      call prcopn('DclGetAreaPattern')
      call uuqarp(pattern1,pattern2)
      call prccls('DclGetAreaPattern')
    end subroutine

    subroutine DclSetFrameType(type)  !g̑w肷D
      integer,   intent(in) :: type

      call prcopn('DclSetFrameType')
      call uusfrt(type)
      call prccls('DclSetFrameType')
    end subroutine

    function DclGetFrameType()
      integer  :: DclGetFrameType

      call prcopn('DclGetFrameType')
      call uuqfrt(DclGetFrameType)
      call prccls('DclGetFrameType')
    end function

    subroutine DclSetFrameIndex(index)  !g̃CCfNXw肷D
      integer,   intent(in) :: index

      call prcopn('DclSetFrameIndex')
      call uusfri(index)
      call prccls('DclSetFrameIndex')
    end subroutine

    function DclGetFrameIndex()
      integer :: DclGetFrameIndex

      call prcopn('DclGetFrameIndex')
      call uuqfri(DclGetFrameIndex)
      call prccls('DclGetFrameIndex')
    end function
    
end module
