    != Tetens (1930) Ѥ˰漾λ
    !
    != Evaluate saturation specific humidity with Tetens (1930)
    !
    ! ѱѥ᥿ꥼ絬϶ŷ륹Ǥλѻ
    ! ׻®٤ݤ뤿, ˰漾׻ʸؿȤƤޤ. 
    ! Υեץץå #include ޥɤˤä
    ! ƥեȤ߹ߤޤ. 
    !
    ! ξܺ٤ˤĤƤ saturate_t1930 򻲾ȤƤ. 
    ! 
    ! Calculation for saturation specific humidity is declared as 
    ! statement function because computation speed is kept when 
    ! cumulus parameterization or large scale condensation scheme are 
    ! performed. This file is build in each file by
    ! "#include" command of preprocessor. 
    ! 
    ! See "saturate_t1930" for detail of scheme. 
    !
    real(DP):: TempSF
                                ! $ T $ . . Temperature
    real(DP):: PressSF
                                ! $ p $ . . Air pressure
    real(DP):: QVapSatSF
                                ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: EpsVSF
                              ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor
    real(DP):: GasRWetSF
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ε. 
                              ! Gas constant of water vapor
    real(DP):: LatHeatSF
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    real(DP), parameter:: Es0SF = 611.0_DP
                              ! 0 ˰¾ [Pa]. 
                              ! Saturation water vapor pressure at 0 deg C [Pa]

    real(DP):: CalcQVapSatSF, CalcDQVapSatDTempSF


    CalcQVapSatSF( TempSF, PressSF ) = &
      & EpsVSF * Es0SF &
      &  * exp( LatHeatSF / GasRWetSF * ( 1./273. - 1./TempSF ) ) / PressSF

    CalcDQVapSatDTempSF( TempSF, QVapSatSF ) = &
      & LatHeatSF * QVapSatSF / ( GasRWetSF * TempSF**2 )
