*-----------------------------------------------------------------------
*     TMSLCL : MAIN SOLVER ROUTINE FOR CALCULATING STREAM LINES (RK4)
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2012 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMSLCL( DT, STEP, INI_X, INI_Y, NX, NY, X, Y, U, V, 
     &                   UNDEF, TRAJX, TRAJY, TRAJN, GRID_FLAG, THRES )
      IMPLICIT NONE
      REAL    DT                ! TIME INTERVAL TO CALCULATE STREAM LINE.
      INTEGER STEP              ! CALCULATING STEP NUMBER.
      REAL    INI_X             ! STARTING POINT (X) [UNIT:LENGTH]
      REAL    INI_Y             ! STARTING POINT (Y) [UNIT:LENGTH]
      INTEGER NX                ! GRID NUMBER OF X-DIRECTION
      INTEGER NY                ! GRID NUMBER OF Y-DIRECTION
      REAL    X(NX)             ! X-COORDINATE [UNIT:LENGTH]
      REAL    Y(NY)             ! Y-COORDINATE [UNIT:LENGTH]
      REAL    U(NX,NY)          ! VECTOR COMPONENT OF X-DIRECTION
      REAL    V(NX,NY)          ! VECTOR COMPONENT OF Y-DIRECTION
      REAL    UNDEF             ! UNDEFINED VALUE FOR (U,V)
      REAL    TRAJX(STEP)       ! POSITIONS OF STREAM LINE (X) [UNIT:LENGTH]
      REAL    TRAJY(STEP)       ! POSITIONS OF STREAM LINE (Y) [UNIT:LENGTH]
      INTEGER TRAJN             ! RANGE OF DRAWING STREAM LINE (STEP>=TRAJN)
      INTEGER GRID_FLAG(NX,NY)  ! NUMBER OF PASSING STREAM LINES IN EACH GRID.
      INTEGER THRES             ! NUMBER OF PERMITTING TO PASS STREAM LINE
                                ! IN EACH GRID (RECOMMENDED VALUE = 1).

*-- INTERNAL VALUES
      INTEGER I, J, M, N
      REAL    K1, K2, K3, K4
      REAL    L1, L2, L3, L4
      REAL    X1, Y1
      REAL    INTER_P(2)           ! POSITION IN INTERPOLATING POINT
      REAL    INTER_V(2)           ! VECTOR VALUE IN INTERPOLATING POINT
      LOGICAL CONTINU_FLAG(NX,NY)  ! FLAG VALUE TO PREVENT THE IDENTICAL 
                                   ! STREAM LINE FROM CONTINUOUS COUNTING
                                   ! IN EACH GRID.
                                   ! ƥåפƱʻˤΤ
                                   ! Ȥ뤳ȤɤΥե饰.

*-- FUNCTION
      INTEGER IBLKGE      ! DCL FUNCTION
      REAL    ITRP2D      ! INTERPOLATING FUNCTION
                          ! (DEFINED IN BOTTOM OF THIS FILE)

*-- INITIALIZING FLAG VALUE FOR DOUBLE COUNTER
      DO 10 J=1,NY
         DO 11 I=1,NX
            CONTINU_FLAG(I,J)=.FALSE.
 11      CONTINUE
 10   CONTINUE

*-- SETTING INITIAL POINT FOR CALCULATING STREAM LINE
      TRAJX(1)=INI_X
      TRAJY(1)=INI_Y

*-- STARTING TO CALCULATE STREAM LINES
      DO 100 I=1,STEP-1

*-- IF THERE IS NO THE INITIAL POINT IN THE ANY GRID POINTS,
*-- SEARCHING THE GRID POINT WHICH DOES NOT EXCEED THE INITIAL POINT.
         INTER_P=(/TRAJX(I), TRAJY(I)/)
         M=IBLKGE( X, NX, TRAJX(I) )
         N=IBLKGE( Y, NY, TRAJY(I) )

*-- WHEN A STREAM LINE COME AT BOUNDARIES OF DRAWING REGION OR
*-- A GRID POINT UNDEFINED FOR VECTOR VALUE,
*-- STOPPING TO CALCULATE THE STREAM LINE.
*-- AND, STANDARD OUTPUTTING ITS CONTENT.
*-- ®پ줬 UNDEF Ǥ, λǤʹߤΥǡˤ UNDEF 
*-- , UNDEF ƶϰ̲ᤷݤ.
*-- ޤ, INTERPO_SEARCH ˤƸΰ賰ξ⤽ʹ߷׻Բǽ
*-- Ǥݤ.
*-- ν RUNGE-KUTTA Ƿ׻ 4 η׻ˤ
*-- Ԥ.
*-- 椨, ʲ IF ʬ 4 ФƤ.
         IF(M.EQ.0.OR.N.EQ.0.OR.M.EQ.NX.OR.N.EQ.NY)THEN
            WRITE(*,*) "*********** WARNING ********"
            WRITE(*,*) "[TMSLCL] THERE IS NO PARCEL POINT", 
     &                 " IN THE CALCULATING REGION."
            WRITE(*,*) "EXIT!!"
            TRAJN=I
            GOTO 101
         END IF
 
         IF(U(M,N).EQ.UNDEF.OR.U(M,N+1).EQ.UNDEF.OR.
     &      U(M+1,N).EQ.UNDEF.OR.U(M+1,N+1).EQ.UNDEF.OR.
     &      V(M,N).EQ.UNDEF.OR.V(M,N+1).EQ.UNDEF.OR.
     &      V(M+1,N).EQ.UNDEF.OR.V(M+1,N+1).EQ.UNDEF)THEN
            WRITE(*,*) "*********** WARNING ********"
            WRITE(*,*) "[TMSLCL] PARCEL PASSED THE UNDEF POINT."
            WRITE(*,*) "EXIT!!"
            TRAJN=I
            GOTO 101
         END IF

*-- CALCULATING THE FIRST TENDENCY (K1,L1)
         INTER_V(1)=ITRP2D(X(M:M+1), Y(N:N+1), U(M:M+1,N:N+1), INTER_P)
         INTER_V(2)=ITRP2D(X(M:M+1), Y(N:N+1), V(M:M+1,N:N+1), INTER_P)

         K1=DT*INTER_V(1)
         L1=DT*INTER_V(2)
*-- Ūήΰ֤׻
         X1=TRAJX(I)+0.5*K1
         Y1=TRAJY(I)+0.5*L1
*-- Ǥ®پ
         INTER_P=(/X1, Y1/)
         M=IBLKGE( X, NX, X1 )
         N=IBLKGE( Y, NY, Y1 )

*-- ®پ줬 UNDEF Ǥ, λǤʹߤΥǡˤ UNDEF 
*-- , UNDEF ƶϰ̲ᤷݤ.
*-- ޤ, INTERPO_SEARCH ˤƸΰ賰ξ⤽ʹ߷׻Բǽ
*-- ǤݤΤ, UNDEF  UNDEF ʤХȴ.
         IF(M.EQ.0.OR.N.EQ.0.OR.M.EQ.NX.OR.N.EQ.NY)THEN
            WRITE(*,*) "*********** WARNING ********"
            WRITE(*,*) "[TMSLCL] THERE IS NO PARCEL POINT ",
     &                 "IN THE CALCULATING REGION."
            WRITE(*,*) "EXIT!!"
            TRAJN=I
            GOTO 101
         END IF
 
         IF(U(M,N).EQ.UNDEF.OR.U(M,N+1).EQ.UNDEF.OR.
     &      U(M+1,N).EQ.UNDEF.OR.U(M+1,N+1).EQ.UNDEF.OR.
     &      V(M,N).EQ.UNDEF.OR.V(M,N+1).EQ.UNDEF.OR.
     &      V(M+1,N).EQ.UNDEF.OR.V(M+1,N+1).EQ.UNDEF)THEN
            WRITE(*,*) "*********** WARNING ********"
            WRITE(*,*) "[TMSLCL] PARCEL PASSED THE UNDEF POINT."
            WRITE(*,*) "EXIT!!"
            TRAJN=I
            GOTO 101
         END IF
 
*-- CALCULATING THE SECOND TENDENCY (K2,L2)
         INTER_V(1)=ITRP2D(X(M:M+1), Y(N:N+1), U(M:M+1,N:N+1), INTER_P)
         INTER_V(2)=ITRP2D(X(M:M+1), Y(N:N+1), V(M:M+1,N:N+1), INTER_P)
 
         K2=DT*INTER_V(1)
         L2=DT*INTER_V(2)
         X1=TRAJX(I)+0.5*K2
         Y1=TRAJY(I)+0.5*L2

*-- Ǥ®پ
         INTER_P=(/X1, Y1/)
         M=IBLKGE( X, NX, X1 )
         N=IBLKGE( Y, NY, Y1 )

*-- ®پ줬 UNDEF Ǥ, λǤʹߤΥǡˤ UNDEF 
*-- , UNDEF ƶϰ̲ᤷݤ.
*-- ޤ, INTERPO_SEARCH ˤƸΰ賰ξ⤽ʹ߷׻Բǽ
*-- ǤݤΤ, UNDEF  UNDEF ʤХȴ.
         IF(M.EQ.0.OR.N.EQ.0.OR.M.EQ.NX.OR.N.EQ.NY)THEN
            WRITE(*,*) "*********** WARNING ********"
            WRITE(*,*) "[TMSLCL] THERE IS NO PARCEL POINT", 
     &                 " IN THE CALCULATING REGION."
            WRITE(*,*) "EXIT!!"
            TRAJN=I
            GOTO 101
         END IF
 
         IF(U(M,N).EQ.UNDEF.OR.U(M,N+1).EQ.UNDEF.OR.
     &      U(M+1,N).EQ.UNDEF.OR.U(M+1,N+1).EQ.UNDEF.OR.
     &      V(M,N).EQ.UNDEF.OR.V(M,N+1).EQ.UNDEF.OR.
     &      V(M+1,N).EQ.UNDEF.OR.V(M+1,N+1).EQ.UNDEF)THEN
            WRITE(*,*) "*********** WARNING ********"
            WRITE(*,*) "[TMSLCL] PARCEL PASSED THE UNDEF POINT."
            WRITE(*,*) "EXIT!!"
            TRAJN=I
            GOTO 101
         END IF
 
*-- CALCULATING THE THIRD TENDENCY (K2,L2)
         INTER_V(1)=ITRP2D(X(M:M+1), Y(N:N+1), U(M:M+1,N:N+1), INTER_P)
         INTER_V(2)=ITRP2D(X(M:M+1), Y(N:N+1), V(M:M+1,N:N+1), INTER_P)
 
         K3=DT*INTER_V(1)
         L3=DT*INTER_V(2)
 
         X1=TRAJX(I)+K3
         Y1=TRAJY(I)+L3

*-- Ǥ®پ
         INTER_P=(/X1, Y1/)
         M=IBLKGE( X, NX, X1 )
         N=IBLKGE( Y, NY, Y1 )

*-- ®پ줬 UNDEF Ǥ, λǤʹߤΥǡˤ UNDEF 
*-- , UNDEF ƶϰ̲ᤷݤ.
*-- ޤ, INTERPO_SEARCH ˤƸΰ賰ξ⤽ʹ߷׻Բǽ
*-- ǤݤΤ, UNDEF  UNDEF ʤХȴ.
         IF(M.EQ.0.OR.N.EQ.0.OR.M.EQ.NX.OR.N.EQ.NY)THEN
            WRITE(*,*) "*********** WARNING ********"
            WRITE(*,*) "[TMSLCL] THERE IS NO PARCEL POINT",
     &                 " IN THE CALCULATING REGION."
            WRITE(*,*) "EXIT!!"
            TRAJN=I
            GOTO 101
         END IF
 
         IF(U(M,N).EQ.UNDEF.OR.U(M,N+1).EQ.UNDEF.OR.
     &      U(M+1,N).EQ.UNDEF.OR.U(M+1,N+1).EQ.UNDEF.OR.
     &      V(M,N).EQ.UNDEF.OR.V(M,N+1).EQ.UNDEF.OR.
     &      V(M+1,N).EQ.UNDEF.OR.V(M+1,N+1).EQ.UNDEF)THEN
            WRITE(*,*) "*********** WARNING ********"
            WRITE(*,*) "[TMSLCL] PARCEL PASSED THE UNDEF POINT."
            WRITE(*,*) "EXIT!!"
            TRAJN=I
            GOTO 101
         END IF
 
*-- CALCULATING THE LAST TENDENCY (K2,L2)
         INTER_V(1)=ITRP2D(X(M:M+1), Y(N:N+1), U(M:M+1,N:N+1), INTER_P)
         INTER_V(2)=ITRP2D(X(M:M+1), Y(N:N+1), V(M:M+1,N:N+1), INTER_P)
 
         K4=DT*INTER_V(1)
         L4=DT*INTER_V(2)
         X1=TRAJX(I)+(1.0/6.0)*(K1+2.0*K2+2.0*K3+K4)
         Y1=TRAJY(I)+(1.0/6.0)*(L1+2.0*L2+2.0*L3+L4)

*-- CHECKING THAT THERE IS A CALCULATING STREAM LINE IN THE DRAWING REGION.
*-- ׻ TRAJ ΰ¸ߤƤ뤫ǧ
         IF(X1.LT.X(1).OR.X1.GT.X(NX).OR.Y1.LT.Y(1).OR.Y1.GT.Y(NY))THEN
            WRITE(*,*) "****** ERROR ******"
            WRITE(*,*) "[TMSLCL] THIS POINT DOES NOT EXIST ",
     &                 "IN THE REGION."
            WRITE(*,*) "STOP.!!"
            TRAJN=I
            GOTO 101
         END IF

*-- CHECKING WHERE A STREAM LINE PASS GRIDS.
*-- WHEN COUNTING NUMBER EXCEEDS "THRES", STOPPING TO CALCULATE A STREAM LINE.
*-- ʲ, ɤγʻ̲ᤷ򥫥Ȥ.
*-- ޤ, ̲ THRES ۤƤ, GOTO 101 ǽλ.
         IF((X1-X(M)).GE.(X(M+1)-X1))THEN  ! M+1 ̲
            IF((Y1-Y(N)).GE.(Y(N+1)-Y1))THEN  ! N+1 ̲
               IF(CONTINU_FLAG(M+1,N+1).EQV..FALSE.)THEN
                  GRID_FLAG(M+1,N+1)=GRID_FLAG(M+1,N+1)+1
                  CONTINU_FLAG=.FALSE.
                  CONTINU_FLAG(M+1,N+1)=.TRUE.
                  IF(GRID_FLAG(M+1,N+1).GT.THRES)THEN
                     TRAJN=I
                     GOTO 101
                  END IF
               END IF
            ELSE  ! N ̲
               IF(CONTINU_FLAG(M+1,N).EQV..FALSE.)THEN
                  GRID_FLAG(M+1,N)=GRID_FLAG(M+1,N)+1
                  CONTINU_FLAG=.FALSE.
                  CONTINU_FLAG(M+1,N)=.TRUE.
                  IF(GRID_FLAG(M+1,N).GT.THRES)THEN
                     TRAJN=I
                     GOTO 101
                  END IF
               END IF
            END IF
         ELSE  ! M ̲
            IF((Y1-Y(N)).GE.(Y(N+1)-Y1))THEN  ! N+1 ̲
               IF(CONTINU_FLAG(M,N+1).EQV..FALSE.)THEN
                  GRID_FLAG(M,N+1)=GRID_FLAG(M,N+1)+1
                  CONTINU_FLAG=.FALSE.
                  CONTINU_FLAG(M,N+1)=.TRUE.
                  IF(GRID_FLAG(M,N+1).GT.THRES)THEN
                     TRAJN=I
                     GOTO 101
                  END IF
               END IF
            ELSE  ! N ̲
               IF(CONTINU_FLAG(M,N).EQV..FALSE.)THEN
                  GRID_FLAG(M,N)=GRID_FLAG(M,N)+1
                  CONTINU_FLAG=.FALSE.
                  CONTINU_FLAG(M,N)=.TRUE.
                  IF(GRID_FLAG(M,N).GT.THRES)THEN
                     TRAJN=I
                     GOTO 101
                  END IF
               END IF
            END IF
         END IF
 
         TRAJX(I+1)=X1
         TRAJY(I+1)=Y1
         TRAJN=I+1
 
 100  CONTINUE

 101  TRAJN=TRAJN

      END SUBROUTINE TMSLCL

*---------------------------------
* PRIVATE ROUTINE (INTERPOLATING FUNCTION)
*---------------------------------

      REAL FUNCTION ITRP2D( X, Y, Z, P )
      IMPLICIT NONE
      REAL X(2)
      REAL Y(2)
      REAL Z(2,2)
      REAL P(2)
      REAL VALX(2)
      REAL V
    
      ! Y(1) Ǥ X Ǥ
      VALX(1)=Z(1,1)+(P(1)-X(1))*(Z(2,1)-Z(1,1))/(X(2)-X(1))
    
      ! Y(2) Ǥ X Ǥ
      VALX(2)=Z(1,2)+(P(1)-X(1))*(Z(2,2)-Z(1,2))/(X(2)-X(1))
    
      ! X  Y Ǥ(줬)
      V=VALX(1)+(P(2)-Y(1))*(VALX(2)-VALX(1))/(Y(2)-Y(1))
    
      ITRP2D=V

      RETURN
      END FUNCTION ITRP2D
