# coding: utf-8
require "rubygems" unless defined?(Gem)

lib = File.expand_path('../lib', __FILE__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)
require 'numru/dcl/version'

#old# filelist = `git ls-files | egrep -v '^GenWrapper|^.git|^ToDo'`.split("\n")
#old# filelist.concat(Dir::glob('ext/**/*.c'))
#old# filelist.concat(Dir::glob('lib/**/*.rb'))

filelist = %w!ChangeLog Gemfile LICENSE.txt Rakefile ruby-dcl.gemspec!
filelist.concat( Dir::glob("ext/**/*.c\0ext/**/*.rb\0ext/**/*.default") )
filelist.concat( Dir::glob('lib/**/*.rb') )
filelist.concat( Dir::glob("demo/**/*.rb\0demo/**/*.dat") )
filelist.uniq!

Gem::Specification.new do |spec|
  spec.name          = "ruby-dcl"
  spec.version       = NumRu::DCL::VERSION
  spec.authors     = ["T. Horinouchi", "K. Kuroi", "K. Goto"\
    ,"S. Nishizawa", "T. Koshiro",'GFD Dennou Club']
  spec.email       = ["eriko@gfd-dennou.org"]

  spec.summary     = %q{one-to-one interface to the DCL graphic library}
  spec.description = %q{RubyDCL is a ruby interface to the scientific graphic library DCL. It supports all the subroutines and functions in DCL on a one-to-one basis. }
  spec.homepage    = 'http://www.gfd-dennou.org/arch/ruby/products/ruby-dcl/' 
  spec.licenses       = ["BSD-2-Clause"]

  spec.files         = filelist
  spec.test_files    = spec.files.grep(%r{^demo/})
  spec.require_paths = ["ext","lib"]
  spec.extensions << "ext/numru/extconf.rb"

  spec.required_ruby_version = Gem::Requirement.new(">= 1.6")
  spec.add_runtime_dependency(%q<narray>, [">= 0.5.5"])
  spec.add_runtime_dependency(%q<narray_miss>, [">= 0"])
  spec.add_development_dependency(%q<gtk2>, [">= 0"])
end
