/* SPDX-License-Identifier: MIT */
/* SPDX-FileCopyrightText: (c) Copyright 2024 Andrew Bower <andrew@bower.uk> */

#ifndef _JOIN_H
#define _JOIN_H

int for_all_children(int dir, void (*fn)(void *context, pid_t p), void *context);

/* Save old signal mask for re-use by child and block all signals
 * in the parent so we can get them delivered by signalfd. */
bool sig_proxy_mask(sigset_t *newmask, sigset_t *oldmask);

bool join(pid_t child, sigset_t *mask, sigset_t *oldmask, int *retcode,
          bool subreaper, int proc_self, const char *tool);
bool pico_init(int proc_self);

#endif
