(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     78841,       1732]
NotebookOptionsPosition[     76481,       1662]
NotebookOutlinePosition[     76817,       1677]
CellTagsIndexPosition[     76774,       1674]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"phi0", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.0", "-", "y"}], ")"}], "/", "4"}], ",", "0", ",", "0"}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"phi1", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"0", ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.0", "+", "x"}], ")"}], "/", "4"}], ",", "0"}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"phi2", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1.0", "+", "y"}], ")"}]}], "/", "4"}], ",", "0", ",", "0"}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi3", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1.0", "-", "x"}], ")"}]}], "/", "4"}], ",", "0"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"h", "=", "0.5"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi0", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{"2.0", "*", 
   RowBox[{"phi0", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "h"}], ")"}], "*", "x"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "h"}], ")"}], "*", "y"}], "-", "1"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi1", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{"2.0", "*", 
   RowBox[{"phi1", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "h"}], ")"}], "*", "x"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "h"}], ")"}], "*", "y"}], "-", "1"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi2", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"-", "2.0"}], "*", 
   RowBox[{"phi2", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "h"}], ")"}], "*", "x"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "h"}], ")"}], "*", "y"}], "-", "1"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi3", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"-", "2.0"}], "*", 
   RowBox[{"phi3", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "h"}], ")"}], "*", "x"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "h"}], ")"}], "*", "y"}], "-", "1"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi3Elem2", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"-", "2.0"}], "*", 
   RowBox[{"phi3", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "x"}], "-", "3"}], ",", 
     RowBox[{
      RowBox[{"2", "*", "y"}], "-", "3"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Phi1Elem2", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{"2.0", "*", 
    RowBox[{"phi1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", "x"}], "-", "3"}], ",", 
      RowBox[{
       RowBox[{"2", "*", "y"}], "-", "3"}]}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CPhi0", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{"Curl", "[", 
   RowBox[{
    RowBox[{"Phi0", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"Cartesian", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CPhi1", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{"Curl", "[", 
   RowBox[{
    RowBox[{"Phi1", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"Cartesian", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CPhi2", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{"Curl", "[", 
   RowBox[{
    RowBox[{"Phi2", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"Cartesian", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CPhi3", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{"Curl", "[", 
    RowBox[{
     RowBox[{"Phi3", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"Cartesian", "[", 
      RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"m00", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Phi0", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ".", 
      RowBox[{"Phi0", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"m01", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Phi0", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ".", 
      RowBox[{"Phi1", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"m02", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Phi0", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ".", 
      RowBox[{"Phi2", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m03", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Phi0", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ".", 
       RowBox[{"Phi3", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"c00", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"CPhi0", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ".", 
      RowBox[{"CPhi0", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"c01", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"CPhi0", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ".", 
      RowBox[{"CPhi1", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"c02", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"CPhi0", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ".", 
      RowBox[{"CPhi2", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c03", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"CPhi0", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ".", 
       RowBox[{"CPhi3", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"m00", "+", "c00"}], "\[IndentingNewLine]", 
 RowBox[{"m01", "+", "c01"}], "\[IndentingNewLine]", 
 RowBox[{"m02", "+", "c02"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m03", "+", "c03"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2.0", "+", "y", "-", 
      RowBox[{"y", "*", "y"}]}], ",", 
     RowBox[{"2.0", "+", "x", "-", 
      RowBox[{"x", "*", "x"}]}], ",", "0.0"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ".", 
    RowBox[{"Phi0", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ".", 
    RowBox[{"Phi1", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ".", 
    RowBox[{"Phi2", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 

 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ".", 
     RowBox[{"Phi3", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Phi1", "[", 
  RowBox[{"x", ",", "y"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi3Elem2", "[", 
   RowBox[{"x", ",", "y"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ".", 
     RowBox[{"Phi1", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}], "+", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ".", 
     RowBox[{"Phi3Elem2", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1", ",", "2"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ".", 
    RowBox[{"Phi1Elem2", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.643735004035206*^9, 3.643735100971998*^9}, {
  3.64373517974929*^9, 3.6437353090179777`*^9}, {3.643735513738768*^9, 
  3.643735554626421*^9}, {3.643735657013382*^9, 3.643735759477264*^9}, {
  3.643735805859866*^9, 3.643735826362994*^9}, {3.643736175901635*^9, 
  3.6437361813241777`*^9}, {3.643736228829709*^9, 3.643736340340763*^9}, {
  3.643736466862606*^9, 3.643736468150981*^9}, {3.643736517167761*^9, 
  3.643736578431526*^9}, {3.643737699672576*^9, 3.643737824254915*^9}, {
  3.643737927843972*^9, 3.643737949396764*^9}, {3.6437381120470657`*^9, 
  3.6437381683955393`*^9}, {3.6437382014217987`*^9, 3.6437382250167847`*^9}, {
  3.64373825914896*^9, 3.6437382603065033`*^9}, {3.643740476470154*^9, 
  3.643740487190254*^9}, {3.643973697690001*^9, 3.643973752422352*^9}, {
  3.643974957811768*^9, 3.643975007392321*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1.`", "\[VeryThinSpace]", "-", "y"}], ")"}]}], ",", "0", ",", 
   "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.6439750527292023`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1.`", "\[VeryThinSpace]", "+", "x"}], ")"}]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.6439750527311687`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1.`"}], "-", "y"}], ")"}]}], ",", "0", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.6439750527326803`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1.`"}], "+", "x"}], ")"}]}], ",", "0"}], "}"}]], "Output",\

 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052733739*^9}],

Cell[BoxData["0.5`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052734611*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5`", " ", 
    RowBox[{"(", 
     RowBox[{"2.`", "\[VeryThinSpace]", "-", 
      RowBox[{"4.`", " ", "y"}]}], ")"}]}], ",", "0.`", ",", "0.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052735613*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"0.5`", " ", 
    RowBox[{"(", 
     RowBox[{"0.`", "\[VeryThinSpace]", "+", 
      RowBox[{"4.`", " ", "x"}]}], ")"}]}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052736616*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.5`"}], " ", 
    RowBox[{"(", 
     RowBox[{"0.`", "\[VeryThinSpace]", "-", 
      RowBox[{"4.`", " ", "y"}]}], ")"}]}], ",", "0.`", ",", "0.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052737669*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2.`"}], "+", 
      RowBox[{"4.`", " ", "x"}]}], ")"}]}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052738818*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "4.`"}], "+", 
      RowBox[{"2", " ", "x"}]}], ")"}]}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052739971*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"0.5`", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2.`"}], "+", 
      RowBox[{"2", " ", "x"}]}], ")"}]}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052741171*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0.`", ",", "2.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052742298*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "0", ",", "2.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.6439750527432413`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0.`", ",", 
   RowBox[{"-", "2.`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.6439750527441683`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "0", ",", 
   RowBox[{"-", "2.`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052745063*^9}],

Cell[BoxData[
 RowBox[{"-", "0.33333333333333326`"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052771882*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052772859*^9}],

Cell[BoxData["0.33333333333333326`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.6439750528303747`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.6439750528584414`*^9}],

Cell[BoxData[
 RowBox[{"-", "4.`"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052859537*^9}],

Cell[BoxData[
 RowBox[{"-", "4.`"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052860621*^9}],

Cell[BoxData["4.`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052861679*^9}],

Cell[BoxData["4.`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052862661*^9}],

Cell[BoxData[
 RowBox[{"-", "4.333333333333333`"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052863418*^9}],

Cell[BoxData[
 RowBox[{"-", "4.`"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052864222*^9}],

Cell[BoxData["4.333333333333333`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052865024*^9}],

Cell[BoxData["4.`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.64397505286581*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.`", "\[VeryThinSpace]", "+", "y", "-", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{"2.`", "\[VeryThinSpace]", "+", "x", "-", 
    SuperscriptBox["x", "2"]}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052866921*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052944821*^9}],

Cell[BoxData["2.1666666666666665`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975052972179*^9}],

Cell[BoxData["2.1666666666666665`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975053049485*^9}],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975053076291*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"0.5`", " ", 
    RowBox[{"(", 
     RowBox[{"0.`", "\[VeryThinSpace]", "+", 
      RowBox[{"4.`", " ", "x"}]}], ")"}]}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975053077381*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "4.`"}], "+", 
      RowBox[{"2", " ", "x"}]}], ")"}]}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975053078546*^9}],

Cell[BoxData["2.9166666666666665`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.643975053080261*^9}],

Cell[BoxData["0.41666666666666696`"], "Output",
 CellChangeTimes->{
  3.64373525454708*^9, {3.643735519271637*^9, 3.643735556471983*^9}, {
   3.643735732026248*^9, 3.643735761560405*^9}, {3.643735812881288*^9, 
   3.6437358213638887`*^9}, 3.6437361432303534`*^9, {3.643736183111349*^9, 
   3.643736254624012*^9}, 3.643736296397778*^9, 3.643736343665443*^9, 
   3.643736476270245*^9, 3.6437365810179043`*^9, {3.643737791088601*^9, 
   3.6437378260104733`*^9}, 3.643738170208865*^9, 3.643738228157975*^9, 
   3.643738264613823*^9, 3.643740489063665*^9, 3.643973755595357*^9, 
   3.643974310296111*^9, 3.6439750530817413`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"y", "-", "1.0"}], ")"}]}], "*", "y"}], ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1.0"}], ")"}]}], "*", "x"}], ",", "0"}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Curl", "[", 
     RowBox[{
      RowBox[{"Curl", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{"Cartesian", "[", 
         RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}], ",", 
      RowBox[{"Cartesian", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}], "+", 
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"u", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.64397381152118*^9, 3.643973961780635*^9}, {
  3.643974059090995*^9, 3.643974081435218*^9}, {3.643974214868369*^9, 
  3.643974234019081*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1.`", "\[VeryThinSpace]", "-", "y"}], ")"}], " ", "y"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1.`", "\[VeryThinSpace]", "-", "x"}], ")"}], " ", "x"}], ",", 
   "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64397393128964*^9, 3.643973963945958*^9, {3.643974064744858*^9, 
   3.643974083332655*^9}, 3.643974217733042*^9, 3.6439742513291283`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.`", "\[VeryThinSpace]", "-", "y"}], ")"}], " ", "y"}]}], ",", 
   RowBox[{"2", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.`", "\[VeryThinSpace]", "-", "x"}], ")"}], " ", "x"}]}], ",",
    "0"}], "}"}]], "Input",
 CellChangeTimes->{3.643975835831394*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.`", "\[VeryThinSpace]", "-", "y"}], ")"}], " ", "y"}]}], ",", 
   RowBox[{"2", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.`", "\[VeryThinSpace]", "-", "x"}], ")"}], " ", "x"}]}], ",",
    "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.64397393128964*^9, 3.643973963945958*^9, {3.643974064744858*^9, 
   3.643974083332655*^9}, 3.643974217733042*^9, 3.64397425133145*^9, 
   3.6439758359410686`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.6439750615262527`*^9, 3.643975062266279*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"uhat", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"2.16667", "*", 
     RowBox[{"Phi0", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "+", 
    RowBox[{"2.16667", "*", 
     RowBox[{"Phi1", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "+", 
    RowBox[{"2.16667", "*", 
     RowBox[{"Phi2", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "+", 
    RowBox[{"2.16667", "*", 
     RowBox[{"Phi3", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"TwoDVec", "[", "g_", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"g", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"VectorPlot", "[", 
    RowBox[{
     RowBox[{"TwoDVec", "[", 
      RowBox[{"uhat", "[", 
       RowBox[{"x", ",", "y"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1.08334"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4.0"}], "*", "y"}], ")"}]}], "+", 
    RowBox[{"1.08334", "*", 
     RowBox[{"(", 
      RowBox[{"2.0", "-", 
       RowBox[{"4.0", "*", "y"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.64397508257308*^9, 3.643975140076599*^9}, {
  3.643975171021131*^9, 3.643975278434026*^9}, {3.643975319991152*^9, 
  3.643975483833897*^9}, {3.6439755549655037`*^9, 3.643975933925128*^9}, {
  3.643975987197144*^9, 3.643975989980507*^9}, {3.643976021989273*^9, 
  3.643976026724988*^9}, {3.6439761443578873`*^9, 3.643976149508109*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", "\[VeryThinSpace]", "-", 
    RowBox[{"1.083335`", " ", 
     RowBox[{"(", 
      RowBox[{"0.`", "\[VeryThinSpace]", "-", 
       RowBox[{"4.`", " ", "y"}]}], ")"}]}], "+", 
    RowBox[{"1.083335`", " ", 
     RowBox[{"(", 
      RowBox[{"2.`", "\[VeryThinSpace]", "-", 
       RowBox[{"4.`", " ", "y"}]}], ")"}]}]}], ",", 
   RowBox[{"0.`", "\[VeryThinSpace]", "-", 
    RowBox[{"1.083335`", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2.`"}], "+", 
       RowBox[{"4.`", " ", "x"}]}], ")"}]}], "+", 
    RowBox[{"1.083335`", " ", 
     RowBox[{"(", 
      RowBox[{"0.`", "\[VeryThinSpace]", "+", 
       RowBox[{"4.`", " ", "x"}]}], ")"}]}]}], ",", "0.`"}], "}"}]], "Output",\

 CellChangeTimes->{3.643976151228759*^9}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyF3HnQVWUdwPELIm6kllZIattNcyMUXHJUJB3kQNnojA2IIaKV2wUSU3TU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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mXngTVX3xu89e59QCiHzTIY0GKIUMqUyhaIXjYQyJ2k0ZMicprdoLg2S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         "]], 
        Polygon3DBox[CompressedData["
1:eJw1mnfgz1UfxT/33o+RJMloyMompfGkTVMKpaVCGS0aGkakjJKUStEwCiEq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         "]], 
        Polygon3DBox[CompressedData["
1:eJwt13ncjWUaAODvO+dIliRLRpFBGEKTtawjW9nK3tgauylLZclkKWPf96US
GWtTqpnQrpCtLJUlJcy0aFcRJaHr/r3+uH/Pc1/P/Z7zvd/7Pssp2WNQm4Gp
rKysPSKHeDOdlVULfJvJyrpG/1pRWBSKPqtpbLr2sLyb/sPZWVkTXddYfoXI
K642XsXYJO1Z+QU1lUV1dQf4y+wmbRvWieWS/yLOyyuJimKwazewkupulTdT
d1b/RVZK25A1Z7/qF1Z7o/Zu1oddpuYl8WfWmv2VXS6/SuQXRdVXNzZVW1T+
B1Esk9z3TO2v8ouuu1HUcO1BXprfph3OHhSL5XnU5RZF9Ksam6w9Kf+f8ctF
TtGNrWd/NN5AfrvP+0X/SpYvvtt4NfkU7Tl5Dv3q6uqqO6r/Fqun/cF4Kf3S
l55JPJvirLaxWdqj8l764107w7Ut5B+KLmwUG88ayt8TrdiguA9WXf6+uIPd
x4azGvJKPrMfW8SWslbsXdGSDWTDWDV5GXWt2Rg2mdVke0ULNoANZVXl1dUN
Z2vYc6wb2yfasMFsJKsl3y/asiFsFKst3yOas/5sCKsi3yb+wrqzv7Oy8t2i
Gbs33h92Uzxv31uBdYr3IP4P8h38VtZT3l9dBXlZ3pFNZBPEanlF0ZctlC9R
11Ld5aw4a8nasZ/0c7HrtK1Ye3ZavwLrrp3NHmW3ufZP7O54x9hC1pSVZ3+L
Z8gWsSasHLsr5g+byeqxy9i1rHnMBTFGfoPowxbI54vn5blFCXaHvINrz+jn
ZMW0LVhbdko/ByuibcruYN/rp1ghbSPWgn2nn2FXa5uwVuyE/tv+nkba3mwg
qyjfKRqyXmwAu0FezbUPstXsWdY11gd2PWvHurBz+nlYaW1b1pn9pv+B2k7a
EWwsaxDzWd197Em2hnVkN7JBbGk8M9aefSx6sLFsGmsmPyjas2HsYVZXfrNr
H2bPsRdZH/aR6MpGx3vAGsVape5+tow9xe5iBUWBmIfGahibFvcl7tR/RN0k
dTcbPyQ6s5FsHLtVXlldLLpL2CrWgR0T98SaxOay1rGOiHvjs9k81ka+SzRh
fdl9rLL8HdGY9WGDWCV5Vd8xjK1ia1kXVpONZs+yDawXq8FGsbVsPevNtor6
7Me4p5jj4oBox4aqG62ujvy3eC9ZDVaPHdE/wnpqx7HprHnsCz6nDGvPurLz
+vlYWW2HWCPZhVgTWTltR3Y3u6hfhQ3VrmQr4jnJ06Iwayxvqe5b/ZKxxkZk
kvVyrvbf8mz9UuoqqPtQvwS7TpQwXlc+R9tCLNbfpW6/un8a/0pMYU+zF9j9
8q/FVPYMW8cekM8TR+XpWO/Zi8br+7xJ2pfYG2ygmjnxXsovXtpn1xv/mf3M
ysVeE3twKpnn12hrszrigLxArEWsi7ynurTrFohP5HlEbvZKrDXssPy83CVZ
61g9nYmxb/KNbECspWwR28H2stGsNhvH1sX9itfkDcVM9oZ8u7ph6s5EyMvG
ns72Gr9N3XztVraLjYh1mC1k27OTs8UodjtbwLax3WxkrMNsBtvItrGh7Bvx
GHuVbWFj5HXUjWfr429j97L54v/yXBHsZeN11U3QbmCvs/5qGrDp7HW2lQ2O
vYNNY6+xt9gQtkh8Jr9S5GWvGT/NvpeXiHtm21LJnlI+lazDsR4fkxcUlVhX
ea/4/7vulPhCXiSuj7NVrHvqVmoPsI/ZFDVXxVrOOrMeLJVO3sF4Fx+P903c
lUme0dhUMg9iPuTJkexbHVLJmSTOJmcunUGO6ecQl4lNrL1Ype6g/IjPnZpO
5taQVLJ3xB6S8nnreFFWS95Q3clY+9XNSSXvRbwfV6tryubF+UT+jrqHYi9n
y9k+9hGbxO5kT7J32SE2gc2KdVZ+Lt5l8YLxQuoqa7vx3jFHDCwUn8qviHtl
r6aSc1hTbb/Y98WpuH+xOvYM+VF101zXmi1j77EP2cQ447ClbC/7gI1nHdka
diieI5se5w+2gu1nh9nkOPewJ9jumJNsLPtJnJBfJ4rH36OmlViibo/8oLpx
6eT/N5dtYZtjTZA3FrPZJvlOdcNjT2Wz2JtsB3uQLY/3SF5AFGPvxPOP75YX
iu9lu9gadi5qRBm2n/2LnZTnF9eyt9kr6eRs/nkmObvGGXZJzLl4/qKwureM
PxHrnTwrvkezhX3CBmhnxPvC2slXitPxTsT/ge2OeZZOztdfZpI9MvbKxbGm
qrmgpqDYHHMvnZx9v8gk5/I4ny8V36rLxGeq2xrnB/Zr3IO4nu2LtSGdnLmP
Z5JzdJynz4ucrKa6+uqO6W+OtUN7InNp3RfFRbHYBzLJ2GztlnSyH3yfSfaR
2E/irB1n7pKZZD+cF2dw0UD/ft/xD99R3vgt7BH2PHuJ9WUb08m54KtM8tsp
fkOtEmfVXCNKq3s/1tZ08pvq6zhn6RcRtfTHsP+oe1ldv1jnRH82nc1nbeWb
0sn5/7tMcj9xX8vEj2ryxfeo22k82/iVsS+xJuy4/qfqHoh9ki1mneRPxWSM
vZSV1z0U7wl7SPs4W866yy/Ee5NKfqfF77XdPv8zNjj+R/In1HWWPytysQqs
KvsklZxZe6eSM3actc/JH1X3uf5VMdfVvR77LkvFfGc3sI/0H2PH5QXj/tjG
VDIHv8tOfmvFb64tmeS35G+X5mTMze2xBrEfYl0XRV27I9ZVltZezyqyw/rP
sdzxd7Jq7FP9/7IC2qqsNvs6nk28r3E+YbXYV/H8WX7tTewW9mWsmfH+a6vF
fs6+SSWbc77Ym1lj6ef6F9VdEfsXa8Q+SyX/57yp5BwQ54ERrjvORrDF8hXq
esjXigwrE8+DfRxzL/YQ7XL2DLtH/ng6maMxV5+O9yb2JzEy5nvsKcZ6yueK
I/Ls2D/YBuO/Ay3T4QI=
         "]]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0rsvpFEYwOGPcRsMK6Jd0RAFpSgoN4pViSjoiGK3WIlsQakQOh1/AS0R
+k3o3MfMuM2ystkIu2Tjfg3PSRS/eU7mO5nznsxX0zvQ8S0niqJR3SqsL/Vb
87lR9IE/WM0NNvKQrTxnO5/Zw9JYFCX01bqew2zmONs4xS7OsJ+L/M5l/ucJ
77Wta/3TioFSXGWaa8xwnTthJu5yk3vcYlL74Xd4wBSzTPMnMzzkDo+4y1+c
dY9TPuhYN+GOmjBbkiNc4iAX2MdpdnKSnzjGJg6xjrX6Yh1nNx+d8Zl/2cIs
G8K9+JEX9v3hncp1FfaqyoxlrGSCFSwNe1jCBItZwng4j0UsYL4KrWMsCP9x
+I6vytNLeKYnGSOa83H2/j68Acy/Svc=
       "]]}, {
      Line3DBox[{690, 1004, 473, 689, 1113, 912, 691, 1114, 913, 692, 1115, 
       914, 693, 1116, 915, 694, 1117, 916, 695, 1118, 1010, 1217, 696, 1119, 
       917, 697, 1120, 918, 698, 1121, 919, 699, 1122, 920, 700, 1123, 921, 
       701, 1124, 922, 702, 1322, 1005, 923, 1006}], 
      Line3DBox[{704, 1011, 1218, 703, 488, 705, 1125, 924, 706, 1126, 925, 
       707, 1127, 926, 708, 1128, 927, 709, 1129, 1012, 1219, 710, 1013, 1220,
        711, 1130, 928, 712, 1131, 929, 713, 1132, 930, 714, 1133, 931, 715, 
       1134, 932, 716, 1135, 933, 717}], 
      Line3DBox[{719, 1014, 1221, 718, 1015, 1222, 720, 504, 721, 1136, 934, 
       722, 1137, 935, 723, 1138, 936, 724, 1139, 1016, 1223, 725, 1017, 1224,
        726, 1018, 1225, 727, 1140, 937, 728, 1141, 938, 729, 1142, 939, 730, 
       1143, 940, 731, 1144, 941, 732}], 
      Line3DBox[{734, 1019, 1226, 733, 1020, 1227, 735, 1021, 1228, 736, 520, 
       737, 1145, 942, 738, 1146, 943, 739, 1147, 1022, 1229, 740, 1023, 1230,
        741, 1024, 1231, 742, 1025, 1232, 743, 1148, 944, 744, 1149, 945, 745,
        1150, 946, 746, 1151, 947, 747}], 
      Line3DBox[{749, 1026, 1233, 748, 1027, 1234, 750, 1028, 1235, 751, 1029,
        1236, 752, 536, 753, 1152, 948, 754, 1153, 1030, 1237, 755, 1031, 
       1238, 756, 1032, 1239, 757, 1033, 1240, 758, 1034, 1241, 759, 1154, 
       949, 760, 1155, 950, 761, 1156, 951, 762}], 
      Line3DBox[{764, 1035, 1242, 763, 1036, 1243, 765, 1037, 1244, 766, 1038,
        1245, 767, 1039, 1246, 768, 552, 769, 1157, 1040, 1247, 770, 1041, 
       1248, 771, 1042, 1249, 772, 1043, 1250, 773, 1044, 1251, 774, 1045, 
       1252, 775, 1158, 952, 776, 1159, 953, 777}], 
      Line3DBox[{781, 1160, 954, 779, 1161, 955, 783, 1162, 956, 785, 1163, 
       957, 787, 1164, 958, 789, 1165, 959, 791, 1166, 569, 793, 1167, 960, 
       795, 1168, 961, 797, 1169, 962, 799, 1170, 963, 801, 1171, 964, 803, 
       1172, 965, 805, 1174, 967, 807}], 
      Line3DBox[{806, 966, 1173, 804, 1265, 1057, 802, 1264, 1056, 800, 1263, 
       1055, 798, 1262, 1054, 796, 1261, 1053, 794, 1260, 1052, 792, 1259, 
       568, 790, 1258, 1051, 788, 1257, 1050, 786, 1256, 1049, 784, 1255, 
       1048, 782, 1254, 1047, 778, 1253, 1046, 780}], 
      Line3DBox[{809, 1058, 1266, 808, 1175, 968, 810, 1176, 969, 811, 1177, 
       970, 812, 1178, 971, 813, 1179, 972, 814, 1180, 1059, 1267, 815, 585, 
       816, 1181, 973, 817, 1182, 974, 818, 1183, 975, 819, 1184, 976, 820, 
       1185, 977, 821, 1186, 978, 822}], 
      Line3DBox[{824, 1060, 1268, 823, 1061, 1269, 825, 1187, 979, 826, 1188, 
       980, 827, 1189, 981, 828, 1190, 982, 829, 1191, 1062, 1270, 830, 1063, 
       1271, 831, 601, 832, 1192, 983, 833, 1193, 984, 834, 1194, 985, 835, 
       1195, 986, 836, 1196, 987, 837}], 
      Line3DBox[{839, 1064, 1272, 838, 1065, 1273, 840, 1066, 1274, 841, 1197,
        988, 842, 1198, 989, 843, 1199, 990, 844, 1200, 1067, 1275, 845, 1068,
        1276, 846, 1069, 1277, 847, 617, 848, 1201, 991, 849, 1202, 992, 850, 
       1203, 993, 851, 1204, 994, 852}], 
      Line3DBox[{854, 1070, 1278, 853, 1071, 1279, 855, 1072, 1280, 856, 1073,
        1281, 857, 1205, 995, 858, 1206, 996, 859, 1207, 1074, 1282, 860, 
       1075, 1283, 861, 1076, 1284, 862, 1077, 1285, 863, 633, 864, 1208, 997,
        865, 1209, 998, 866, 1210, 999, 867}], 
      Line3DBox[{869, 1078, 1286, 868, 1079, 1287, 870, 1080, 1288, 871, 1081,
        1289, 872, 1082, 1290, 873, 1211, 1000, 874, 1212, 1083, 1291, 875, 
       1084, 1292, 876, 1085, 1293, 877, 1086, 1294, 878, 1087, 1295, 879, 
       649, 880, 1213, 1001, 881, 1214, 1002, 882}], 
      Line3DBox[{884, 1088, 1296, 883, 1089, 1297, 885, 1090, 1298, 886, 1091,
        1299, 887, 1092, 1300, 888, 1093, 1301, 889, 1215, 1094, 1302, 890, 
       1095, 1303, 891, 1096, 1304, 892, 1097, 1305, 893, 1098, 1306, 894, 
       1099, 1307, 895, 665, 896, 1216, 1003, 897}], 
      Line3DBox[{911, 1009, 685, 910, 1321, 1111, 909, 1320, 1110, 908, 1319, 
       1109, 907, 1318, 1108, 906, 1317, 1107, 905, 1316, 1106, 904, 1315, 
       1314, 1105, 903, 1313, 1104, 902, 1312, 1103, 901, 1311, 1102, 900, 
       1310, 1101, 899, 1309, 1100, 898, 1112, 1308, 1007, 1008}]}, {
      Line3DBox[{251, 474, 1113, 252, 488, 280, 1222, 503, 295, 1227, 518, 
       310, 1234, 533, 325, 1243, 548, 340, 1254, 563, 1161, 355, 578, 1175, 
       370, 1269, 593, 385, 1273, 608, 400, 1279, 623, 415, 1287, 638, 430, 
       1297, 653, 445, 1309, 668, 460}], 
      Line3DBox[{253, 475, 1114, 254, 489, 1125, 281, 504, 296, 1228, 519, 
       311, 1235, 534, 326, 1244, 549, 341, 1255, 564, 1162, 356, 579, 1176, 
       371, 594, 1187, 386, 1274, 609, 401, 1280, 624, 416, 1288, 639, 431, 
       1298, 654, 446, 1310, 669, 461}], 
      Line3DBox[{255, 476, 1115, 256, 490, 1126, 282, 505, 1136, 297, 520, 
       312, 1236, 535, 327, 1245, 550, 342, 1256, 565, 1163, 357, 580, 1177, 
       372, 595, 1188, 387, 610, 1197, 402, 1281, 625, 417, 1289, 640, 432, 
       1299, 655, 447, 1311, 670, 462}], 
      Line3DBox[{257, 477, 1116, 258, 491, 1127, 283, 506, 1137, 298, 521, 
       1145, 313, 536, 328, 1246, 551, 343, 1257, 566, 1164, 358, 581, 1178, 
       373, 596, 1189, 388, 611, 1198, 403, 626, 1205, 418, 1290, 641, 433, 
       1300, 656, 448, 1312, 671, 463}], 
      Line3DBox[{259, 478, 1117, 260, 492, 1128, 284, 507, 1138, 299, 522, 
       1146, 314, 537, 1152, 329, 552, 344, 1258, 567, 1165, 359, 582, 1179, 
       374, 597, 1190, 389, 612, 1199, 404, 627, 1206, 419, 642, 1211, 434, 
       1301, 657, 449, 1313, 672, 464}], 
      Line3DBox[{261, 479, 1118, 263, 493, 1129, 285, 508, 1139, 300, 523, 
       1147, 315, 538, 1153, 330, 553, 1157, 345, 568, 1166, 360, 583, 1180, 
       375, 598, 1191, 390, 613, 1200, 405, 628, 1207, 420, 643, 1212, 435, 
       658, 1215, 450, 1314, 673, 465}], 
      Line3DBox[{265, 481, 1119, 266, 1220, 495, 287, 1224, 510, 302, 1230, 
       525, 317, 1238, 540, 332, 1248, 555, 347, 1260, 570, 1167, 362, 585, 
       377, 1271, 600, 392, 1276, 615, 407, 1283, 630, 422, 1292, 645, 437, 
       1303, 660, 452, 1316, 675, 467}], 
      Line3DBox[{267, 482, 1120, 268, 496, 1130, 288, 1225, 511, 303, 1231, 
       526, 318, 1239, 541, 333, 1249, 556, 348, 1261, 571, 1168, 363, 586, 
       1181, 378, 601, 393, 1277, 616, 408, 1284, 631, 423, 1293, 646, 438, 
       1304, 661, 453, 1317, 676, 468}], 
      Line3DBox[{269, 483, 1121, 270, 497, 1131, 289, 512, 1140, 304, 1232, 
       527, 319, 1240, 542, 334, 1250, 557, 349, 1262, 572, 1169, 364, 587, 
       1182, 379, 602, 1192, 394, 617, 409, 1285, 632, 424, 1294, 647, 439, 
       1305, 662, 454, 1318, 677, 469}], 
      Line3DBox[{271, 484, 1122, 272, 498, 1132, 290, 513, 1141, 305, 528, 
       1148, 320, 1241, 543, 335, 1251, 558, 350, 1263, 573, 1170, 365, 588, 
       1183, 380, 603, 1193, 395, 618, 1201, 410, 633, 425, 1295, 648, 440, 
       1306, 663, 455, 1319, 678, 470}], 
      Line3DBox[{273, 485, 1123, 274, 499, 1133, 291, 514, 1142, 306, 529, 
       1149, 321, 544, 1154, 336, 1252, 559, 351, 1264, 574, 1171, 366, 589, 
       1184, 381, 604, 1194, 396, 619, 1202, 411, 634, 1208, 426, 649, 441, 
       1307, 664, 456, 1320, 679, 471}], 
      Line3DBox[{275, 486, 1124, 276, 500, 1134, 292, 515, 1143, 307, 530, 
       1150, 322, 545, 1155, 337, 560, 1158, 352, 1265, 575, 1172, 367, 590, 
       1185, 382, 605, 1195, 397, 620, 1203, 412, 635, 1209, 427, 650, 1213, 
       442, 665, 457, 1321, 680, 472}], 
      Line3DBox[{277, 682, 1322, 683, 278, 501, 1135, 293, 516, 1144, 308, 
       531, 1151, 323, 546, 1156, 338, 561, 1159, 353, 576, 1173, 1174, 368, 
       591, 1186, 383, 606, 1196, 398, 621, 1204, 413, 636, 1210, 428, 651, 
       1214, 443, 666, 1216, 458, 685, 686, 687}], 
      Line3DBox[{459, 667, 684, 1308, 444, 652, 1296, 429, 637, 1286, 414, 
       622, 1278, 399, 607, 1272, 384, 592, 1268, 369, 577, 1266, 354, 1160, 
       562, 1253, 339, 547, 1242, 324, 532, 1233, 309, 517, 1226, 294, 502, 
       1221, 279, 487, 1218, 250, 473, 681, 688}], 
      Line3DBox[{466, 674, 1315, 451, 659, 1302, 436, 644, 1291, 421, 629, 
       1282, 406, 614, 1275, 391, 599, 1270, 376, 584, 1267, 361, 569, 1259, 
       346, 554, 1247, 331, 539, 1237, 316, 524, 1229, 301, 509, 1223, 286, 
       494, 1219, 264, 480, 1217, 262}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJztyLEJgDAARcGP4iBpXcIdHEGwzgqO7AjpAgoZIHCveXDlque9JNm3ZE3v
+f49OOecc84555xzzjnnnHM+9F+cc84555xzzjnnnHPOOeecc84555xzzjnn
nHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPOOeec85m9AQ4ZF/0=

    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360., 292.98919193769655`},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 1}, {0, 1}, {2.1666799999999995`, 2.1666800000000004`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{-0.8309203508036379, -2.9108349735326144`, 1.512154465482848},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{3.643976151259705*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.643976017038704*^9, 3.643976017052915*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ContourPlot", "::", "optx"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Unknown option \[NoBreak]\\!\\(plotlegends\\)\[NoBreak] in \
\[NoBreak]\\!\\(ContourPlot[\\(\\(\\(\\(\\(\\(\\(\\(-1.08334`\\)\\)\\\\ \
\\(\\((\\(\\(-4.`\\)\\)\\\\ y)\\)\\)\\)\\) + \\(\\(1.08334`\\\\ \
\\(\\((\\(\\(2.` \[VeryThinSpace]\\)\\) - \\(\\(4.`\\\\ \
y\\)\\))\\)\\)\\)\\)\\)\\), \\(\\({x, 0, 1}\\)\\), \\(\\({y, 0, 1}\\)\\), \\(\
\\(plotlegends \[Rule] Automatic\\)\\)\\)\\)]\\)\\n\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/optx\\\", \
ButtonNote -> \\\"ContourPlot::optx\\\"]\\)\"\>"}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.643975992381736*^9, 3.643976011668797*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.64397594281619*^9, 3.643975942833065*^9}}]
},
WindowSize->{740, 867},
WindowMargins->{{147, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Linux x86 (64-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 12519, 401, 924, "Input"],
Cell[13101, 425, 783, 16, 54, "Output"],
Cell[13887, 443, 782, 16, 54, "Output"],
Cell[14672, 461, 784, 17, 54, "Output"],
Cell[15459, 480, 781, 17, 54, "Output"],
Cell[16243, 499, 605, 9, 30, "Output"],
Cell[16851, 510, 793, 16, 30, "Output"],
Cell[17647, 528, 790, 15, 30, "Output"],
Cell[18440, 545, 813, 17, 30, "Output"],
Cell[19256, 564, 812, 17, 30, "Output"],
Cell[20071, 583, 810, 17, 30, "Output"],
Cell[20884, 602, 790, 16, 30, "Output"],
Cell[21677, 620, 661, 11, 30, "Output"],
Cell[22341, 633, 663, 11, 30, "Output"],
Cell[23007, 646, 682, 12, 30, "Output"],
Cell[23692, 660, 680, 12, 30, "Output"],
Cell[24375, 674, 638, 10, 30, "Output"],
Cell[25016, 686, 602, 9, 30, "Output"],
Cell[25621, 697, 623, 9, 30, "Output"],
Cell[26247, 708, 604, 9, 30, "Output"],
Cell[26854, 719, 621, 10, 30, "Output"],
Cell[27478, 731, 621, 10, 30, "Output"],
Cell[28102, 743, 604, 9, 30, "Output"],
Cell[28709, 754, 604, 9, 30, "Output"],
Cell[29316, 765, 636, 10, 30, "Output"],
Cell[29955, 777, 621, 10, 30, "Output"],
Cell[30579, 789, 619, 9, 30, "Output"],
Cell[31201, 800, 603, 9, 30, "Output"],
Cell[31807, 811, 823, 15, 34, "Output"],
Cell[32633, 828, 602, 9, 30, "Output"],
Cell[33238, 839, 620, 9, 30, "Output"],
Cell[33861, 850, 620, 9, 30, "Output"],
Cell[34484, 861, 604, 9, 30, "Output"],
Cell[35091, 872, 790, 15, 30, "Output"],
Cell[35884, 889, 810, 17, 30, "Output"],
Cell[36697, 908, 620, 9, 30, "Output"],
Cell[37320, 919, 623, 9, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37980, 933, 1334, 41, 126, InheritFromParent],
Cell[39317, 976, 443, 12, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39797, 993, 376, 12, 30, InheritFromParent],
Cell[40176, 1007, 522, 15, 30, "Output"]
}, Open  ]],
Cell[40713, 1025, 94, 1, 30, "Input"],
Cell[CellGroupData[{
Cell[40832, 1030, 2017, 59, 107, "Input"],
Cell[42852, 1091, 796, 23, 50, "Output"],
Cell[43651, 1116, 31726, 516, 308, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75414, 1637, 92, 1, 30, InheritFromParent],
Cell[75509, 1640, 862, 16, 80, "Message"]
}, Open  ]],
Cell[76386, 1659, 91, 1, 30, InheritFromParent]
}
]
*)

(* End of internal cache information *)
