#include "filedb/filedb_device.h"

#include <tango/tango.h>

void Tango::DServer::class_factory()
{
    add_class(FileDb::FileDbDeviceClass::init("FileDbDevice"));
}

int main(int argc, char *argv[])
{
    Tango::Util::_UseDb = false;
    FileDb::DatabaseDeviceClass::db_name.append(argv[1]);

    try
    {
        Tango::Util *tg = Tango::Util::init(argc, argv);
        tg->server_init();
        for(auto *device_class : *tg->get_class_list())
        {
            auto *db_class = dynamic_cast<FileDb::DatabaseDeviceClass *>(device_class);
            if(db_class)
            {
                db_class->initialise_database();
            }
        }

        TANGO_LOG << "Ready to accept request" << std::endl;
        tg->get_orb()->run();
    }
    catch(const Tango::DevFailed &ex)
    {
        Tango::Except::print_exception(ex);
    }

    return 0;
}
