#pragma once
#include "Core/Graphics/Image.h"
#include "Core/Graphics/ImageSet.h"
#include "Core/Io/Stream.h"
#include "Core/Io/Url.h"

namespace graphics {

	/**
	 * Class for properties for a particular encoder/decoder.
	 */
	class FormatOptions : public Object {
		STORM_ABSTRACT_CLASS;
	public:
		// Create.
		STORM_CTOR FormatOptions() {}

		// Load an image. Set properties in here to reflect the data in the loaded file.
		virtual Image *STORM_FN load(IStream *from) ABSTRACT;
		virtual ImageSet *STORM_FN loadSet(IStream *from);

		// Convenience to load from an Url directly.
		Image *STORM_FN load(Url *from);
		ImageSet *STORM_FN loadSet(Url *from);

		// Save an image. Called from 'saveImage'.
		virtual void STORM_FN save(Image *image, OStream *to) ABSTRACT;

		// Convenience to save to an Url directly.
		void STORM_FN save(Image *image, Url *to);
	};

	// Helper to check a header of a stream. Used from the different format loading code.
	Bool checkHeader(IStream *file, const char *header, Bool zeroTerm);

}
