# -*- coding: utf-8 -*- #
# frozen_string_literal: true

require 'open-uri'

SQF_SYNTAX_URI = "https://raw.githubusercontent.com/intercept/intercept/master/src/client/headers/client/sqf_assignments.hpp"
SQF_KEYWORDS_FILE = "./lib/rouge/lexers/sqf/keywords.rb"

namespace :builtins do
  task :sqf do
    generator = Rouge::Tasks::Builtins::SQF.new

    input    = URI.open(SQF_SYNTAX_URI) { |f| f.read }
    keywords = generator.extract_keywords(input)

    output = generator.render_output(keywords)

    File.write(SQF_KEYWORDS_FILE, output)
  end
end

module Rouge
  module Tasks
    module Builtins
      class SQF
        def extract_keywords(input)
          input.scrub.scan /(?<=\(").+?(?=")/
        end

        def render_output(keywords, &b)
          return enum_for(:render_output, keywords).to_a.join("\n") unless b

          yield "# -*- coding: utf-8 -*- #"
          yield "# frozen_string_literal: true"
          yield ""
          yield "# DO NOT EDIT"
          yield "# This file is automatically generated by `rake builtins:sqf`."
          yield "# See tasks/builtins/sqf.rake for more info."
          yield ""
          yield "module Rouge"
          yield "  module Lexers"
          yield "    class SQF"
          yield "      def self.commands"
          yield "        @commands ||= Set.new #{keywords.inspect}"
          yield "      end"
          yield "    end"
          yield "  end"
          yield "end"
        end
      end
    end
  end
end
