#! /bin/sh

# Test update of a record.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
DB_FILE=${DB_DIR}/test1.db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}.db

cp ${DB_FILE} ${TMP_DB_FILE}

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/bibliography/5"
export HTTP_HOST=${TMP_TEST_DB}.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=boundary"
export REMOTE_USER=writer

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

echo "==="

tools/scripts/multipart-form-data boundary <<EOF |
column:bibliography:0.year=1505
db=${TMP_TEST_DB}.db
Update=Update
EOF
${INPUT_SCRIPT} \
| sed "s/${TMP_TEST_DB}/tmp${BASENAME}pid/"

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

rm -f ${TMP_DB_FILE}
