% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{vec_assert}
\alias{vec_assert}
\alias{vec_is}
\title{Assert an argument has known prototype and/or size}
\usage{
vec_assert(x, ptype = NULL, size = NULL, arg = as_label(substitute(x)))

vec_is(x, ptype = NULL, size = NULL)
}
\arguments{
\item{x}{A vector argument to check.}

\item{ptype}{Prototype to compare against. If the prototype has a
class, its \code{\link[=vec_ptype]{vec_ptype()}} is compared to that of \code{x} with
\code{identical()}. Otherwise, its \code{\link[=typeof]{typeof()}} is compared to that of
\code{x} with \code{==}.}

\item{size}{Size to compare against}

\item{arg}{Name of argument being checked. This is used in error
messages. The label of the expression passed as \code{x} is taken as
default.}
}
\value{
\code{vec_is()} returns \code{TRUE} or \code{FALSE}. \code{vec_assert()} either
throws a typed error (see section on error types) or returns \code{x},
invisibly.
}
\description{
\itemize{
\item \code{vec_is()} is a predicate that checks if its input is a vector that
conforms to a prototype and/or a size.
\item \code{vec_assert()} throws an error when the input is not a vector or
doesn't conform.
}
}
\section{Scalars and vectors}{


Informally, a vector is a collection that makes sense to use as
column in a data frame. An object is a vector if one of the
following conditions hold:
\itemize{
\item A \code{\link[=vec_proxy]{vec_proxy()}} method is implemented for the class of the
object.
\item The \link[=typeof]{base type} of the object is atomic: \code{"logical"},
\code{"integer"}, \code{"double"}, \code{"complex"}, \code{"character"}, \code{"raw"}
\item The object is a \link{data.frame}.
\item The base type is \code{"list"}, and one of:
\itemize{
\item The object is a bare \code{"list"} without a \code{"class"} attribute.
\item The object explicitly inherits from \code{"list"}. That is, the
\code{"class"} attribute contains \code{"list"} and \code{inherits(x, "list")} is \code{TRUE}.
}
}

Otherwise an object is treated as scalar and cannot be used as a
vector. In particular:
\itemize{
\item \code{NULL} is not a vector.
\item S3 lists like \code{lm} objects are treated as scalars by default.
\item Objects of type \link{expression} are not treated as vectors.
\item Support for S4 vectors is currently limited to objects that
inherit from an atomic type.
\item Subclasses of \link{data.frame} that \emph{append} their class to the \code{"class"}
attribute are not treated as vectors. If you inherit from an S3 class,
always prepend your class to the \code{"class"} attribute for correct dispatch.
}
}

\section{Error types}{


\code{vec_is()} never throws.
\code{vec_assert()} throws the following errors:
\itemize{
\item If the input is not a vector, an error of class
\code{"vctrs_error_scalar_type"} is raised.
\item If the prototype doesn't match, an error of class
\code{"vctrs_error_assert_ptype"} is raised.
\item If the size doesn't match, an error of class
\code{"vctrs_error_assert_size"} is raised.
}

Both errors inherit from \code{"vctrs_error_assert"}.
}

