% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_rank.R
\name{node_rank}
\alias{node_rank}
\alias{node_rank_hclust}
\alias{node_rank_anneal}
\alias{node_rank_branch_bound}
\alias{node_rank_traveller}
\alias{node_rank_two}
\alias{node_rank_mds}
\alias{node_rank_leafsort}
\alias{node_rank_visual}
\alias{node_rank_spectral}
\alias{node_rank_spin_out}
\alias{node_rank_spin_in}
\alias{node_rank_quadratic}
\alias{node_rank_genetic}
\alias{node_rank_dendser}
\title{Calculate node ranking}
\usage{
node_rank_hclust(
  method = "average",
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_anneal(
  cool = 0.5,
  tmin = 1e-04,
  swap_to_inversion = 0.5,
  step_multiplier = 100,
  reps = 1,
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_branch_bound(
  weighted_gradient = FALSE,
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_traveller(
  method = "two_opt",
  ...,
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_two(
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_mds(
  method = "cmdscale",
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_leafsort(
  method = "average",
  type = "OLO",
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_visual(
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_spectral(
  normalized = FALSE,
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_spin_out(
  step = 25,
  nstart = 10,
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_spin_in(
  step = 5,
  sigma = seq(20, 1, length.out = 10),
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_quadratic(
  criterion = "2SUM",
  reps = 1,
  step = 2 * graph_order(),
  step_multiplier = 1.1,
  temp_multiplier = 0.5,
  maxsteps = 50,
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_genetic(
  ...,
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)

node_rank_dendser(
  ...,
  dist = "shortest",
  mode = "out",
  weights = NULL,
  algorithm = "automatic"
)
}
\arguments{
\item{method}{The method to use. See \emph{Functions} section for reference}

\item{dist}{The algorithm to use for deriving a distance matrix from the
graph. One of
\itemize{
\item \code{"shortest"} (default): Use the shortest path between all nodes
\item \code{"euclidean"}: Calculate the L2 norm on the adjacency matrix of the graph
\item \code{"manhattan"}: Calculate the L1 norm on the adjacency matrix of the graph
\item \code{"maximum"}: Calculate the supremum norm on the adjacenecy matrix of the graph
\item \code{"canberra"}: Calculate a weighted manhattan distance on the adjacency matrix of the graph
\item \code{"binary"}: Calculate distance as the proportion of agreement between nodes based on the adjacency matrix of the graph
}

or a function that takes a \code{tbl_graph} and return a \code{dist} object with a size
matching the order of the graph.}

\item{mode}{Which edges should be included in the distance calculation. For
distance measures based on the adjacency matrix, \code{'out' } will use the matrix
as is, \code{'in'} will use the transpose, and \code{'all'} will take the mean of the
two. Defaults to \code{'out'}. Ignored for undirected graphs.}

\item{weights}{An edge variable to use as weight for the shortest path
calculation if \code{dist = 'shortest'}}

\item{algorithm}{The algorithm to use for the shortest path calculation if
\code{dist = 'shortest'}}

\item{cool}{cooling rate}

\item{tmin}{minimum temperature}

\item{swap_to_inversion}{Proportion of swaps in local neighborhood search}

\item{step_multiplier}{Multiplication factor for number of iterations per temperature}

\item{reps}{Number of repeats with random initialisation}

\item{weighted_gradient}{minimize the weighted gradient measure? Defaults to \code{FALSE}}

\item{...}{Arguments passed on to other algorithms. See \emph{Functions} section for reference}

\item{type}{The type of leaf reordering, either \code{'GW'} to use the "GW" method or \code{'OLO'} to use the "OLO" method (both in \code{seriation})}

\item{normalized}{Should the normalized laplacian of the similarity matrix be used?}

\item{step}{The number iterations to run per initialisation}

\item{nstart}{The number of random initialisations to perform}

\item{sigma}{The variance around the diagonal to use for the weight matrix. Either a single number or a decreasing sequence.}

\item{criterion}{The criterion to minimize. Either "LS" (Linear Seriation Problem), "2SUM" (2-Sum Problem), "BAR" (Banded Anti-Robinson form), or "Inertia" (Inertia criterion)}

\item{temp_multiplier}{Temperature multiplication factor between 0 and 1}

\item{maxsteps}{The upper bound of iterations}
}
\value{
An integer vector giving the position of each node in the ranking
}
\description{
This set of functions tries to calculate a ranking of the nodes in a graph so
that nodes sharing certain topological traits are in proximity in the
resulting order. These functions are of great value when composing matrix
layouts and arc diagrams but could concievably be used for other things as
well.
}
\section{Functions}{
\itemize{
\item \code{node_rank_hclust}: Use hierarchical clustering to rank nodes (see \code{\link[stats:hclust]{stats::hclust()}} for allowed methods)

\item \code{node_rank_anneal}: Use simulated annealing based on the "ARSA" method in \code{seriation}

\item \code{node_rank_branch_bound}: Use branch and bounds strategy to minimize the gradient measure (only feasable for small graphs). Will use "BBURCG" or "BBWRCG" in \code{seriation} dependent on the \code{weighted_gradient} argument

\item \code{node_rank_traveller}: Minimize hamiltonian path length using a travelling salesperson solver. See the the \code{solve_TSP} function in \code{TSP} for an overview of possible arguments

\item \code{node_rank_two}: Use Rank-two ellipse seriation to rank the nodes. Uses "R2E" method in \code{seriation}

\item \code{node_rank_mds}: Rank by multidimensional scaling onto one dimension. \code{method = 'cmdscale'} will use the classic scaling from \code{stats}, \code{method = 'isoMDS'} will use \code{isoMDS} from \code{MASS}, and \code{method = 'sammon'} will use \code{sammon} from \code{MASS}

\item \code{node_rank_leafsort}: Minimize hamiltonian path length by reordering leafs in a hierarchical clustering. Method refers to the clustering algorithm (either 'average', 'single', 'complete', or 'ward')

\item \code{node_rank_visual}: Use Prim's algorithm to find a minimum spanning tree giving the rank. Uses the "VAT" method in \code{seriation}

\item \code{node_rank_spectral}: Minimize the 2-sum problem using a relaxation approach. Uses the "Spectral" or "Spectral_norm" methods in \code{seriation} depending on the value of the \code{norm} argument

\item \code{node_rank_spin_out}: Sorts points into neighborhoods by pushing large distances away from the diagonal. Uses the "SPIN_STS" method in \code{seriation}

\item \code{node_rank_spin_in}: Sorts points into neighborhoods by concentrating low distances around the diagonal. Uses the "SPIN_NH" method in \code{seriation}

\item \code{node_rank_quadratic}: Use quadratic assignment problem formulations to minimize criterions using simulated annealing. Uses the "QAP_LS", "QAP_2SUM", "QAP_BAR", or "QAP_Inertia" methods from \code{seriation} dependant on the \code{criterion} argument

\item \code{node_rank_genetic}: Optimizes different criteria based on a genetic algorithm. Uses the "GA" method from \code{seriation}. See \code{register_GA} for an overview of relevant arguments

\item \code{node_rank_dendser}: Optimizes different criteria based on heuristic dendrogram seriation. Uses the "DendSer" method from \code{seriation}. See \code{register_DendSer} for an overview of relevant arguments
}}

\examples{
graph <- create_notable('zachary') \%>\%
  mutate(rank = node_rank_hclust())

}
