% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_stats.R
\name{anova_stats}
\alias{anova_stats}
\title{Effect size statistics for anova}
\usage{
anova_stats(model, digits = 3)
}
\arguments{
\item{model}{A fitted anova-model of class \code{aov} or \code{anova}. Other
models are coerced to \code{\link[stats]{anova}}.}

\item{digits}{Amount of digits for returned values.}
}
\value{
A data frame with all statistics is returned (excluding confidence intervals).
}
\description{
Returns the (partial) eta-squared, (partial) omega-squared,
  epsilon-squared statistic or Cohen's F for all terms in an anovas.
  \code{anova_stats()} returns a tidy summary, including all these statistics
  and power for each term.
}
\examples{
# load sample data
data(efc)

# fit linear model
fit <- aov(
  c12hour ~ as.factor(e42dep) + as.factor(c172code) + c160age,
  data = efc
)
\dontrun{
anova_stats(car::Anova(fit, type = 2))
}
}
\references{
Levine TR, Hullett CR (2002): Eta Squared, Partial Eta Squared, and Misreporting of Effect Size in Communication Research.
  \cr \cr
  Tippey K, Longnecker MT (2016): An Ad Hoc Method for Computing Pseudo-Effect Size for Mixed Model.
}
