% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/molecules.R
\name{Molecules-methods}
\alias{Molecules-methods}
\alias{Features.Molecules}
\alias{GetTissueCoordinates.Molecules}
\alias{subset.Molecules}
\alias{show,Molecules-method}
\title{\code{Molecules} Methods}
\usage{
\method{Features}{Molecules}(x, ...)

\method{GetTissueCoordinates}{Molecules}(object, features = NULL, ...)

\method{subset}{Molecules}(x, features = NULL, ...)

\S4method{show}{Molecules}(object)
}
\arguments{
\item{x, object}{A \code{\link{Molecules}} object}

\item{...}{Arguments passed to other methods}

\item{features}{A vector of molecule names to keep; if \code{NULL}, defaults
to all molecules}
}
\value{
\code{Features}: A vector of spatially-resolved molecule names;
if no molecular information present, returns \code{NULL}

\code{GetTissueCoordinates}: A data frame with three columns:
\itemize{
 \item \dQuote{\code{x}}: the x-coordinate of a molecule
 \item \dQuote{\code{y}}: the y-coordinate of a molecule
 \item \dQuote{\code{molecule}}: the molecule name
}

\code{subset}: \code{x} subsetted to the features specified
by \code{features}

\code{show}: Invisibly returns \code{NULL}
}
\description{
Methods for \code{\link{Molecules}} objects
}
\details{
\code{Features}: Get spatially-resolved molecule names

\code{GetTissueCoordinates}: Get spatially-resolved
molecule coordinates

\code{subset}: Subset a \code{Molecules} object to certain molecules

\code{show}: Display an object summary to stdout
}
\seealso{
\code{\link{Molecules-class}}

Segmentation layer classes:
\code{\link{Centroids-class}},
\code{\link{Centroids-methods}},
\code{\link{Molecules-class}},
\code{\link{Segmentation-class}},
\code{\link{Segmentation-methods}}
}
\concept{segmentation}
