% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordParallel.r
\name{ordParallel}
\alias{ordParallel}
\title{Check Parallelism Assumption of Ordinal Semiparametric Models}
\usage{
ordParallel(
  fit,
  which,
  terms = onlydata,
  m,
  maxcuts = 75,
  lp = FALSE,
  onlydata = FALSE,
  scale = c("iqr", "none"),
  conf.int = 0.95,
  alpha = 0.15
)
}
\arguments{
\item{fit}{a fit object from \code{orm} with \verb{x=TRUE, y=TRUE} in effect}

\item{which}{specifies which columns of the design matrix are assessed.  By default, all columns are analyzed.}

\item{terms}{set to \code{TRUE} to collapse all components of each predictor into a single column weighted by the original regression coefficients but scaled according to \code{scale}.  This means that each predictor will have a regression coefficient of 1.0 when refitting the original model on this transformed X matrix, before any further scaling.  Plots will then show the relative effects over time, i.e., the slope of these combined columns over cuts on Y, so that deviations indicate non-parallelism.  But since in this case only relative effects are shown, a weak predictor may be interpreted as having an exagerrated y-dependency if \code{scale='none'}.  \code{terms} detauls to \code{TRUE} when \code{onlydata=TRUE}.}

\item{m}{the lowest cutoff is chosen as the first Y value having at meast \code{m} observations to its left, and the highest cutoff is chosen so that there are at least \code{m} observations tot he right of it.  Cutoffs are equally spaced between these values.  If omitted, \code{m} is set to the minimum of 50 and one quarter of the sample size.}

\item{maxcuts}{the maximum number of cutoffs analyzed}

\item{lp}{plot the effect of the linear predictor across cutpoints instead of analyzing individual predictors}

\item{onlydata}{set to \code{TRUE} to return a data frame suitable for modeling effects of cuts, instead of constructing a graph.  The returned data frame has variables \verb{Ycut, Yge_cut, obs}, and the original names of the predictors.  \code{Ycut} has the cutpoint on the original scale.  \code{Yge_cut} is \code{TRUE/FALSE} dependent on whether the Y variable is greater than or equal to \code{Ycut}, with \code{NA} if censoring prevented this determination.  The \code{obs} variable is useful for passing as the \code{cluster} argument to \code{\link[=robcov]{robcov()}} to account for the high correlations in regression coefficients across cuts.  See the example which computes Wald tests for parallelism where the \code{Ycut} dependence involves a spline function.  But since \code{terms} was used, each predictor is reduced to a single degree of freedom.}

\item{scale}{applies to \code{terms=TRUE}; set to \code{'none'} to leave the predictor terms scaled by regression coefficient so the coefficient of each term in the overall fit is 1.0.  The default is to scale terms by the interquartile-range (Gini's mean difference if IQR is zero) of the term.  This prevents changes in weak predictors over different cutoffs from being impressive.}

\item{conf.int}{confidence level for computing Wald confidence intervals for regression coefficients.  Set to 0 to suppress confidence bands.}

\item{alpha}{saturation for confidence bands}
}
\value{
\code{ggplot2} object or a data frame
}
\description{
\code{orm} models are refitted as a series of binary models for a sequence of cutoffs
on the dependent variable.  Regression coefficients from this sequence are plotted
against cutoffs using \code{ggplot2} with one panel per regression coefficient.
When censoring is present, whether or not Y is
greater than or equal to the current cutoff is not always possible, and such
observations are ignored.
}
\details{
Whenver a cut gives rise to extremely high standard error for a regression coefficient,
the confidence limits are set to \code{NA}.  Unreasonable standard errors are determined from
the confidence interval width exceeding 7 times the standard error at the middle Y cut.
}
\examples{
\dontrun{
f <- orm(..., x=TRUE, y=TRUE)
ordParallel(f, which=1:5)  # first 5 betas

getHdata(nhgh)
set.seed(1)
nhgh$ran <- runif(nrow(nhgh))
f <- orm(gh ~ rcs(age, 4) + ran, data=nhgh, x=TRUE, y=TRUE)
ordParallel(f)  # one panel per parameter (multiple parameters per predictor)
dd <- datadist(nhgh); options(datadist='dd')
ordParallel(f, terms=TRUE)
d <- ordParallel(f, maxcuts=30, onlydata=TRUE)
dd2 <- datadist(d); options(datadist='dd2')  # needed for plotting
g <- orm(Yge_cut ~ (age + ran) * rcs(Ycut, 4), data=d, x=TRUE, y=TRUE)
h <- robcov(g, d$obs)
anova(h)
qu <- quantile(d$age, c(1, 3)/4)
qu
cuts <- sort(unique(d$Ycut))
cuts
z <- contrast(h, list(age=qu[2], Ycut=cuts),
                 list(age=qu[1], Ycut=cuts))
z <- as.data.frame(z[.q(Ycut, Contrast, Lower, Upper)])
ggplot(z, aes(x=Ycut, y=Contrast)) + geom_line() +
  geom_ribbon(aes(ymin=Lower, ymax=Upper), alpha=0.2)
}
}
\author{
Frank Harrell
}
