% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{env_is_user_facing}
\alias{env_is_user_facing}
\title{Is frame environment user facing?}
\usage{
env_is_user_facing(env)
}
\arguments{
\item{env}{An environment.}
}
\description{
Detects if \code{env} is user-facing, that is, whether it's an environment
that inherits from:
\itemize{
\item The global environment, as would happen when called interactively
\item A package that is currently being tested
}

If either is true, we consider \code{env} to belong to an evaluation
frame that was called \emph{directly} by the end user. This is by
contrast to \emph{indirect} calls by third party functions which are not
user facing.

For instance the \href{https://lifecycle.r-lib.org/}{lifecycle} package
uses \code{env_is_user_facing()} to figure out whether a deprecated function
was called directly or indirectly, and select an appropriate
verbosity level as a function of that.
}
\section{Escape hatch}{


You can override the return value of \code{env_is_user_facing()} by
setting the global option \code{"rlang_user_facing"} to:
\itemize{
\item \code{TRUE} or \code{FALSE}.
\item A package name as a string. Then \code{env_is_user_facing(x)} returns
\code{TRUE} if \code{x} inherits from the namespace corresponding to that
package name.
}
}

\examples{
fn <- function() {
  env_is_user_facing(caller_env())
}

# Direct call of `fn()` from the global env
with(global_env(), fn())

# Indirect call of `fn()` from a package
with(ns_env("utils"), fn())
}
