% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geohash.R
\name{st_geohash}
\alias{st_geohash}
\title{compute geohash from (average) coordinates}
\usage{
st_geohash(x, precision = 0)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{precision}{integer; precision (length) of geohash returned. From the liblwgeom source: ``where the precision is non-positive, a precision based on the bounds of the feature. Big features have loose precision. Small features have tight precision.''}
}
\value{
character vector with geohashes
}
\description{
compute geohash from (average) coordinates
}
\details{
see \url{http://geohash.org/} or \url{https://en.wikipedia.org/wiki/Geohash}.
}
\examples{
library(sf)
lwgeom::st_geohash(st_sfc(st_point(c(1.5,3.5)), st_point(c(0,90))), 2)
lwgeom::st_geohash(st_sfc(st_point(c(1.5,3.5)), st_point(c(0,90))), 10)
}
