% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_parameters_mixed.R
\name{find_parameters.glmmTMB}
\alias{find_parameters.glmmTMB}
\alias{find_parameters.merMod}
\title{Find names of model parameters from mixed models}
\usage{
\method{find_parameters}{glmmTMB}(
  x,
  effects = c("all", "fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  flatten = FALSE,
  ...
)

\method{find_parameters}{merMod}(x, effects = c("all", "fixed", "random"), flatten = FALSE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{effects}{Should parameters for fixed effects, random effects
or both be returned? Only applies to mixed models. May be abbreviated.}

\item{component}{Which type of parameters to return, such as parameters for the
 conditional model, the zero-inflated part of the model, the dispersion
 term, the instrumental variables or marginal effects be returned? Applies
 to models with zero-inflated and/or dispersion formula, or to models with
 instrumental variables (so called fixed-effects regressions), or models
 with marginal effects from \pkg{mfx}. May be abbreviated. Note that the
\emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model. There are two convenient shortcuts:
If \code{component = "location"}, location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} are returned.
For \code{component = "distributional"} (or \code{"auxiliary"}), components
like \code{sigma}, \code{dispersion}, \code{beta} or \code{precision} (and
other auxiliary parameters) are returned.}

\item{flatten}{Logical, if \code{TRUE}, the values are returned
as character vector, not as list. Duplicated values are removed.}

\item{...}{Currently not used.}
}
\value{
A list of parameter names. The returned list may have following
  elements:
   \itemize{
     \item \code{conditional}, the "fixed effects" part from the model.
     \item \code{random}, the "random effects" part from the model.
     \item \code{zero_inflated}, the "fixed effects" part from the zero-inflation component of the model.
     \item \code{zero_inflated_random}, the "random effects" part from the zero-inflation component of the model.
     \item \code{dispersion}, the dispersion parameters (auxiliary parameter)
   }
}
\description{
Returns the names of model parameters, like they typically
    appear in the \code{summary()} output.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_parameters(m)
}
