% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_fast_greedy}
\alias{cluster_fast_greedy}
\alias{fastgreedy.community}
\title{Community structure via greedy optimization of modularity}
\usage{
cluster_fast_greedy(
  graph,
  merges = TRUE,
  modularity = TRUE,
  membership = TRUE,
  weights = NULL
)
}
\arguments{
\item{graph}{The input graph}

\item{merges}{Logical scalar, whether to return the merge matrix.}

\item{modularity}{Logical scalar, whether to return a vector containing the
modularity after each merge.}

\item{membership}{Logical scalar, whether to calculate the membership vector
corresponding to the maximum modularity score, considering all possible
community structures along the merges.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. A larger
edge weight means a stronger connection for this function.}
}
\value{
\code{cluster_fast_greedy} returns a \code{\link{communities}}
object, please see the \code{\link{communities}} manual page for details.
}
\description{
This function tries to find dense subgraph, also called communities in
graphs via directly optimizing a modularity score.
}
\details{
This function implements the fast greedy modularity optimization algorithm
for finding community structure, see A Clauset, MEJ Newman, C Moore: Finding
community structure in very large networks,
http://www.arxiv.org/abs/cond-mat/0408187 for the details.
}
\examples{

g <- make_full_graph(5) \%du\% make_full_graph(5) \%du\% make_full_graph(5)
g <- add_edges(g, c(1,6, 1,11, 6, 11))
fc <- cluster_fast_greedy(g)
membership(fc)
sizes(fc)

}
\references{
A Clauset, MEJ Newman, C Moore: Finding community structure in
very large networks, http://www.arxiv.org/abs/cond-mat/0408187
}
\seealso{
\code{\link{communities}} for extracting the results.

See also \code{\link{cluster_walktrap}},
\code{\link{cluster_spinglass}},
\code{\link{cluster_leading_eigen}} and
\code{\link{cluster_edge_betweenness}}, \code{\link{cluster_louvain}}
\code{\link{cluster_leiden}} for other methods.
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Gabor Csardi
\email{csardi.gabor@gmail.com} for the R interface.
}
\keyword{graphs}
