% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw_preview_weights.R
\name{aw_preview_weights}
\alias{aw_preview_weights}
\title{Preview Areal Weights}
\usage{
aw_preview_weights(.data, tid, source, sid, type)
}
\arguments{
\item{.data}{A \code{sf} object that data should be interpolated to (this is referred
to as the \code{target} elsewhere in the package).}

\item{tid}{A unique identification number within \code{target}}

\item{source}{A \code{sf} object with data to be interpolated}

\item{sid}{A unique identification number within \code{source}}

\item{type}{One of either \code{"extensive"} (if the data are spatitally extensive e.g.
population counts), \code{"intensive"} (if the data are spatially intensive e.g.
population density), or \code{"mixed"} (if the data include both extensive and
intensive values). If \code{"extensive"}, the sum is returned for the interpolated
value. If \code{"intensive"}, the mean is returned for the interpolated value.
If \code{"mixed"}, vectors named \code{"extensive"} and \code{"intensive"} containing
the relevant variable names should be specified in the dots.}
}
\value{
A tibble with the areal weights that would be used for interpolation if \code{type}
    is either \code{"extensive"} or \code{"intensive"}. If it is mixed, two tibbles (one for
    \code{"extensive"} and one for \code{"intensive"}) are returned as a list.
}
\description{
Provides a preview of the weight options for areal weighted interpolation.
    This can be useful for selecting the final specification for \code{aw_interpolate}
    without having to construct a pipeline of all of the subfunctions manually.
}
\examples{
aw_preview_weights(ar_stl_wards, tid = WARD, source = ar_stl_race, sid = GEOID,
                   type = "extensive")

aw_preview_weights(ar_stl_wards, tid = WARD, source = ar_stl_asthma, sid = GEOID,
                   type = "intensive")

}
