# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._container_host_mappings_operations import build_get_container_host_mapping_request

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ContainerHostMappingsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.devspaces.aio.DevSpacesManagementClient`'s
        :attr:`container_host_mappings` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def get_container_host_mapping(
        self,
        resource_group_name: str,
        location: str,
        container_host_mapping: _models.ContainerHostMapping,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Optional[_models.ContainerHostMapping]:
        """Returns container host mapping object for a container host resource ID if an associated
        controller exists.

        Returns container host mapping object for a container host resource ID if an associated
        controller exists.

        :param resource_group_name: Resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param location: Location of the container host. Required.
        :type location: str
        :param container_host_mapping: Required.
        :type container_host_mapping: ~azure.mgmt.devspaces.models.ContainerHostMapping
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContainerHostMapping or None or the result of cls(response)
        :rtype: ~azure.mgmt.devspaces.models.ContainerHostMapping or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_container_host_mapping(
        self,
        resource_group_name: str,
        location: str,
        container_host_mapping: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Optional[_models.ContainerHostMapping]:
        """Returns container host mapping object for a container host resource ID if an associated
        controller exists.

        Returns container host mapping object for a container host resource ID if an associated
        controller exists.

        :param resource_group_name: Resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param location: Location of the container host. Required.
        :type location: str
        :param container_host_mapping: Required.
        :type container_host_mapping: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContainerHostMapping or None or the result of cls(response)
        :rtype: ~azure.mgmt.devspaces.models.ContainerHostMapping or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def get_container_host_mapping(
        self,
        resource_group_name: str,
        location: str,
        container_host_mapping: Union[_models.ContainerHostMapping, IO],
        **kwargs: Any
    ) -> Optional[_models.ContainerHostMapping]:
        """Returns container host mapping object for a container host resource ID if an associated
        controller exists.

        Returns container host mapping object for a container host resource ID if an associated
        controller exists.

        :param resource_group_name: Resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param location: Location of the container host. Required.
        :type location: str
        :param container_host_mapping: Is either a model type or a IO type. Required.
        :type container_host_mapping: ~azure.mgmt.devspaces.models.ContainerHostMapping or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContainerHostMapping or None or the result of cls(response)
        :rtype: ~azure.mgmt.devspaces.models.ContainerHostMapping or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2019-04-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.ContainerHostMapping]]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(container_host_mapping, (IO, bytes)):
            _content = container_host_mapping
        else:
            _json = self._serialize.body(container_host_mapping, "ContainerHostMapping")

        request = build_get_container_host_mapping_request(
            resource_group_name=resource_group_name,
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.get_container_host_mapping.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DevSpacesErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ContainerHostMapping", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_container_host_mapping.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevSpaces/locations/{location}/checkContainerHostMapping"}  # type: ignore
