/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.search.test;

import com.sourceforge.knecs.dsm.search.QueryPredicate;
import com.sourceforge.knecs.dsm.search.Search;
import com.sourceforge.knecs.dsm.util.DAVResource;
import com.sourceforge.knecs.security.jaas.CMCSNameHandler;
import com.sourceforge.knecs.security.jaas.JAASUtils;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.security.auth.login.LoginContext;

public class SearchTest {
    private SearchTest(String[] args) {
        QueryPredicate qp;
        int i;
        Logger log = LoggerUtils.getLogger(this);
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String context = props.getProperty("logincontext");
        String account = props.getProperty("portalid");
        String mHoststr = svr + props.getProperty("teamhomepublic");
        try {
            JAASUtils.initLoginConfig(this.getClass());
        }
        catch (SecurityException se) {
            log.severe("Unable to initialize JAAS config " + se.getMessage());
            System.exit(-1);
        }
        String[] casstr = null;
        String[] namestr = null;
        String[] formulastr = null;
        String[] creatorstr = null;
        String[] chempropstr = null;
        String[] keystr = null;
        String[] tempstr = new String[]{};
        for (i = 0; i < args.length; ++i) {
            log.info("arg " + i + ": " + args[i]);
        }
        i = 0;
        int j = 0;
        Vector<String> params = new Vector<String>();
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                j = i++;
                while (i < args.length && !args[i].startsWith("-")) {
                    params.add(args[i]);
                    ++i;
                }
            }
            if (args[j].equals("-cas")) {
                casstr = params.toArray(tempstr);
            } else if (args[j].equals("-name")) {
                namestr = params.toArray(tempstr);
            } else if (args[j].equals("-formula")) {
                formulastr = params.toArray(tempstr);
            } else if (args[j].equals("-creator")) {
                creatorstr = params.toArray(tempstr);
            } else if (args[j].equals("-chemprop")) {
                chempropstr = params.toArray(tempstr);
            } else if (args[j].equals("-key")) {
                keystr = params.toArray(tempstr);
            }
            params.clear();
        }
        Hashtable<NSProperty, QueryPredicate> query = new Hashtable<NSProperty, QueryPredicate>();
        if (mHoststr != null && !mHoststr.endsWith("/")) {
            mHoststr = mHoststr + "/";
        }
        if (casstr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("speciescas"), casstr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("speciescas"), qp);
        }
        if (namestr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("speciesname"), namestr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("speciesname"), qp);
        }
        if (formulastr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("speciesformula"), formulastr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("speciesformula"), qp);
        }
        if (creatorstr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("creator"), creatorstr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("creator"), qp);
        }
        if (chempropstr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("chemicalproperty"), chempropstr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("chemicalproperty"), qp);
        }
        if (keystr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("keyword"), keystr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("keyword"), qp);
        }
        Vector resourceProps = CMCSProperties.getPropertyAsNSPropertyVector("explorerpropertylist");
        HashSet returnProperties = new HashSet(resourceProps);
        log.info("Query Predicates: " + query.toString());
        log.info("\n");
        log.info("Properties to return: " + returnProperties.toString());
        log.info("\n");
        try {
            LoginContext lc = new LoginContext(context, new CMCSNameHandler(account));
            lc.login();
            PasswordAuthentication pa = JAASUtils.subjectToDSICredentials(lc.getSubject());
            Search srch = new Search();
            Vector results = srch.run(mHoststr, pa.getUserName(), new String(pa.getPassword()), returnProperties, query, Integer.MAX_VALUE);
            log.info("Got " + results.size() + " matches");
            for (i = 0; i < results.size(); ++i) {
                DAVResource entry = (DAVResource)results.elementAt(i);
                log.info(entry.toString());
            }
            lc.logout();
        }
        catch (Exception ex) {
            log.severe("errmsg: " + ex.toString());
        }
    }

    public static void main(String[] args) {
        SearchTest st = new SearchTest(args);
    }
}

