<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Iterator Statistics

> Standard library functions for computing statistics over iterators.

<section class="usage">

## Usage

```javascript
var ns = require( '@stdlib/stats/iter' );
```

#### ns

Standard library functions for computing statistics over iterators.

```javascript
var o = ns;
// returns {...}
```

<!-- <toc pattern="*"> -->

<div class="namespace-toc">

-   <span class="signature">[`itercugmean( iterator )`][@stdlib/stats/iter/cugmean]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative geometric mean.</span>
-   <span class="signature">[`itercuhmean( iterator )`][@stdlib/stats/iter/cuhmean]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative harmonic mean.</span>
-   <span class="signature">[`itercumax( iterator )`][@stdlib/stats/iter/cumax]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative maximum value.</span>
-   <span class="signature">[`itercumaxabs( iterator )`][@stdlib/stats/iter/cumaxabs]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative maximum absolute value.</span>
-   <span class="signature">[`itercumean( iterator )`][@stdlib/stats/iter/cumean]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative arithmetic mean.</span>
-   <span class="signature">[`itercumeanabs( iterator )`][@stdlib/stats/iter/cumeanabs]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative arithmetic mean of absolute values.</span>
-   <span class="signature">[`itercumeanabs2( iterator )`][@stdlib/stats/iter/cumeanabs2]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative arithmetic mean of squared absolute values.</span>
-   <span class="signature">[`itercumidrange( iterator )`][@stdlib/stats/iter/cumidrange]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative mid-range.</span>
-   <span class="signature">[`itercumin( iterator )`][@stdlib/stats/iter/cumin]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative minimum value.</span>
-   <span class="signature">[`itercuminabs( iterator )`][@stdlib/stats/iter/cuminabs]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative minimum absolute value.</span>
-   <span class="signature">[`itercuprod( iterator )`][@stdlib/stats/iter/cuprod]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative product.</span>
-   <span class="signature">[`itercurange( iterator )`][@stdlib/stats/iter/curange]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative range.</span>
-   <span class="signature">[`itercusum( iterator )`][@stdlib/stats/iter/cusum]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative sum.</span>
-   <span class="signature">[`itercusumabs( iterator )`][@stdlib/stats/iter/cusumabs]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative sum of absolute values.</span>
-   <span class="signature">[`itercusumabs2( iterator )`][@stdlib/stats/iter/cusumabs2]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a cumulative sum of squared absolute values.</span>
-   <span class="signature">[`itermax( iterator )`][@stdlib/stats/iter/max]</span><span class="delimiter">: </span><span class="description">compute the maximum value of all iterated values.</span>
-   <span class="signature">[`itermaxabs( iterator )`][@stdlib/stats/iter/maxabs]</span><span class="delimiter">: </span><span class="description">compute the maximum absolute value of all iterated values.</span>
-   <span class="signature">[`itermean( iterator )`][@stdlib/stats/iter/mean]</span><span class="delimiter">: </span><span class="description">compute the arithmetic mean over all iterated values.</span>
-   <span class="signature">[`itermeanabs( iterator )`][@stdlib/stats/iter/meanabs]</span><span class="delimiter">: </span><span class="description">compute the arithmetic mean of absolute values for all iterated values.</span>
-   <span class="signature">[`itermeanabs2( iterator )`][@stdlib/stats/iter/meanabs2]</span><span class="delimiter">: </span><span class="description">compute the arithmetic mean of squared absolute values for all iterated values.</span>
-   <span class="signature">[`itermidrange( iterator )`][@stdlib/stats/iter/midrange]</span><span class="delimiter">: </span><span class="description">compute the mid-range of all iterated values.</span>
-   <span class="signature">[`itermin( iterator )`][@stdlib/stats/iter/min]</span><span class="delimiter">: </span><span class="description">compute the minimum value of all iterated values.</span>
-   <span class="signature">[`iterminabs( iterator )`][@stdlib/stats/iter/minabs]</span><span class="delimiter">: </span><span class="description">compute the minimum absolute value of all iterated values.</span>
-   <span class="signature">[`itermmax( iterator, W )`][@stdlib/stats/iter/mmax]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving maximum value.</span>
-   <span class="signature">[`itermmaxabs( iterator, W )`][@stdlib/stats/iter/mmaxabs]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving maximum absolute value.</span>
-   <span class="signature">[`itermmean( iterator, W )`][@stdlib/stats/iter/mmean]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving arithmetic mean.</span>
-   <span class="signature">[`itermmeanabs( iterator, W )`][@stdlib/stats/iter/mmeanabs]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving arithmetic mean of absolute values.</span>
-   <span class="signature">[`itermmeanabs2( iterator, W )`][@stdlib/stats/iter/mmeanabs2]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving arithmetic mean of squared absolute values.</span>
-   <span class="signature">[`itermmidrange( iterator, W )`][@stdlib/stats/iter/mmidrange]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving mid-range.</span>
-   <span class="signature">[`itermmin( iterator, W )`][@stdlib/stats/iter/mmin]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving minimum value.</span>
-   <span class="signature">[`itermminabs( iterator, W )`][@stdlib/stats/iter/mminabs]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving minimum absolute value.</span>
-   <span class="signature">[`itermprod( iterator, W )`][@stdlib/stats/iter/mprod]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving product.</span>
-   <span class="signature">[`itermrange( iterator, W )`][@stdlib/stats/iter/mrange]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving range.</span>
-   <span class="signature">[`itermsum( iterator, W )`][@stdlib/stats/iter/msum]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving sum.</span>
-   <span class="signature">[`itermsumabs( iterator, W )`][@stdlib/stats/iter/msumabs]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving sum of absolute values.</span>
-   <span class="signature">[`itermsumabs2( iterator, W )`][@stdlib/stats/iter/msumabs2]</span><span class="delimiter">: </span><span class="description">create an iterator which iteratively computes a moving sum of squared absolute values.</span>
-   <span class="signature">[`iterprod( iterator )`][@stdlib/stats/iter/prod]</span><span class="delimiter">: </span><span class="description">compute the product of all iterated values.</span>
-   <span class="signature">[`iterrange( iterator )`][@stdlib/stats/iter/range]</span><span class="delimiter">: </span><span class="description">compute the range of all iterated values.</span>
-   <span class="signature">[`iterstdev( iterator[, mean] )`][@stdlib/stats/iter/stdev]</span><span class="delimiter">: </span><span class="description">compute the corrected sample standard deviation over all iterated values.</span>
-   <span class="signature">[`itersum( iterator )`][@stdlib/stats/iter/sum]</span><span class="delimiter">: </span><span class="description">compute the sum of all iterated values.</span>
-   <span class="signature">[`itersumabs( iterator )`][@stdlib/stats/iter/sumabs]</span><span class="delimiter">: </span><span class="description">compute the sum of absolute values for all iterated values.</span>
-   <span class="signature">[`itersumabs2( iterator )`][@stdlib/stats/iter/sumabs2]</span><span class="delimiter">: </span><span class="description">compute the sum of squared absolute values for all iterated values.</span>
-   <span class="signature">[`itervariance( iterator[, mean] )`][@stdlib/stats/iter/variance]</span><span class="delimiter">: </span><span class="description">compute the unbiased sample variance over all iterated values.</span>

</div>

<!-- </toc> -->

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better examples -->

<!-- eslint no-undef: "error" -->

```javascript
var getKeys = require( '@stdlib/utils/keys' );
var ns = require( '@stdlib/stats/iter' );

console.log( getKeys( ns ) );
```

</section>

<!-- /.examples -->

<section class="links">

<!-- <toc-links> -->

[@stdlib/stats/iter/cugmean]: https://github.com/stdlib-js/stats/tree/main/iter/cugmean

[@stdlib/stats/iter/cuhmean]: https://github.com/stdlib-js/stats/tree/main/iter/cuhmean

[@stdlib/stats/iter/cumax]: https://github.com/stdlib-js/stats/tree/main/iter/cumax

[@stdlib/stats/iter/cumaxabs]: https://github.com/stdlib-js/stats/tree/main/iter/cumaxabs

[@stdlib/stats/iter/cumean]: https://github.com/stdlib-js/stats/tree/main/iter/cumean

[@stdlib/stats/iter/cumeanabs]: https://github.com/stdlib-js/stats/tree/main/iter/cumeanabs

[@stdlib/stats/iter/cumeanabs2]: https://github.com/stdlib-js/stats/tree/main/iter/cumeanabs2

[@stdlib/stats/iter/cumidrange]: https://github.com/stdlib-js/stats/tree/main/iter/cumidrange

[@stdlib/stats/iter/cumin]: https://github.com/stdlib-js/stats/tree/main/iter/cumin

[@stdlib/stats/iter/cuminabs]: https://github.com/stdlib-js/stats/tree/main/iter/cuminabs

[@stdlib/stats/iter/cuprod]: https://github.com/stdlib-js/stats/tree/main/iter/cuprod

[@stdlib/stats/iter/curange]: https://github.com/stdlib-js/stats/tree/main/iter/curange

[@stdlib/stats/iter/cusum]: https://github.com/stdlib-js/stats/tree/main/iter/cusum

[@stdlib/stats/iter/cusumabs]: https://github.com/stdlib-js/stats/tree/main/iter/cusumabs

[@stdlib/stats/iter/cusumabs2]: https://github.com/stdlib-js/stats/tree/main/iter/cusumabs2

[@stdlib/stats/iter/max]: https://github.com/stdlib-js/stats/tree/main/iter/max

[@stdlib/stats/iter/maxabs]: https://github.com/stdlib-js/stats/tree/main/iter/maxabs

[@stdlib/stats/iter/mean]: https://github.com/stdlib-js/stats/tree/main/iter/mean

[@stdlib/stats/iter/meanabs]: https://github.com/stdlib-js/stats/tree/main/iter/meanabs

[@stdlib/stats/iter/meanabs2]: https://github.com/stdlib-js/stats/tree/main/iter/meanabs2

[@stdlib/stats/iter/midrange]: https://github.com/stdlib-js/stats/tree/main/iter/midrange

[@stdlib/stats/iter/min]: https://github.com/stdlib-js/stats/tree/main/iter/min

[@stdlib/stats/iter/minabs]: https://github.com/stdlib-js/stats/tree/main/iter/minabs

[@stdlib/stats/iter/mmax]: https://github.com/stdlib-js/stats/tree/main/iter/mmax

[@stdlib/stats/iter/mmaxabs]: https://github.com/stdlib-js/stats/tree/main/iter/mmaxabs

[@stdlib/stats/iter/mmean]: https://github.com/stdlib-js/stats/tree/main/iter/mmean

[@stdlib/stats/iter/mmeanabs]: https://github.com/stdlib-js/stats/tree/main/iter/mmeanabs

[@stdlib/stats/iter/mmeanabs2]: https://github.com/stdlib-js/stats/tree/main/iter/mmeanabs2

[@stdlib/stats/iter/mmidrange]: https://github.com/stdlib-js/stats/tree/main/iter/mmidrange

[@stdlib/stats/iter/mmin]: https://github.com/stdlib-js/stats/tree/main/iter/mmin

[@stdlib/stats/iter/mminabs]: https://github.com/stdlib-js/stats/tree/main/iter/mminabs

[@stdlib/stats/iter/mprod]: https://github.com/stdlib-js/stats/tree/main/iter/mprod

[@stdlib/stats/iter/mrange]: https://github.com/stdlib-js/stats/tree/main/iter/mrange

[@stdlib/stats/iter/msum]: https://github.com/stdlib-js/stats/tree/main/iter/msum

[@stdlib/stats/iter/msumabs]: https://github.com/stdlib-js/stats/tree/main/iter/msumabs

[@stdlib/stats/iter/msumabs2]: https://github.com/stdlib-js/stats/tree/main/iter/msumabs2

[@stdlib/stats/iter/prod]: https://github.com/stdlib-js/stats/tree/main/iter/prod

[@stdlib/stats/iter/range]: https://github.com/stdlib-js/stats/tree/main/iter/range

[@stdlib/stats/iter/stdev]: https://github.com/stdlib-js/stats/tree/main/iter/stdev

[@stdlib/stats/iter/sum]: https://github.com/stdlib-js/stats/tree/main/iter/sum

[@stdlib/stats/iter/sumabs]: https://github.com/stdlib-js/stats/tree/main/iter/sumabs

[@stdlib/stats/iter/sumabs2]: https://github.com/stdlib-js/stats/tree/main/iter/sumabs2

[@stdlib/stats/iter/variance]: https://github.com/stdlib-js/stats/tree/main/iter/variance

<!-- </toc-links> -->

</section>

<!-- /.links -->
