/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/*
* When adding modules to the namespace, ensure that they are added in alphabetical order according to module name.
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-read-only-property' );


// MAIN //

/**
* Top-level namespace.
*
* @namespace ns
*/
var ns = {};

/**
* @name arrayfcn
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/assert/tools/array-function}
*/
setReadOnly( ns, 'arrayfcn', require( './../../tools/array-function' ) );

/**
* @name arraylikefcn
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/assert/tools/array-like-function}
*/
setReadOnly( ns, 'arraylikefcn', require( './../../tools/array-like-function' ) );

/**
* @name typedarrayfcn
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/assert/tools/typed-array-function}
*/
setReadOnly( ns, 'typedarrayfcn', require( './../../tools/typed-array-function' ) );


// EXPORTS //

module.exports = ns;
