.TH "{ImportOrig}" "1" "December 2009" "{ImportOrig} {Version}" "User Commands"

.SH NAME

{ImportOrig} - Import upstream source code tarballs into .deb package
Mercurial repository.

.SH SYNOPSIS

\fB{ImportOrig}\fR [\fIoption\fR] ... \fItarball\fR [\fItarball\fR] ...

.SH DESCRIPTION

Import upstream source tarballs into a Mercurial repository.  The first
tarball must be the main tarball, see \fBdpkg\-source\fR(1).  The
upstream sources are incorporated into the upstream branch, and merged
into the default branch.  It is possible to use \fB{ImportOrig}\fR
multiple times to import several versions, but the versions must be
imported sequentially starting with the earliest version.

For \fBdpkg\-source\fR(1) format 3.0 (quilt), all patches are removed
before the import, and you must manually reapply and refresh the
patches.  Finally you must commit the fully patched source, including
the .pc directory.

.SH OPTIONS

.HP
\fB\-\-version\fR, \fB\-V\fR
.IP
Output version and exit.

.HP
\fB\-\-verbose\fR, \fB\-v\fR
.IP
Increase verbosity level.  Can be used several times.

.HP
\fB\-\-no\-merge\fR, \fB\-n\fR
.IP
Do not merge imported upstream source into the default branch.  A manual
\fBhg merge upstream\fR will then have to be done at a later stage.
Remember to unapply all patches before the merge.

.SH EXAMPLES

.HP
\fB{ImportOrig}\fR ../mypack_1.2.orig.tar.bz2 ../mypack_1.2.orig\-plugin.tar.gz
.IP
Import upstream source from two tarballs into the repository in the
current directory, which requires the package to be in dpkg source
package format 3.0 (quilt), see \fBdpkg\-source\fR(1).  After the import,
both the upstream and default branch will have the tag mypack_1.2.

.SH AUTHOR

Jens Peter Secher <jpsecher@gmail.com>

.SH THANKS

The ideas for this package originates from John Goerzen's
\fBhg\-buildpackage\fR.

.SH SEE ALSO

\fB{ImportDsc}\fR(1),
\fB{BuildPackage}\fR(1),
\fB{TagVersion}\fR(1),
\fB{PristineTar}\fR(1),
\fB{Port}\fR(1).
