/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QString>
#include <QSvgRenderer>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/PolChemDef.hpp>
#include <MsXpS/libXpertMassCore/PolChemDefSpec.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "MonomerSpec.hpp"
#include "ModifSpec.hpp"
#include "CrossLinkerSpec.hpp"


namespace MsXpS
{
namespace MassXpert
{

class PolChemDef;

typedef std::shared_ptr<QSvgRenderer> QSvgRendererSPtr;
typedef std::shared_ptr<const QSvgRenderer> QSvgRendererCstSPtr;

class PolChemDefRendering
{
  public:
  PolChemDefRendering();
  PolChemDefRendering(libXpertMassCore::PolChemDefCstSPtr polChemDefCstSPtr);
  PolChemDefRendering(const PolChemDefRendering &other) = delete;

  virtual ~PolChemDefRendering();

  void setPolChemDefCstSPtr(libXpertMassCore::PolChemDefCstSPtr polChemDefCstSPtr);
  const libXpertMassCore::PolChemDefCstSPtr getPolChemDefCstSPtr() const;

  const std::map<QString, QSvgRendererSPtr> &
  getChemEntVignettesRenderersCstRef() const;
  std::map<QString, QSvgRendererSPtr> &getChemEntVignettesRenderersRef();

  QSvgRendererSPtr chemEntVignetteRenderer(const QString &key) const;

  QSvgRendererSPtr
  newChemEntVignetteRendererFromSvgFile(const QString &file_path,
                                        QObject *parent = nullptr) const;
  QSvgRendererSPtr
  newMonomerVignetteRendererFromMonomerCode(const QString &code,
                                            QObject *parent = nullptr);
  QSvgRendererSPtr
  newModifVignetteRendererFromModifName(const QString &modif_name,
                                        QObject *parent = nullptr);
  QSvgRendererSPtr
  newCrossLinkerVignetteRenderer(const QString &cross_linker_name,
                                 QObject *parent = nullptr);


  const std::vector<MonomerSpec> &getMonomerSpecsCstRef() const;
  std::vector<MonomerSpec> &getMonomerSpecsRef();
  MonomerSpec getMonomerSpec(const QString &code);

  const std::vector<ModifSpec> &getModifSpecsCstRef() const;
  std::vector<ModifSpec> &getModifSpecsRef();
  ModifSpec getModifSpec(const QString &code);

  const std::vector<CrossLinkerSpec> &getCrossLinkerSpecsCstRef() const;
  std::vector<CrossLinkerSpec> &getCrossLinkerSpecsRef();
  CrossLinkerSpec getCrossLinkerSpec(const QString &name);

  protected:
  libXpertMassCore::PolChemDefCstSPtr mcsp_polChemDef = nullptr;
  std::vector<MonomerSpec> m_monomerSpecs;
  std::vector<ModifSpec> m_modifSpecs;
  std::vector<CrossLinkerSpec> m_crossLinkerSpecs;
  std::map<QString, QSvgRendererSPtr> m_chemEntVignetteRenderers;
};

typedef std::unique_ptr<PolChemDefRendering> PolChemDefRenderingUPtr;
typedef PolChemDefRendering *PolChemDefRenderingRPtr;
typedef const PolChemDefRendering *PolChemDefRenderingCstRPtr;

} // namespace MassXpert
} // namespace MsXpS
