.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XReparentWindow __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XReparentWindow \- reparent windows
.SH SYNTAX
.HP
int XReparentWindow\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, Window
\fIparent\fP\^, int \fIx\fP\^, int \fIy\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIparent\fP 1i
Specifies the parent window.
.IP \fIw\fP 1i
Specifies the window.
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates of the position in the new parent window.
.SH DESCRIPTION
If the specified window is mapped,
.B XReparentWindow
automatically performs an
.B UnmapWindow
request on it, removes it from its current position in the hierarchy,
and inserts it as the child of the specified parent.
The window is placed in the stacking order on top with respect to
sibling windows.
.LP
After reparenting the specified window,
.B XReparentWindow
causes the X server to generate a
.B ReparentNotify
event.
The override_redirect member returned in this event is
set to the window's corresponding attribute.
Window manager clients usually should ignore this window if this member
is set to
.BR True .
Finally, if the specified window was originally mapped,
the X server automatically performs a
.B MapWindow
request on it.
.LP
The X server performs normal exposure processing on formerly obscured
windows.
The X server might not generate
.B Expose
events for regions from the initial
.B UnmapWindow
request that are immediately obscured by the final
.B MapWindow
request.
A
.B BadMatch
error results if:
.IP \(bu 5
The new parent window is not on the same screen as
the old parent window.
.IP \(bu 5
The new parent window is the specified window or an inferior of the
specified window.
.IP \(bu 5
The new parent is
.BR InputOnly ,
and the window is not.
.IP \(bu 5
The specified window has a
.B ParentRelative
background, and the new parent window is not the same depth as the
specified window.
.LP
.B XReparentWindow
can generate
.B BadMatch
and
.B BadWindow
errors.
.SH DIAGNOSTICS
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
.BR XChangeSaveSet (__libmansuffix__)
.br
\fI\*(xL\fP
