/**
 * \file pappsomspp/processing/cbor/psm/evalscan/psmfeatures.h
 * \date 15/07/2025
 * \author Olivier Langella
 * \brief compute features on scan's PSM
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "pappsomspp/core/processing/cbor/psm/psmfilescanprocessandcopy.h"
#include "pappsomspp/core/psm/xtandem/xtandemspectrumprocess.h"
#include "pappsomspp/core/psm/features/psmfeatures.h"
#include <QJsonObject>
#include "pappsomspp/export-import-config.h"

namespace pappso
{
namespace cbor
{
namespace psm
{

/**
 * @todo write docs
 */
class PMSPP_LIB_DECL PsmFeatures : public PsmFileScanProcessAndCopy
{
  public:
  /**
   * Default constructor
   */
  PsmFeatures(std::size_t buffer_scan_size, CborStreamWriter *cbor_output_p);
  PsmFeatures(std::size_t buffer_scan_size,
              CborStreamWriter *cbor_output_p,
              const QJsonObject &parameters);


  /**
   * Destructor
   */
  virtual ~PsmFeatures();


  protected:
  CborScanMapBase *newCborScanMap() override;

  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;

  private:
  pappso::XtandemSpectrumProcess m_tandemSpectrumProcess;
  double m_minimumMz = 150;
  std::list<pappso::Enums::PeptideIon> m_ionList;
  pappso::PrecisionPtr m_fragmentTolerance;
  pappso::PsmFeatures *mpa_psmFeatures;
};
} // namespace psm
} // namespace cbor
} // namespace pappso
