// Copyright 2019 Bloomberg Finance L.P
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <buildboxcommonmetrics_metriccollectorfactory.h>

namespace buildboxcommon {
namespace buildboxcommonmetrics {

MetricCollectorFactory *MetricCollectorFactory::getInstance()
{
    static MetricCollectorFactory instance;
    return &instance;
}

void MetricCollectorFactory::enableMetrics() { setMetricsEnabled(true); }

void MetricCollectorFactory::disableMetrics() { setMetricsEnabled(false); }

void MetricCollectorFactory::setMetricsEnabled(const bool enabled)
{
    d_metricsEnabled = enabled;
}

void MetricCollectorFactory ::setMetricsPrefix(const std::string &prefix)
{
    d_metricPrefix = prefix;
}

bool MetricCollectorFactory::metricsEnabled() const
{
    return d_metricsEnabled;
}

const std::string &MetricCollectorFactory::metricsPrefix() const
{
    return d_metricPrefix;
}

} // namespace buildboxcommonmetrics
} // namespace buildboxcommon
