/*
 * QuickSpellPanel.h, part of VCMI engine
 *
 * Authors: listed in file AUTHORS in main folder
 *
 * License: GNU General Public License v2.0 or later
 * Full text of license available in license.txt file, in main folder
 *
 */
#pragma once

#include "../gui/CIntObject.h"

class CFilledTexture;
class TransparentFilledRectangle;
class CButton;
class CLabel;
class BattleInterface;

class QuickSpellPanel : public CIntObject
{
private:
	std::shared_ptr<CFilledTexture> background;
	std::shared_ptr<TransparentFilledRectangle> rect;
	std::vector<std::shared_ptr<CButton>> buttons;
	std::vector<std::shared_ptr<TransparentFilledRectangle>> buttonsIsAutoGenerated;
	std::vector<std::shared_ptr<TransparentFilledRectangle>> buttonsDisabled;
	std::vector<std::shared_ptr<CLabel>> labels;

	BattleInterface & owner;

public:
	static constexpr int QUICKSPELL_SLOTS = 12;

	QuickSpellPanel(BattleInterface & owner);

	void create();

	std::vector<std::tuple<SpellID, bool>> getSpells() const;

	void show(Canvas & to) override;
	void inputModeChanged(InputMode modi) override;
};
