/* SPDX-FileCopyrightText: 2014-2025 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#include <gtksourceview/gtksource.h>

static void
test_remove_duplicates (void)
{
	GSList *list = NULL;
	GtkSourceEncoding *utf8;
	GtkSourceEncoding *iso;

	utf8 = gtk_source_encoding_new_utf8 ();
	iso = gtk_source_encoding_new ("ISO-8859-15");

	/* Before: [UTF-8, ISO-8859-15, UTF-8] */
	list = g_slist_prepend (list, gtk_source_encoding_copy (utf8));
	list = g_slist_prepend (list, gtk_source_encoding_copy (iso));
	list = g_slist_prepend (list, gtk_source_encoding_copy (utf8));

	/* After: [UTF-8, ISO-8859-15] */
	list = gtk_source_encoding_remove_duplicates (list, GTK_SOURCE_ENCODING_DUPLICATES_KEEP_FIRST);

	g_assert_cmpint (2, ==, g_slist_length (list));
	g_assert_true (gtk_source_encoding_equals (list->data, utf8));
	g_assert_true (gtk_source_encoding_equals (list->next->data, iso));

	/* Before: [UTF-8, ISO-8859-15, UTF-8] */
	list = g_slist_append (list, gtk_source_encoding_copy (utf8));

	/* After: [ISO-8859-15, UTF-8] */
	list = gtk_source_encoding_remove_duplicates (list, GTK_SOURCE_ENCODING_DUPLICATES_KEEP_LAST);

	g_assert_cmpint (2, ==, g_slist_length (list));
	g_assert_true (gtk_source_encoding_equals (list->data, iso));
	g_assert_true (gtk_source_encoding_equals (list->next->data, utf8));

	g_slist_free_full (list, (GDestroyNotify)gtk_source_encoding_free);
	gtk_source_encoding_free (utf8);
	gtk_source_encoding_free (iso);
}

int
main (int    argc,
      char **argv)
{
	gtk_test_init (&argc, &argv);

	g_test_add_func ("/Encoding/remove_duplicates", test_remove_duplicates);

	return g_test_run ();
}
