!= Ѽ黻 (==) Τδؿ
!= Functions for user defined operation (==)
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcdatetimeeq.f90,v 1.1 2009-05-25 10:01:34 morikawa Exp $
! Tag Name::  $Name: gtool5-20101228-1 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
  logical function dcdatetime_eq_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! Ʊ, .true. ֤ޤ.
    !
    use dc_date_generic, only: Eval, EvalSclSec, ZoneToDiff
    use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(==), operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), assignment(=)
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
    type(DC_SCALED_SEC):: year1, year2, time1_sec, time2_sec
  continue
    call Eval(time1, sclyear=year1)
    call Eval(time2, sclyear=year2)
    time1_sec = EvalSclSec(time1) + EvalSclSec(ZoneToDiff(time1 % zone))
    time2_sec = EvalSclSec(time2) + EvalSclSec(ZoneToDiff(time2 % zone))
    if (year1 == year2 .and. time1_sec == time2_sec) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdatetime_eq_tt


  logical function dcdatetime_eq_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! Ʊ, .true. ֤ޤ.
    !
    use dc_scaledsec, only: operator(==)
    use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    if (       diff1 % mon == diff2 % mon &
      &  .and. diff1 % day == diff2 % day &
      &  .and. diff1 % sec == diff2 % sec   ) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdatetime_eq_ff

  logical function dcdatetime_eq_if(i, diff) result(result)
    !
    !  *diff*  *i* ɤӤޤ. *diff*
    ! ÿ˴ͤ *i* Ȥ, .true. ֤ޤ.
    !
    use dc_date_generic, only: operator(==)
    use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: i
  continue
    result = real(i) == diff
  end function dcdatetime_eq_if

  logical function dcdatetime_eq_fi(diff, i) result(result)
    use dc_date_generic, only: operator(==)
    use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: i
  continue
    result = i == diff
  end function dcdatetime_eq_fi

  logical function dcdatetime_eq_rf(r, diff) result(result)
    !
    !  *diff*  *r* ɤӤޤ. *diff*
    ! ÿ˴ͤ *r* Ȥ, .true. ֤ޤ.
    !
    use dc_scaledsec, only: operator(==)
    use dc_date_generic, only: EvalSclSec
    use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: r
  continue
    if (EvalSclSec(diff) == r) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdatetime_eq_rf

  logical function dcdatetime_eq_fr(diff, r) result(result)
    use dc_date_generic, only: operator(==)
    use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: r
  continue
    result = r == diff
  end function dcdatetime_eq_fr

  logical function dcdatetime_eq_df(d, diff) result(result)
    !
    !  *diff*  *d* ɤӤޤ. *diff*
    ! ÿ˴ͤ *d* Ȥ, .true. ֤ޤ.
    !
    use dc_date_generic, only: EvalSclSec
    use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
    use dc_scaledsec, only: operator(==)
    use dc_types, only: DP
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: d
  continue
    if (EvalSclSec(diff) == d) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdatetime_eq_df

  logical function dcdatetime_eq_fd(diff, d) result(result)
    use dc_date_generic, only: operator(==)
    use dc_types, only: DP
    use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: d
  continue
    result = d == diff
  end function dcdatetime_eq_fd
