%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkGraphics_typemaps.i


%{
#include "vtkDataObjectToDataSetFilter.h"
%}

%import vtkSource.h


%{
extern void vtkDataObjectToDataSetFilter_freefunc(void *ptr)
{
    vtkDataObjectToDataSetFilter *obj;
    obj = (vtkDataObjectToDataSetFilter*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetDimensions()
}
%ignore GetDimensions(int data[3]);
%ignore GetDimensions(int _arg[3]);
%ignore GetDimensions(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetOrigin()
}
%ignore GetOrigin(double data[3]);
%ignore GetOrigin(double _arg[3]);
%ignore GetOrigin(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetSpacing()
}
%ignore GetSpacing(double data[3]);
%ignore GetSpacing(double _arg[3]);
%ignore GetSpacing(double &_arg1,double &_arg2,double &_arg3);

%include vtkDataObjectToDataSetFilter.h
